#ifndef CUSTOMTABLEWIDGET_H
#define CUSTOMTABLEWIDGET_H

#include <QTableWidget>
#include <QDir>

class CTWorkingThread;

class CustomTableWidget : public QTableWidget
{
Q_OBJECT
public:
    explicit CustomTableWidget(QWidget *parent = 0);
    ~CustomTableWidget();

    bool
    populateCustomTableWidget( const QString &dirPath );


signals:
    void
    pathUpdated( const QString &path );
    void
    pictureSelected( const QString &path );

public slots:
    void
    refreshTableWidgetPicture( int i,
                               int j,
                               const QImage &picture);
    void
    tWcdUp();

    void
    refreshTable();

private slots:
    void
    itemDoubleClicked( int i, int j);

private:
    //
    //  Number of table columns;
    //
    static const int colomnNo;


    //
    //  Working thread used for creation of the thumbnails pictures
    //
    CTWorkingThread *wthread;

    QString currentPath;

};

#endif // CUSTOMTABLEWIDGET_H
