//-----------------------------------------------------------------------------
#include "Settings.h"
//-----------------------------------------------------------------------------

#include "common/Language.h"

#include <QSettings>

#include <QDebug>

//-----------------------------------------------------------------------------
Settings::Settings(QObject* a_parent):
  QObject(a_parent)
{
  m_changed = ChangeFlag_None;

  m_langSource = Language_Russian;
  m_langTarget = Language_Finnish;
}

//-----------------------------------------------------------------------------
Settings::~Settings()
{
}

//-----------------------------------------------------------------------------
void Settings::load()
{
  qDebug() << "Settings::load()";

  QSettings settings;

  m_openDir = settings.value("openDir", m_openDir).toString();
  m_langSource = settings.value("langSource", m_langSource).toInt();
  m_langTarget = settings.value("langTarget", m_langTarget).toInt();

  m_changed = ChangeFlag_None;
}

//-----------------------------------------------------------------------------
void Settings::save()
{
  if(m_changed == ChangeFlag_None)
  {
    qDebug() << "Settings::save(): no need to save";
    return;
  }

  qDebug() << "Settings::save()";

  QSettings settings;

  settings.setValue("openDir", m_openDir);
  settings.setValue("langSource", m_langSource);
  settings.setValue("langTarget", m_langTarget);

  emit settingsChanged(m_changed);

  m_changed = ChangeFlag_None;
}

//-----------------------------------------------------------------------------
int Settings::langSource() const
{
  return m_langSource;
}

//-----------------------------------------------------------------------------
void Settings::setLangSource(int a)
{
  if(m_langSource != a)
    m_changed |= ChangeFlag_LangSource;

  m_langSource = a;
}

//-----------------------------------------------------------------------------
int Settings::langTarget() const
{
  return m_langTarget;
}

//-----------------------------------------------------------------------------
void Settings::setLangTarget(int a)
{
  if(m_langTarget != a)
    m_changed |= ChangeFlag_LangTarget;

  m_langTarget = a;
}

//-----------------------------------------------------------------------------
const QList<int>& Settings::supportedLangSource() const
{
  return m_supportedSourceLang;
}

//-----------------------------------------------------------------------------
void Settings::setSupportedLangSource(const QList<int>& a)
{
  m_supportedSourceLang = a;
}

//-----------------------------------------------------------------------------
const QList<int>& Settings::supportedLangTarget() const
{
  return m_supportedTargetLang;
}

//-----------------------------------------------------------------------------
void Settings::setSupportedLangTarget(const QList<int>& a)
{
  m_supportedTargetLang = a;
}

//-----------------------------------------------------------------------------
const QString& Settings::openDir() const
{
  return m_openDir;
}

//-----------------------------------------------------------------------------
void Settings::setOpenDir(const QString& a)
{
  if(m_openDir != a)
    m_changed |= ChangeFlag_OpenDir;

  m_openDir = a;
}

//-----------------------------------------------------------------------------
