//-----------------------------------------------------------------------------
#include "View.h"
//-----------------------------------------------------------------------------

#include "Application.h"
#include "Context.h"
#include "settings/Settings.h"
#include "settings/SettingsDialog.h"

#include <QMenuBar>

#ifdef Q_WS_MAEMO_5
  #include <QtMaemo5/QMaemo5InformationBox>
#else
  #include <QMessageBox>
#endif

#include <QDebug>

//-----------------------------------------------------------------------------
View::View(Context* a_context, QWidget* a_parent):
  QMainWindow(a_parent),
  m_context(a_context)
{
  #ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
  #endif

  if(a_parent)
    setAttribute(Qt::WA_DeleteOnClose);

  m_actSettings = menuBar()->addAction(tr("Settings"), this, SLOT(showSettings()));
}

//-----------------------------------------------------------------------------
View::~View()
{
  qDebug() << "View::~View()";

  m_context = NULL;
}

//-----------------------------------------------------------------------------
void View::showSettings()
{
  // Show settings
  SettingsDialog dialog(this);
  dialog.initialize(m_context->settings());
  int iResult = dialog.exec();

  // Save?
  if(iResult == QDialog::Accepted)
    m_context->settings()->save();
}

//-----------------------------------------------------------------------------
void View::toggleBusy(bool a_busy)
{
  #ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, a_busy);
  #else
    if(a_busy)
      QApplication::setOverrideCursor(Qt::WaitCursor);
    else
      QApplication::restoreOverrideCursor();
  #endif
}

//-----------------------------------------------------------------------------
void View::showError(const QString& a_error)
{
  #ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(this, a_error, QMaemo5InformationBox::NoTimeout);
  #else
    QMessageBox::critical(this, "Error", a_error, QMessageBox::Ok);
  #endif
}

//-----------------------------------------------------------------------------

