import QtQuick 1.0
import QtMobility.sensors 1.2
import Qt 4.7
import QtMultimediaKit 1.1
import SpaceInvaders 1.0

import "storage.js" as Storage;
import "sizer.js" as Sizer;
import "logic.js" as Logic

Rectangle {
    id: board
    color: "#000000"
    width: 640
    height:  360

    ColorAnimation on color {id:flashanim; from: "#999999"; to: "black"; duration: 200 }

    MouseArea {
           id: themousearea
           x: 0
           y: 30

           drag.minimumY: -1000
           drag.minimumX: -1000
           drag.maximumY: 1000
           drag.maximumX: 1000
           anchors.rightMargin: 0
           anchors.bottomMargin: 1
           anchors.leftMargin: 0
           anchors.topMargin: 30
           anchors.fill: board
           onPressed: {
                Logic.screenTap();
           }
       }

    Text {
        id: scoretext
        text: "Score: 0"
        color: "#ffffff"
        x: 5
        y: 5
    }

    Text {
        id: leveltext
        text: "Level: 0"
        color: "#ffffff"
        y: 5
        anchors.horizontalCenter: board.horizontalCenter
    }

    /*
    Text {
        id: statetext
        text: gameState
        color: "white"
        y:5
        anchors.left: scoretext.right
        anchors.leftMargin: 10
    }
    */

    Text {
        id: starttext
        text: "Tap screen to start"
        color: "#ffffff"
        anchors.horizontalCenter: board.horizontalCenter
        anchors.verticalCenter: board.verticalCenter
    }

    Rectangle {
        id: messagecontainer
        color: "black"
        height: messagetext.height + 20
        width:  board.width
        visible: true
        state: "HIDDEN"
        border.width: 5
        border.color: "#00ff00"

        z:20

        states: [
            State {
                name: "HIDDEN"
                PropertyChanges { target: messagecontainer; y: board.height + 5}
            },
            State {
                name: "VISIBLE"
                PropertyChanges { target: messagecontainer; y: (board.height - messagecontainer.height)}
            }
        ]

        transitions: Transition {
            NumberAnimation { properties: "y"; easing.type: Easing.InOutQuad }
        }

        Text {
            id: messagetext
            text: ""
            font.pixelSize: 20
            font.bold: true
            color: "#00ff00"
            anchors.horizontalCenter: messagecontainer.horizontalCenter
            anchors.verticalCenter: messagecontainer.verticalCenter
            visible: true

            Timer {
                id: messagetimer
                interval:  1000
                running: false
                repeat: false
                onRunningChanged: {
                    if (messagetimer.running) {
                        messagecontainer.state = "VISIBLE";
                    }
                }

                onTriggered: {
                    messagecontainer.state = "HIDDEN";
                }
            }
        }
    }


    Ship {
        id:ship
        x: (board.width - ship.width) / 2;
        y: board.height - (ship.height * 2) - 3;
    }

    Timer {
             id: heartbeat;
             interval: 50
             running: false;
             repeat: true;
             onTriggered: Logic.mainEvent();
         }

    Timer {
        id: alienanimation
        interval:  600
        running: false
        repeat: true
        onTriggered: Logic.moveAliens()
    }

    Timer  {
        id: deadtimer
        interval: 5000
        running: false
        repeat: false
        onTriggered: {
            Logic.cmdNotRunning();
        }
    }

    Image {
        id: closebutton

        source: "pics/close.png"
        width: 35
        height: 35
        anchors.right: parent.right
        anchors.rightMargin: 0
        anchors.top: parent.top
        anchors.topMargin: 0
        fillMode: Image.PreserveAspectFit
        smooth: false

        MouseArea {
               id: closearea
               anchors.fill: parent
               onPressed: {
                   exitPressed();
               }
               }
           }

    Image {
        id: menubutton

        source: "pics/menu.png"
        width: 35
        height: 35
        anchors.right: closebutton.left
        anchors.rightMargin: closebutton.width
        anchors.top: parent.top
        anchors.topMargin: 0
        fillMode: Image.PreserveAspectFit
        smooth: false

        MouseArea {
               id: menuarea
               anchors.fill: parent
               onPressed: {
                   if (menupanel.state == "HIDDEN") {
                       menupanel.state = "VISIBLE";
                       if (gameState == "RUNNING") {
                           Logic.cmdPause();
                       }

                   } else {
                       menupanel.state = "HIDDEN";
                   }
               }
               }
           }

    Menu {
        id:menupanel
        anchors.right: menubutton.left
        state: "HIDDEN";
        z:15
    }

    Rectangle {
        id: invadeline
        width: parent.width
        height:  1
        x: 0
        y: parent.height - ship.height
        color: "#00ff00"

    }

    Rectangle {
        width: parent.width
        height:  1
        x: 0
        anchors.top: closebutton.bottom
        color: "#00ff00"
    }

    Accelerometer  {
        id: accelerometer
        Component.onCompleted: start()
        onReadingChanged: {
            var r = reading
            //Logic.scheduleDirection((r.y) * 5); //Symbian/Harmatten/Meego
            Logic.scheduleDirection((r.x) * -5); //Maemo
        }
    }

    Settingswindow {
        id:settingspanel;
        z: 10
    }

    Hiscorewindow {
        id:hiscorepanel;
        z: 9
    }

    GlobalHiScores {
        id:globalhiscorepanel
        z: 8
    }

    SoundEffect {
        id: shootSound
        source: "sounds/shoot.wav"
    }

    SoundEffect {
        id: destroyAlienSound
        source: "sounds/invaderkilled.wav"
    }

    SoundEffect {
        id: destroyShipSound
        source: "sounds/explosion.wav"
    }

    SoundEffect {
        id: mysteryShipSound
        source: "sounds/ufo_lowpitch.wav"
        loops: SoundEffect.Infinite
    }

    Bunker {
        id: bunker1
        x: Sizer.bunkerX(1);
        y: Sizer.bunkerY()
        width: Sizer.bunkerWidth()
        height: Sizer.bunkerHeight()
    }
    Bunker {
        id: bunker2
        x: Sizer.bunkerX(2);
        y: Sizer.bunkerY()
        width: Sizer.bunkerWidth()
        height: Sizer.bunkerHeight()
    }
    Bunker {
        id: bunker3
        x: Sizer.bunkerX(3);
        y: Sizer.bunkerY()
        width: Sizer.bunkerWidth()
        height: Sizer.bunkerHeight()
    }
    Bunker {
        id: bunker4
        x: Sizer.bunkerX(4);
        y: Sizer.bunkerY()
        width: Sizer.bunkerWidth()
        height: Sizer.bunkerHeight()
    }

    Explosion {
        id: explosion
        x: 0
        y: 0
    }

    SpaceLogo {
        id: spacelogo
        anchors.verticalCenter: board.verticalCenter
        anchors.verticalCenterOffset: -75
        anchors.horizontalCenter: board.horizontalCenter
        anchors.horizontalCenterOffset: -100
    }

    InvadersLogo {
        id: invaderslogo
        anchors.verticalCenter: board.verticalCenter
        anchors.verticalCenterOffset: 75
        anchors.horizontalCenter: board.horizontalCenter
        anchors.horizontalCenterOffset: 100
    }

    Timer {
        id: starttimer1
        repeat:  false
        interval: 1000
        running: true
        onTriggered: {
            spacelogo.state = "VISIBLE";
        }
    }
    Timer {
        id: starttimer2
        repeat:  false
        interval: 1500
        running: true
        onTriggered: {
            invaderslogo.state = "VISIBLE";
        }
    }

    ExitDialog {
        id:exitDialog
        z: 50
        anchors.centerIn: parent
        onClickedNo: {
            exitDialog.state = "HIDDEN"
        }

        onClickedYes: {
            exitDialog.state = "HIDDEN"
            exitGame();
        }
    }

    //=====================Functions=========================

    function startupFunction() {
        Storage.initialize();
        loadSettings();
        Logic.cmdNotRunning();
    }

    function exitPressed(){
        if (gameState != "NOTRUNNING") {
            Logic.cmdPause();
        }
        exitDialog.state = "VISIBLE";
    }

    function exitGame(){
        saveSettings()
        Qt.quit();
    }


    focus: true

    Component.onCompleted: startupFunction();

    Keys.onEscapePressed:exitGame();

    Keys.onPressed: {
        if (gameState == "CONFIGUREKEYLEFT") {
            if (event.key != Qt.Key_P && event.key != Qt.Key_Q) {
                keyLeft = event.key;
                board.displayMessage("Left Key Set");
                messagetimer.start();
                gameState = lastGameState;
            } else {
                board.displayMessage("That Key Cannot Be Used");
                messagetimer.start();
            }
            return
        }
        if (gameState == "CONFIGUREKEYRIGHT") {
            if (event.key != Qt.Key_P && event.key != Qt.Key_Q) {
                keyRight = event.key;
                board.displayMessage("Right Key Set");
                messagetimer.start();
                gameState = lastGameState;
            } else {
                board.displayMessage("That Key Cannot Be Used");
                messagetimer.start();
            }
            return
        }
        if (gameState == "CONFIGUREKEYFIRE") {
            if (event.key != Qt.Key_P && event.key != Qt.Key_Q) {
                keyFire = event.key;
                board.displayMessage("Fire Key Set");
                messagetimer.start();
                gameState = lastGameState;
            } else {
                board.displayMessage("That Key Cannot Be Used");
                messagetimer.start();
            }
            return
        }

        if (event.key == Qt.Key_P) {
            if (gameState == "RUNNING") {
                Logic.cmdPause();
            } else if (gameState == "PAUSED") {
                Logic.cmdResume();
            }
        } else if (event.key == Qt.Key_Q) {
            if (gameState != "NOTRUNNING") {
                Logic.cmdDead();
            }
        } else if (event.key == keyLeft) {
            Logic.scheduleDirection(-10);
        } else if (event.key == keyRight) {
            Logic.scheduleDirection(10);
        } else if (event.key == keyFire) {
            Logic.screenTap();
        }
    }

    Keys.onReleased: {
        if (event.key == keyLeft || event.key == keyRight) {
            Logic.direction = 0
        }
    }

    function displayMessage(msg) {
        messagetext.text = msg;
        messagecontainer.state = "VISIBLE";
    }

    function hideMessage() {
        messagecontainer.state = "HIDDEN";
    }

    Connections {
        target: HiScores
        onMessageReceived: {
            displayMessage(HiScores.lastMessage());
            messagetimer.start();
        }
    }

    Connections {
             target: Viewer
             onWindowStateChanged: {

                 if (windowState && 1) {
                     if (gameState != "NOTRUNNING") {
                         Logic.cmdPause();
                     }
                 }
             }

         }

    property string gameState
    property string lastGameState;

    //Settings============================================

    property string flashOnFire
    property string useAccelerometer
    property string sFX
    property string gamerName
    property string password

    property int pos1Level
    property int pos1Score
    property string pos1Date

    property int pos2Level
    property int pos2Score
    property string pos2Date

    property int pos3Level
    property int pos3Score
    property string pos3Date

    property int pos4Level
    property int pos4Score
    property string pos4Date

    property int pos5Level
    property int pos5Score
    property string pos5Date

    property int pos6Level
    property int pos6Score
    property string pos6Date

    property int keyLeft
    property int keyRight
    property int keyFire

    function nowString()
    {
        var d = new Date();
        var curr_date = d.getDate();
        var curr_month = d.getMonth() + 1;
        var curr_year = d.getFullYear();
        return curr_year + "-" + curr_month + "-" + curr_date;
    }

    //Not my proudest block of code!
    function addNewScore(level, score) {
        if (score > pos1Score) {
            pos6Score = pos5Score;
            pos6Level = pos5Level;
            pos6Date = pos5Date;

            pos5Score = pos4Score;
            pos5Level = pos4Level;
            pos5Date = pos4Date

            pos4Score = pos3Score;
            pos4Level = pos3Level;
            pos4Date = pos3Date;

            pos3Score = pos2Score;
            pos3Level = pos2Level;
            pos3Date = pos3Date;

            pos2Score = pos1Score;
            pos2Level = pos1Level;
            pos2Date = pos1Date;

            pos1Score = score;
            pos1Level = level;
            pos1Date = nowString();

            return;
        }
        if (score > pos2Score) {
            pos6Score = pos5Score;
            pos6Level = pos5Level;
            pos6Date = pos5Date;

            pos5Score = pos4Score;
            pos5Level = pos4Level;
            pos5Date = pos4Date

            pos4Score = pos3Score;
            pos4Level = pos3Level;
            pos4Date = pos3Date;

            pos3Score = pos2Score;
            pos3Level = pos2Level;
            pos3Date = pos3Date;

            pos2Score = score;
            pos2Level = level;
            pos2Date = nowString();

            return;
        }
        if (score > pos3Score) {
            pos6Score = pos5Score;
            pos6Level = pos5Level;
            pos6Date = pos5Date;

            pos5Score = pos4Score;
            pos5Level = pos4Level;
            pos5Date = pos4Date

            pos4Score = pos3Score;
            pos4Level = pos3Level;
            pos4Date = pos3Date;

            pos3Score = score;
            pos3Level = level;
            pos3Date = nowString();

            return;
        }
        if (score > pos4Score) {
            pos6Score = pos5Score;
            pos6Level = pos5Level;
            pos6Date = pos5Date;

            pos5Score = pos4Score;
            pos5Level = pos4Level;
            pos5Date = pos4Date

            pos4Score = score;
            pos4Level = level;
            pos4Date = nowString();

            return;
        }
        if (score > pos5Score) {
            pos6Score = pos5Score;
            pos6Level = pos5Level;
            pos6Date = pos5Date;

            pos5Score = score;
            pos5Level = level;
            pos5Date = nowString();

            return;
        }
        if (score > pos6Score) {
            pos6Score = score;
            pos6Level = level;
            pos6Date = nowString();

            return;
        }
    }

    function loadSettings(){
        //Load settings from the Helper object if they have previously been used before
        if (Helper.settingExists("UseHelperSettings")){

            flashOnFire = Helper.getSetting("FlashOnFire", "TRUE");
            useAccelerometer = Helper.getSetting("UseAccelerometer", "TRUE");
            sFX = Helper.getSetting("SFX", "TRUE");
            gamerName = Helper.getSetting("GamerName", "");
            password = Helper.getSetting("Password", "");

            pos1Level = Helper.getSetting("Pos1Level", 0);
            pos1Score = Helper.getSetting("Pos1Score", 0);
            pos1Date = Helper.getSetting("Pos1Date", "");
            pos2Level = Helper.getSetting("Pos2Level", 0);
            pos2Score = Helper.getSetting("Pos2Score", 0);
            pos2Date = Helper.getSetting("Pos2Date", "");
            pos3Level = Helper.getSetting("Pos3Level", 0);
            pos3Score = Helper.getSetting("Pos3Score", 0);
            pos3Date = Helper.getSetting("Pos3Date", "");
            pos4Level = Helper.getSetting("Pos4Level", 0);
            pos4Score = Helper.getSetting("Pos4Score", 0);
            pos4Date = Helper.getSetting("Pos4Date", "");
            pos5Level = Helper.getSetting("Pos5Level", 0);
            pos5Score = Helper.getSetting("Pos5Score", 0);
            pos5Date = Helper.getSetting("Pos5Date", "");
            pos6Level = Helper.getSetting("Pos6Level", 0);
            pos6Score = Helper.getSetting("Pos6Score", 0);
            pos6Date = Helper.getSetting("Pos6Date", "");

            keyLeft = Helper.getSetting("KeyLeft", Qt.Key_Left);
            keyRight = Helper.getSetting("KeyRight", Qt.Key_Right);
            keyFire = Helper.getSetting("KeyFire", Qt.Key_Space);

         } else { //Load settings from the Storage DB

            flashOnFire = Storage.getSetting("FlashOnFire", "TRUE");
            useAccelerometer = Storage.getSetting("UseAccelerometer", "TRUE");
            sFX = Storage.getSetting("SFX", "TRUE");
            gamerName = Storage.getSetting("GamerName", "");
            password = Storage.getSetting("Password", "");

            pos1Level = Storage.getSetting("Pos1Level", 0);
            pos1Score = Storage.getSetting("Pos1Score", 0);
            pos1Date = Storage.getSetting("Pos1Date", "");
            pos2Level = Storage.getSetting("Pos2Level", 0);
            pos2Score = Storage.getSetting("Pos2Score", 0);
            pos2Date = Storage.getSetting("Pos2Date", "");
            pos3Level = Storage.getSetting("Pos3Level", 0);
            pos3Score = Storage.getSetting("Pos3Score", 0);
            pos3Date = Storage.getSetting("Pos3Date", "");
            pos4Level = Storage.getSetting("Pos4Level", 0);
            pos4Score = Storage.getSetting("Pos4Score", 0);
            pos4Date = Storage.getSetting("Pos4Date", "");
            pos5Level = Storage.getSetting("Pos5Level", 0);
            pos5Score = Storage.getSetting("Pos5Score", 0);
            pos5Date = Storage.getSetting("Pos5Date", "");
            pos6Level = Storage.getSetting("Pos6Level", 0);
            pos6Score = Storage.getSetting("Pos6Score", 0);
            pos6Date = Storage.getSetting("Pos6Date", "");

            keyLeft = Storage.getSetting("KeyLeft", Qt.Key_Left);
            keyRight = Storage.getSetting("KeyRight", Qt.Key_Right);
            keyFire = Storage.getSetting("KeyFire", Qt.Key_Space);
        }
    }

    function saveSettings() {
        Helper.setSetting("UseHelperSettings", true) //Value here doenst matter, if the value exists, the Helper settings will be used

        Helper.setSetting("FlashOnFire", flashOnFire);
        Helper.setSetting("UseAccelerometer", useAccelerometer);
        Helper.setSetting("SFX", sFX);
        Helper.setSetting("GamerName", gamerName);
        Helper.setSetting("Password", password);
        Helper.setSetting("KeyLeft", keyLeft);
        Helper.setSetting("KeyRight", keyRight);
        Helper.setSetting("KeyFire", keyFire);

        Helper.setSetting("Pos1Level", pos1Level);
        Helper.setSetting("Pos1Score", pos1Score);
        Helper.setSetting("Pos2Level", pos2Level);
        Helper.setSetting("Pos2Score", pos2Score);
        Helper.setSetting("Pos3Level", pos3Level);
        Helper.setSetting("Pos3Score", pos3Score);
        Helper.setSetting("Pos4Level", pos4Level);
        Helper.setSetting("Pos4Score", pos4Score);
        Helper.setSetting("Pos5Level", pos5Level);
        Helper.setSetting("Pos5Score", pos5Score);
        Helper.setSetting("Pos6Level", pos6Level);
        Helper.setSetting("Pos6Score", pos6Score);
        Helper.setSetting("Pos1Date", pos1Date);
        Helper.setSetting("Pos2Date", pos2Date);
        Helper.setSetting("Pos3Date", pos3Date);
        Helper.setSetting("Pos4Date", pos4Date);
        Helper.setSetting("Pos5Date", pos5Date);
        Helper.setSetting("Pos6Date", pos6Date);
    }


    //====================================================
}


