import QtQuick 1.0

Item {
    id: ship
    width: shipframe.width
    height: shipframe.height

    Image {
        id: shipframe
        width: 50
        height: 30
        source: "pics/ship.png"
        }

    property int shipexplosionframenumber

    function explode() {
        shipexplosionframenumber = 0;
        explosion.visible = true;
        shipexplosiontimer.start();
    }

    function reset()  {
        shipexplosiontimer.stop();
        shipframe.source = "pics/ship.png"
        shipexplosionframenumber = 0;
        ship.visible = true;
    }

    Timer {
        id: shipexplosiontimer
        interval: 50
        running: false
        repeat: true

        onTriggered: {
            shipframe.source = "pics/destroyship/frame" + shipexplosionframenumber + ".png"
            shipexplosionframenumber++
            if (shipexplosionframenumber > 8) {
                shipexplosiontimer.stop();
                ship.visible = false;
                shipexplosionframenumber = 0;
            }
        }
    }
}
