#ifndef HISCOREMODEL_H
#define HISCOREMODEL_H

#include <QAbstractListModel>
#include <QtNetwork/QNetworkAccessManager>

class Score
{
public:
    Score(const QString &position, const QString &gamer, const QString &score, const QString &level, const QString &date);

    QString gamer() const;
    QString score() const;
    QString level() const;
    QString date() const;
    QString position() const;

private:
    QString m_gamer;
    QString m_score;
    QString m_level;
    QString m_date;
    QString m_position;
};

class HiScoreModel : public QAbstractListModel
{
    Q_OBJECT
public:
    explicit HiScoreModel(QObject *parent = 0);

    enum HiScoreRoles {
             PositionRole = Qt::UserRole + 1,
             GamerRole,
             ScoreRole,
             LevelRole,
             DateRole
         };

         void addScore(const Score &score);

         int rowCount(const QModelIndex & parent = QModelIndex()) const;

         QVariant data(const QModelIndex & index, int role = Qt::DisplayRole) const;

private slots:
         void replyFinished(QNetworkReply*);

public slots:
         void getGlobalTop20();

     private:
         QList<Score> m_scores;
         QNetworkAccessManager *m_networkManager;
};

#endif // HISCOREMODEL_H
