import QtQuick 1.0

import "sizer.js" as Sizer;

Rectangle {
    id: menupanel
    height: 300
    width:  300
    state: "HIDDEN"
    border.color: "#00ff00"
    border.width: 5
    color:  "black"


    states: [
        State {
            name: "HIDDEN"
            PropertyChanges { target: menupanel; y: -304}
        },
        State {
            name: "VISIBLE"
            PropertyChanges { target: menupanel; y: 0}
        }
    ]

    transitions: Transition {
        NumberAnimation { properties: "y"; easing.type: Easing.InOutQuad }
    }

    //Dummy mouse area to stop events being passed through
    MouseArea {
        anchors.fill: parent
    }

    Text {
        id: text1
        color: "#00ff00"
        text: "PGZ Space Invaders"
        anchors.top: parent.top
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.topMargin: 20
        font.pixelSize: 26
        MouseArea {
            anchors.fill: parent;
            onClicked: Qt.openUrlExternally(text2.text);
        }
    }
    Text {
        id: text2
        color: "#00ff00"
        text: "http://www.piggz.co.uk?page=spaceinvaders"
        anchors.top: text1.bottom
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.topMargin: 20
        font.pixelSize: 14

        MouseArea {
            anchors.fill: parent;
            onClicked: Qt.openUrlExternally(text2.text);
        }
    }

    Image {
        id: settingsbutton
        source: "pics/settings.png"
        anchors.left: parent.left
        anchors.leftMargin: 30
        anchors.top: text2.bottom
        anchors.topMargin: 10
        width: 50
        height: 50

        MouseArea {
            id: settingsarea
            anchors.fill: parent
            onClicked: {
                menupanel.state = "HIDDEN";
                if (settingspanel.state == "HIDDEN") {
                    settingspanel.state = "VISIBLE";

                } else {
                    settingspanel.state = "HIDDEN";
                }
            }
        }

        Text {
            id: text3
            x: 60
            y: 23
            width: 80
            height: 20
            text: "text"
            font.pixelSize: 12
        }
    }


    Image {
        id: hiscorebutton
        source: "pics/hiscore.png"
        anchors.left: parent.left
        anchors.leftMargin: 30
        anchors.top: settingsbutton.bottom
        anchors.topMargin: 10
        width: 50
        height: 50


        MouseArea {
            id: hiscorearea
            anchors.fill: hiscorebutton
            onClicked: {
                menupanel.state = "HIDDEN";
                if (hiscorepanel.state == "HIDDEN") {
                    hiscorepanel.state = "VISIBLE";

                } else {
                    hiscorepanel.state = "HIDDEN";
                }
            }
        }
    }

    Image {
        id: globalhiscorebutton
        source: "pics/world.png"
        anchors.left: parent.left
        anchors.leftMargin: 30
        anchors.top: hiscorebutton.bottom
        anchors.topMargin: 10
        width: 50
        height: 50


        MouseArea {
            id: globalhiscorearea
            anchors.fill: parent
            onClicked: {
                menupanel.state = "HIDDEN";
                if (globalhiscorepanel.state == "HIDDEN") {
                    globalhiscorepanel.state = "VISIBLE";
                    GlobalHiScores.getGlobalTop20();

                } else {
                    globalhiscorepanel.state = "HIDDEN";
                }
            }
        }
    }

    Text {
        id: text4
        anchors.verticalCenter: settingsbutton.verticalCenter
        anchors.left: settingsbutton.right
        anchors.leftMargin: 10
        color: "#00ff00"
        text: "Settings"
        font.pixelSize: Sizer.largeFontSize()
    }

    Text {
        id: text5
        anchors.verticalCenter: hiscorebutton.verticalCenter
        anchors.left: hiscorebutton.right
        anchors.leftMargin: 10
        color: "#00ff00"
        text: "Hi Scores"
        font.pixelSize: Sizer.largeFontSize()
    }

    Text {
        id: text6
        anchors.verticalCenter: globalhiscorebutton.verticalCenter
        anchors.left: globalhiscorebutton.right
        anchors.leftMargin: 10
        color: "#00ff00"
        text: "Global Top 20"
        font.pixelSize: Sizer.largeFontSize()
    }


    Text {
        id: textdonate
        color: "#00ff00"
        text: "Donate"
        anchors.bottom: parent.bottom
        anchors.right: parent.right
        font.pixelSize: 20
        MouseArea {
            anchors.fill: parent;
            onClicked: Qt.openUrlExternally("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=QVTJ5JNBQA72A");
        }
    }
}
