#include "HiScoreModel.h"
#include <QUrl>
#include <QDebug>
#include <QtNetwork/QNetworkRequest>
#include <QtNetwork/QNetworkReply>
#include <QtXml/QDomDocument>

Score::Score(const QString &position, const QString &gamer, const QString &score, const QString &level, const QString &date)
{
    m_position = position;
    m_gamer = gamer;
    m_score = score;
    m_level = level;
    m_date = date;
}

QString Score::position() const
{
    return m_position;
}

QString Score::date() const
{
    return m_date;
}

QString Score::gamer() const
{
    return m_gamer;
}

QString Score::level() const
{
    return m_level;
}

QString Score::score() const
{
    return m_score;
}

HiScoreModel::HiScoreModel(QObject *parent) :
    QAbstractListModel(parent)
{
    QHash<int, QByteArray> roles;
         roles[PositionRole] = "position";
         roles[GamerRole] = "gamer";
         roles[ScoreRole] = "score";
         roles[LevelRole] = "level";
         roles[DateRole] = "date";

         setRoleNames(roles);

         m_networkManager = new QNetworkAccessManager(this);
         connect(m_networkManager, SIGNAL(finished(QNetworkReply*)),this, SLOT(replyFinished(QNetworkReply*)));

}

 void HiScoreModel::addScore(const Score &score)
 {
     m_scores << score;
 }

 int HiScoreModel::rowCount(const QModelIndex & parent) const {
     return m_scores.count();
 }

 QVariant HiScoreModel::data(const QModelIndex & index, int role) const {
     if (index.row() < 0 || index.row() > m_scores.count())
         return QVariant();

     const Score &score = m_scores[index.row()];
     if (role == PositionRole)
         return score.position();
     if (role == GamerRole)
         return score.gamer();
     else if (role == ScoreRole)
         return score.score();
     else if (role == LevelRole)
         return score.level();
     else if (role == DateRole)
         return score.date();
     return QVariant();
 }

void HiScoreModel::getGlobalTop20()
{
    QUrl url("http://www.piggz.co.uk/spaceinvadersadmin.php");
    url.addQueryItem("action", "getglobaltop20");

    QNetworkRequest request(url);
    m_networkManager->get(request);
}

void HiScoreModel::replyFinished(QNetworkReply *reply)
{
    beginResetModel();
    m_scores.clear();
    QDomDocument doc;
    doc.setContent(reply->readAll());

    QDomNode n = doc.firstChildElement("scores");
    QDomNode s = n.firstChild();

    while (!s.isNull()) {
         if (s.isElement()) {
             QDomElement e = s.toElement();
             addScore(Score(e.attribute("position"), e.attribute("gamer"), e.attribute("score"), e.attribute("level"), e.attribute("scoredate")));
         }
         s = s.nextSibling();
     }
    endResetModel();
}
