//storage.js
//Possible Settings:
var FlashOnFire = "TRUE";
var UseAccelerometer = "TRUE";
var SFX = "TRUE";

var Pos1Level = 0;
var Pos1Score = 0;
var Pos2Level = 0;
var Pos2Score = 0;
var Pos3Level = 0;
var Pos3Score = 0;
var Pos4Level = 0;
var Pos4Score = 0;
var Pos5Level = 0;
var Pos5Score = 0;
var Pos6Level = 0;
var Pos6Score = 0;

//Not my proudest block of code!
function addNewScore(level, score) {
    if (score > Pos1Score) {
        Pos6Score = Pos5Score;
        Pos6Level = Pos5Level;
        Pos5Score = Pos4Score;
        Pos5Level = Pos4Level;
        Pos4Score = Pos3Score;
        Pos4Level = Pos3Level;
        Pos3Score = Pos2Score;
        Pos3Level = Pos2Level;
        Pos2Score = Pos1Score;
        Pos2Level = Pos1Level;
        Pos1Score = score;
        Pos1Level = level;
        saveSettings();
        return;
    }
    if (score > Pos2Score) {
        Pos6Score = Pos5Score;
        Pos6Level = Pos5Level;
        Pos5Score = Pos4Score;
        Pos5Level = Pos4Level;
        Pos4Score = Pos3Score;
        Pos4Level = Pos3Level;
        Pos3Score = Pos2Score;
        Pos3Level = Pos2Level;
        Pos2Score = score;
        Pos2Level = level;
        saveSettings();
        return;
    }
    if (score > Pos3Score) {
        Pos6Score = Pos5Score;
        Pos6Level = Pos5Level;
        Pos5Score = Pos4Score;
        Pos5Level = Pos4Level;
        Pos4Score = Pos3Score;
        Pos4Level = Pos3Level;
        Pos3Score = score;
        Pos3Level = level;
        saveSettings();
        return;
    }
    if (score > Pos4Score) {
        Pos6Score = Pos5Score;
        Pos6Level = Pos5Level;
        Pos5Score = Pos4Score;
        Pos5Level = Pos4Level;
        Pos4Score = score;
        Pos4Level = level;
        saveSettings();
        return;
    }
    if (score > Pos5Score) {
        Pos6Score = Pos5Score;
        Pos6Level = Pos5Level;
        Pos5Score = score;
        Pos5Level = level;
        saveSettings();
        return;
    }
    if (score > Pos6Score) {
        Pos6Score = score;
        Pos6Level = level;
        saveSettings();
        return;
    }
}

function loadSettings(){
    FlashOnFire = getSetting("FlashOnFire");
    if (FlashOnFire == "Unknown") {
        FlashOnFire = "TRUE";
    }

    UseAccelerometer = getSetting("UseAccelerometer");
    if (UseAccelerometer == "Unknown") {
        UseAccelerometer = "TRUE";
    }

    SFX = getSetting("SFX");
    if (SFX == "Unknown") {
        SFX = "TRUE";
    }


    Pos1Level = getSetting("Pos1Level");
    Pos1Score = getSetting("Pos1Score");
    Pos2Level = getSetting("Pos2Level");
    Pos2Score = getSetting("Pos2Score");
    Pos3Level = getSetting("Pos3Level");
    Pos3Score = getSetting("Pos3Score");
    Pos4Level = getSetting("Pos4Level");
    Pos4Score = getSetting("Pos4Score");
    Pos5Level = getSetting("Pos5Level");
    Pos5Score = getSetting("Pos5Score");
    Pos6Level = getSetting("Pos6Level");
    Pos6Score = getSetting("Pos6Score");

    if (Pos1Level == "Unknown") {
        Pos1Level = 0;
    }
    if (Pos1Score == "Unknown") {
        Pos1Score = 0;
    }
    if (Pos2Level == "Unknown") {
        Pos2Level = 0;
    }
    if (Pos2Score == "Unknown") {
        Pos2Score = 0;
    }
    if (Pos3Level == "Unknown") {
        Pos3Level = 0;
    }
    if (Pos3Score == "Unknown") {
        Pos3Score = 0;
    }
    if (Pos4Level == "Unknown") {
        Pos4Level = 0;
    }
    if (Pos4Score == "Unknown") {
        Pos4Score = 0;
    }
    if (Pos5Level == "Unknown") {
        Pos5Level = 0;
    }
    if (Pos5Score == "Unknown") {
        Pos5Score = 0;
    }
    if (Pos6Level == "Unknown") {
        Pos6Level = 0;
    }
    if (Pos6Score == "Unknown") {
        Pos6Score = 0;
    }
    saveSettings();
}

function saveSettings() {
    setSetting("FlashOnFire", FlashOnFire);
    setSetting("UseAccelerometer", UseAccelerometer);
    setSetting("SFX", SFX);

    setSetting("Pos1Level", Pos1Level);
    setSetting("Pos1Score", Pos1Score);
    setSetting("Pos2Level", Pos2Level);
    setSetting("Pos2Score", Pos2Score);
    setSetting("Pos3Level", Pos3Level);
    setSetting("Pos3Score", Pos3Score);
    setSetting("Pos4Level", Pos4Level);
    setSetting("Pos4Score", Pos4Score);
    setSetting("Pos5Level", Pos5Level);
    setSetting("Pos5Score", Pos5Score);
    setSetting("Pos6Level", Pos6Level);
    setSetting("Pos6Score", Pos6Score);
}

// First, let's create a short helper function to get the database connection
function getDatabase() {
     return openDatabaseSync("pgz-spaceinvaders", "1.0", "StorageDatabase", 100000);
}

// At the start of the application, we can initialize the tables we need if they haven't been created yet
function initialize() {
    var db = getDatabase();
    db.transaction(
        function(tx) {
            // Create the settings table if it doesn't already exist
            // If the table exists, this is skipped
            tx.executeSql('CREATE TABLE IF NOT EXISTS settings(setting TEXT UNIQUE, value TEXT)');
          });
}

// This function is used to write a setting into the database
function setSetting(setting, value) {
   // setting: string representing the setting name (eg: “username”)
   // value: string representing the value of the setting (eg: “myUsername”)
   var db = getDatabase();
   var res = "";
   db.transaction(function(tx) {
        var rs = tx.executeSql('INSERT OR REPLACE INTO settings VALUES (?,?);', [setting,value]);
              //console.log(rs.rowsAffected)
              if (rs.rowsAffected > 0) {
                res = "OK";
              } else {
                res = "Error";
              }
        }
  );
  // The function returns “OK” if it was successful, or “Error” if it wasn't
  return res;
}
// This function is used to retrieve a setting from the database
function getSetting(setting) {
   var db = getDatabase();
   var res="";
   db.transaction(function(tx) {
     var rs = tx.executeSql('SELECT value FROM settings WHERE setting=?;', [setting]);
     if (rs.rows.length > 0) {
          res = rs.rows.item(0).value;
     } else {
         res = "Unknown";
     }
  })
  // The function returns “Unknown” if the setting was not found in the database
  // For more advanced projects, this should probably be handled through error codes
  return res
}
