import QtQuick 1.0
import QtMobility.sensors 1.2
import Qt 4.7
import QtMultimediaKit 1.1
import SpaceInvaders 1.0

import "storage.js" as Storage;
import "sizer.js" as Sizer;
import "logic.js" as Logic

Rectangle {
    id: board
    color: "#000000"
    width: 640
    height:  360

    ColorAnimation on color {id:flashanim; from: "#999999"; to: "black"; duration: 200 }

    MouseArea {
           id: themousearea
           x: 0
           y: 30

           drag.minimumY: -1000
           drag.minimumX: -1000
           drag.maximumY: 1000
           drag.maximumX: 1000
           anchors.rightMargin: 0
           anchors.bottomMargin: 1
           anchors.leftMargin: 0
           anchors.topMargin: 30
           anchors.fill: board
           onPressed: {
                Logic.screenTap();
           }
       }

    Text {
        id: scoretext
        text: "Score: 0"
        color: "#ffffff"
        x: 5
        y: 5
    }

    Text {
        id: leveltext
        text: "Level: 0"
        color: "#ffffff"
        y: 5
        anchors.horizontalCenter: board.horizontalCenter
    }

    Text {
        id: starttext
        text: "Tap screen to start"
        color: "#ffffff"
        anchors.horizontalCenter: board.horizontalCenter
        anchors.verticalCenter: board.verticalCenter
    }

    Rectangle {
        id: messagecontainer
        color: "black"
        height: messagetext.height + 20
        width:  board.width
        visible: true
        state: "HIDDEN"
        border.width: 5
        border.color: "#00ff00"

        z:10

        states: [
            State {
                name: "HIDDEN"
                PropertyChanges { target: messagecontainer; y: board.height + 5}
            },
            State {
                name: "VISIBLE"
                PropertyChanges { target: messagecontainer; y: (board.height - messagecontainer.height) / 2}
            }
        ]

        transitions: Transition {
            NumberAnimation { properties: "y"; easing.type: Easing.InOutQuad }
        }

        Text {
            id: messagetext
            text: ""
            font.pixelSize: 40
            font.bold: true
            color: "#00ff00"
            anchors.horizontalCenter: messagecontainer.horizontalCenter
            anchors.verticalCenter: messagecontainer.verticalCenter
            visible: true

            Timer {
                id: messagetimer
                interval:  1000
                running: false
                repeat: false
                onRunningChanged: {
                    if (messagetimer.running) {
                        messagecontainer.state = "VISIBLE";
                    }
                }

                onTriggered: {
                    messagecontainer.state = "HIDDEN";
                }
            }
        }
    }


    Ship {
        id:ship
        x: (board.width - ship.width) / 2;
        y: board.height - (ship.height * 2) - 3;
    }

    Timer {
             id: heartbeat;
             interval: 50
             running: false;
             repeat: true;
             onTriggered: Logic.mainEvent();
         }

    Timer {
        id: alienanimation
        interval:  600
        running: false
        repeat: true
        onTriggered: Logic.moveAliens()
    }

    Timer  {
        id: deadtimer
        interval: 5000
        running: false
        repeat: false
        onTriggered: {
            Logic.cmdNotRunning();
        }
    }

    Image {
        id: closebutton

        source: "pics/close.png"
        width: 35
        height: 35
        anchors.right: parent.right
        anchors.rightMargin: 0
        anchors.top: parent.top
        anchors.topMargin: 0
        fillMode: Image.PreserveAspectFit
        smooth: false

        MouseArea {
               id: closearea
               anchors.fill: parent
               onPressed: {
                   saveSettings();
                   Qt.quit();
               }
               }
           }

    Image {
        id: menubutton

        source: "pics/menu.png"
        width: 35
        height: 35
        anchors.right: closebutton.left
        anchors.rightMargin: closebutton.width
        anchors.top: parent.top
        anchors.topMargin: 0
        fillMode: Image.PreserveAspectFit
        smooth: false

        MouseArea {
               id: menuarea
               anchors.fill: parent
               onPressed: {
                   if (menupanel.state == "HIDDEN") {
                       menupanel.state = "VISIBLE";
                       if (Logic.state == "RUNNING") {
                           Logic.cmdPause();
                       }

                   } else {
                       menupanel.state = "HIDDEN";
                   }
               }
               }
           }

    Menu {
        id:menupanel
        anchors.right: menubutton.left
        state: "HIDDEN";
        z:15
    }

    Rectangle {
        id: invadeline
        width: parent.width
        height:  1
        x: 0
        y: parent.height - ship.height
        color: "#00ff00"

    }

    Rectangle {
        width: parent.width
        height:  1
        x: 0
        anchors.top: closebutton.bottom
        color: "#00ff00"
    }

    Accelerometer  {
        id: accelerometer
        Component.onCompleted: start()
        onReadingChanged: {
            var r = reading
            //Logic.scheduleDirection((r.y) * 5); //Symbian
            Logic.scheduleDirection((r.x) * -5); //Maemo
        }
    }

    Settingswindow {
        id:settingspanel;
        z: 10
    }

    Hiscorewindow {
        id:hiscorepanel;
        z: 9
    }

    GlobalHiScores {
        id:globalhiscorepanel
        z: 8
    }

    SoundEffect {
        id: shootSound
        source: "sounds/shoot.wav"
    }

    SoundEffect {
        id: destroyAlienSound
        source: "sounds/invaderkilled.wav"
    }

    SoundEffect {
        id: destroyShipSound
        source: "sounds/explosion.wav"
    }

    SoundEffect {
        id: mysteryShipSound
        source: "sounds/ufo_lowpitch.wav"
        loops: SoundEffect.Infinite
    }

    Bunker {
        id: bunker1
        x: Sizer.bunkerX(1);
        y: Sizer.bunkerY()
        width: Sizer.bunkerWidth()
        height: Sizer.bunkerHeight()
    }
    Bunker {
        id: bunker2
        x: Sizer.bunkerX(2);
        y: Sizer.bunkerY()
        width: Sizer.bunkerWidth()
        height: Sizer.bunkerHeight()
    }
    Bunker {
        id: bunker3
        x: Sizer.bunkerX(3);
        y: Sizer.bunkerY()
        width: Sizer.bunkerWidth()
        height: Sizer.bunkerHeight()
    }
    Bunker {
        id: bunker4
        x: Sizer.bunkerX(4);
        y: Sizer.bunkerY()
        width: Sizer.bunkerWidth()
        height: Sizer.bunkerHeight()
    }

    function startupFunction() {
        Storage.initialize();
        loadSettings();
        Logic.cmdNotRunning();
    }

    focus: true

    Component.onCompleted: startupFunction();

    Keys.onSpacePressed: Logic.screenTap();
    Keys.onLeftPressed: Logic.scheduleDirection(-10);
    Keys.onRightPressed: Logic.scheduleDirection(10);
    Keys.onEscapePressed: Qt.quit();

    Keys.onPressed: {
        if (event.key == Qt.Key_P) {
            if (Logic.state == "RUNNING") {
                Logic.cmdPause();
            } else if (Logic.state == "PAUSED") {
                Logic.cmdResume();
            }
        } else if (event.key == Qt.Key_Q) {
            if (Logic.state != "NOTRUNNING") {
                Logic.cmdDead();
            }
        }
    }

    Keys.onReleased: {
        if (event.key == Qt.Key_Left || event.key == Qt.Key_Right) {
            Logic.direction = 0
        }
    }

    function displayMessage(msg) {
        messagetext.text = msg;
        messagecontainer.state = "VISIBLE";
    }

    function hideMessage() {
        messagecontainer.state = "HIDDEN";
    }

    Connections {
        target: HiScores
        onMessageReceived: {
            displayMessage(HiScores.lastMessage());
            messagetimer.start();
        }
    }

    //Settings============================================

    property string flashOnFire
    property string useAccelerometer
    property string sFX
    property string gamerName
    property string password

    property int pos1Level
    property int pos1Score
    property string pos1Date

    property int pos2Level
    property int pos2Score
    property string pos2Date

    property int pos3Level
    property int pos3Score
    property string pos3Date

    property int pos4Level
    property int pos4Score
    property string pos4Date

    property int pos5Level
    property int pos5Score
    property string pos5Date

    property int pos6Level
    property int pos6Score
    property string pos6Date

    function nowString()
    {
        var d = new Date();
        var curr_date = d.getDate();
        var curr_month = d.getMonth() + 1;
        var curr_year = d.getFullYear();
        return curr_year + "-" + curr_month + "-" + curr_date;
    }

    //Not my proudest block of code!
    function addNewScore(level, score) {
        if (score > pos1Score) {
            pos6Score = Pos5Score;
            pos6Level = Pos5Level;
            pos6Date = Pos5Date;

            pos5Score = Pos4Score;
            pos5Level = Pos4Level;
            pos5Date = Pos4Date

            Pos4Score = pos3Score;
            pos4Level = pos3Level;
            pos4Date = pos3Date;

            pos3Score = pos2Score;
            pos3Level = pos2Level;
            pos3Date = pos3Date;

            pos2Score = pos1Score;
            pos2Level = pos1Level;
            pos2Date = pos1Date;

            pos1Score = score;
            pos1Level = level;
            pos1Date = nowString();

            return;
        }
        if (score > pos2Score) {
            pos6Score = pos5Score;
            pos6Level = pos5Level;
            pos6Date = pos5Date;

            pos5Score = pos4Score;
            pos5Level = pos4Level;
            pos5Date = pos4Date

            pos4Score = pos3Score;
            pos4Level = pos3Level;
            pos4Date = pos3Date;

            pos3Score = pos2Score;
            pos3Level = pos2Level;
            pos3Date = pos3Date;

            pos2Score = score;
            pos2Level = level;
            pos2Date = nowString();

            return;
        }
        if (score > pos3Score) {
            pos6Score = pos5Score;
            pos6Level = pos5Level;
            pos6Date = pos5Date;

            pos5Score = pos4Score;
            pos5Level = pos4Level;
            pos5Date = pos4Date

            pos4Score = pos3Score;
            pos4Level = pos3Level;
            pos4Date = pos3Date;

            pos3Score = score;
            pos3Level = level;
            pos3Date = nowString();

            return;
        }
        if (score > pos4Score) {
            pos6Score = pos5Score;
            pos6Level = pos5Level;
            pos6Date = pos5Date;

            pos5Score = pos4Score;
            pos5Level = pos4Level;
            pos5Date = pos4Date

            pos4Score = score;
            pos4Level = level;
            pos4Date = nowString();

            return;
        }
        if (score > pos5Score) {
            pos6Score = pos5Score;
            pos6Level = pos5Level;
            pos6Date = pos5Date;

            pos5Score = score;
            pos5Level = level;
            pos5Date = nowString();

            return;
        }
        if (score > pos6Score) {
            pos6Score = score;
            pos6Level = level;
            pos6Date = nowString();

            return;
        }
    }

    function loadSettings(){
        flashOnFire = Storage.getSetting("FlashOnFire");
        if (flashOnFire == "Unknown") {
            flashOnFire = "TRUE";
        }

        useAccelerometer = Storage.getSetting("UseAccelerometer");
        if (useAccelerometer == "Unknown") {
            useAccelerometer = "TRUE";
        }

        sFX = Storage.getSetting("SFX");
        if (sFX == "Unknown") {
            sFX = "TRUE";
        }

        gamerName = Storage.getSetting("GamerName");
        if (gamerName == "Unknown") {
            gamerName = "";
        }

        password = Storage.getSetting("Password");
        if (password == "Unknown") {
            password = "";
        }

        pos1Level = Storage.getSetting("Pos1Level");
        pos1Score = Storage.getSetting("Pos1Score");
        pos1Date = Storage.getSetting("Pos1Date");
        pos2Level = Storage.getSetting("Pos2Level");
        pos2Score = Storage.getSetting("Pos2Score");
        pos2Date = Storage.getSetting("Pos2Date");
        pos3Level = Storage.getSetting("Pos3Level");
        pos3Score = Storage.getSetting("Pos3Score");
        pos3Date = Storage.getSetting("Pos3Date");
        pos4Level = Storage.getSetting("Pos4Level");
        pos4Score = Storage.getSetting("Pos4Score");
        pos4Date = Storage.getSetting("Pos4Date");
        pos5Level = Storage.getSetting("Pos5Level");
        pos5Score = Storage.getSetting("Pos5Score");
        pos5Date = Storage.getSetting("Pos5Date");
        pos6Level = Storage.getSetting("Pos6Level");
        pos6Score = Storage.getSetting("Pos6Score");
        pos6Date = Storage.getSetting("Pos6Date");

        if (pos1Level == "Unknown") {
            pos1Level = 0;
        }
        if (pos1Score == "Unknown") {
            pos1Score = 0;
        }
        if (pos2Level == "Unknown") {
            pos2Level = 0;
        }
        if (pos2Score == "Unknown") {
            pos2Score = 0;
        }
        if (pos3Level == "Unknown") {
            pos3Level = 0;
        }
        if (pos3Score == "Unknown") {
            pos3Score = 0;
        }
        if (pos4Level == "Unknown") {
            pos4Level = 0;
        }
        if (pos4Score == "Unknown") {
            pos4Score = 0;
        }
        if (pos5Level == "Unknown") {
            pos5Level = 0;
        }
        if (pos5Score == "Unknown") {
            pos5Score = 0;
        }
        if (pos6Level == "Unknown") {
            pos6Level = 0;
        }
        if (pos6Score == "Unknown") {
            pos6Score = 0;
        }

        if (pos1Date == "Unknown") {
            pos1Date = "";
        }
        if (pos2Date == "Unknown") {
            pos2Date = "";
        }
        if (pos3Date == "Unknown") {
            pos3Date = "";
        }
        if (pos4Date == "Unknown") {
            pos4Date = "";
        }
        if (pos5Date == "Unknown") {
            pos5Date = "";
        }
        if (pos6Date == "Unknown") {
            pos6Date = "";
        }

        saveSettings();
    }

    function saveSettings() {
        Storage.setSetting("FlashOnFire", flashOnFire);
        Storage.setSetting("UseAccelerometer", useAccelerometer);
        Storage.setSetting("SFX", sFX);
        Storage.setSetting("GamerName", gamerName);
        Storage.setSetting("Password", password);

        Storage.setSetting("Pos1Level", pos1Level);
        Storage.setSetting("Pos1Score", pos1Score);
        Storage.setSetting("Pos2Level", pos2Level);
        Storage.setSetting("Pos2Score", pos2Score);
        Storage.setSetting("Pos3Level", pos3Level);
        Storage.setSetting("Pos3Score", pos3Score);
        Storage.setSetting("Pos4Level", pos4Level);
        Storage.setSetting("Pos4Score", pos4Score);
        Storage.setSetting("Pos5Level", pos5Level);
        Storage.setSetting("Pos5Score", pos5Score);
        Storage.setSetting("Pos6Level", pos6Level);
        Storage.setSetting("Pos6Score", pos6Score);
        Storage.setSetting("Pos1Date", pos1Date);
        Storage.setSetting("Pos2Date", pos2Date);
        Storage.setSetting("Pos3Date", pos3Date);
        Storage.setSetting("Pos4Date", pos4Date);
        Storage.setSetting("Pos5Date", pos5Date);
        Storage.setSetting("Pos6Date", pos6Date);
    }


    //====================================================
}


