var bunkerMap = new Array(225);

var bunker = "";
bunker += "     xxxxx     ";
bunker += "    xxxxxxx    ";
bunker += "   xxxxxxxxx   ";
bunker += "  xxxxxxxxxxx  ";
bunker += " xxxxxxxxxxxxx ";
bunker += "xxxxxxxxxxxxxxx";
bunker += "xxxxxxxxxxxxxxx";
bunker += "xxxxxxxxxxxxxxx";
bunker += "xxxxxxxxxxxxxxx";
bunker += "xxxxxxxxxxxxxxx";
bunker += "xxxxxxxxxxxxxxx";
bunker += "xxxxx     xxxxx";
bunker += "xxxx       xxxx";
bunker += "xxxx       xxxx";
bunker += "xxxx       xxxx";

var x;
var y;
var width;
var height;

function create(x_offset, y_offset, parent) {
    //Create a bunker at the specified position using the bunker string to construct a log ot qml objects on the board
    x = x_offset;
    y = y_offset;
    width = 5 * 15;
    height = 4 * 15;

    for (var i = 0; i < 225; ++i) {
        var py = Math.floor(i/15);
        var px = i - (py*15);

        py *= 4;
        px *= 5;
        py += y_offset;
        px += x_offset;

        var b = 'import QtQuick 1.0; Rectangle {color: "#00ff00"; width: 5; height: 4; x: ' + px + ';y: ' + py +'}';

        if (bunker.charAt(i) == 'x') {
            bunkerMap[i] = Qt.createQmlObject(b, board, "");
        }
    }
}

function checkBunkerHit(x, y, w, h) {
    //console.log("Hit test: " + bunkernum);
    //Loop over each bunker block checking for a hit
    for (var j = 0; j < 225; ++j) {
        if (bunkerMap[j]) {
            if (bunkerMap[j].x >= x && bunkerMap[j].x <= x + w) {
                if (bunkerMap[j].y >= y && bunkerMap[j].y <= y + h) {
                    damageBunkerBomb(j);
                    return true; //Hit
                }
            }
        }
    }
    return false; //Not hit
}

function checkBunkerHitRev(x, y, w, h) {
    //console.log("Hit test: " + bunkernum);
    //Loop over each bunker block checking for a hit
    for (var j = 224; j >= 0; --j) {
        if (bunkerMap[j]) {
            if (bunkerMap[j].x >= x && bunkerMap[j].x <= x + w) {
                if (bunkerMap[j].y >= y && bunkerMap[j].y <= y + h) {
                    damageBunkerLaser(j);
                    return true; //Hit
                }
            }
        }
    }
    return false; //Not hit
}

function damageBunkerBomb(offset) {
    damageBunkerReal(offset);
    damageBunkerReal(offset + 1);
    damageBunkerReal(offset + 2);
    damageBunkerReal(offset + 3);
    damageBunkerReal(offset - 1);
    damageBunkerReal(offset - 2);
    damageBunkerReal(offset - 3);
    damageBunkerReal(offset + 14);
    damageBunkerReal(offset + 15);
    damageBunkerReal(offset + 16);
    damageBunkerReal(offset + 30);
    damageBunkerReal(offset - 14);
    damageBunkerReal(offset - 15);
    damageBunkerReal(offset - 16);
    damageBunkerReal(offset - 30);
}

function damageBunkerLaser(offset) {
    damageBunkerReal(offset);
    damageBunkerReal(offset + 15);
    damageBunkerReal(offset -15);
}

function damageBunkerReal(offset) {
    if(bunkerMap[offset]) {
        bunkerMap[offset].destroy();
        bunkerMap[offset] = null;
    }
}

function destroyBunker() {
    for (var i = 0; i < 225; ++i) {
        if (bunkerMap[i]) {
            bunkerMap[i].destroy();
            bunkerMap[i] = null;
        }
    }
}
