#ifndef TRAILGPXVIEW_H
#define TRAILGPXVIEW_H

#include <QWidget>
#include <QtLocation/QGeoPositionInfo>
#include "Latitude.h"

class QWebView;
class QVBoxLayout;
class LatitudeSettings;
class QLabel;

#ifndef Q_WS_MAEMO_5
    class QPushButton;
#endif

class LatitudeMap : public QWidget
{
    Q_OBJECT
public:
    explicit LatitudeMap(QWidget *parent = 0);

public slots:
    void setPosition(const QtMobility::QGeoPositionInfo &pos);
    void settingsDone();
    void test();
    void showSettings();

signals:

private slots:
    void replyFinished(QNetworkReply*);

private:
    QLabel *m_address;
    QNetworkAccessManager *m_networkManager;
    QVBoxLayout *m_layout;

    Latitude latitude;
    LatitudeSettings *m_settingsDialog;
    QSettings oauthSettings;

#ifndef Q_WS_MAEMO_5
    QPushButton *m_settingsButton;
#endif
};

#endif // TRAILGPXVIEW_H
