#include "LatitudeMap.h"
#include <QtWebKit/QWebView>
#include <QVBoxLayout>
#include <QtWebKit/QWebFrame>
#include <QDebug>
#include <QTimer>
#include "LatitudeSettings.h"

#ifndef Q_WS_MAEMO_5
#include <QPushButton>
#endif
LatitudeMap::LatitudeMap(QWidget *parent) :
    QWidget(parent)
{
    connect(&latitude, SIGNAL(gotPosition(QtMobility::QGeoPositionInfo)), this, SLOT(setPosition(QtMobility::QGeoPositionInfo)));

    m_settingsDialog = new LatitudeSettings(this);
    connect(m_settingsDialog, SIGNAL(authorize()), &latitude, SLOT(requestToken()));
    connect(m_settingsDialog, SIGNAL(accepted()), this, SLOT(settingsDone()));

    m_layout = new QVBoxLayout();

    m_webView = new QWebView(this);

    m_layout->addWidget(m_webView);
    setLayout(m_layout);

    m_html = "<!DOCTYPE html>";
    m_html +="<html>";
    m_html +="<head>";
    m_html +="<meta name=\"viewport\" content=\"initial-scale=1.0, user-scalable=no\" />";
    m_html +="<style type=\"text/css\">";
    m_html +="html { height: 100% }";
    m_html +="body { height: 100%; margin: 0px; padding: 0px }";
    m_html +="#map_canvas { height: 100% }";
    m_html +="</style>";
    m_html +=" <script type=\"text/javascript\" src=\"http://maps.google.com/maps/api/js?v=3.4&sensor=false\">";
    m_html +=" </script>";

    m_html +=" <script type=\"text/javascript\">";

    m_html +="var map = null;";
    m_html +="var circle = null;";
    m_html +="var pos = null;";

    m_html +="function setPos(lat, lon) {";
    m_html +="  pos = new google.maps.LatLng(lat, lon);";
    m_html +="  circle.setCenter(pos);";
    m_html +="  map.setCenter(pos);";
    m_html += "}";

    m_html +="function initialize() {";
    m_html +="  pos = new google.maps.LatLng(53, -3);";
    m_html +="  var myOptions = {";
    m_html +="    zoom: 18,";
    m_html +="    center: pos,";
    m_html +="    disableDefaultUI: true,";
    m_html +="    mapTypeId: google.maps.MapTypeId.ROADMAP";
    m_html +="  };";

    m_html +="  map = new google.maps.Map(document.getElementById(\"map_canvas\"),myOptions);";
    m_html +="  map.setCenter(new google.maps.LatLng(0,0));";

    m_html +="  var circleOptions = {";
    m_html +="    center: pos,";
    m_html +="    clickable: false,";
    m_html +="    fillColor: '#FF0000',";
    m_html +="    fillOpacity: 0.5,";
    m_html +="    map: map,";
    m_html +="    radius: 4,";
    m_html +="    strokeColor: '#FF0000',";
    m_html +="    strokeOpacity: 0.5,";
    m_html +="    strokeWeight: 3,";
    m_html +="    zIndex: 2";
    m_html +="  };";

    m_html +="  circle = new google.maps.Circle(circleOptions);";
    m_html +="  circle.setMap(map);";
    m_html +="  circle.setCenter(pos);";
    m_html +="}";

    m_html +="</script>";

    m_html +="</head>";
    m_html +="<body onload=\"initialize()\">";
    m_html +="<div id=\"map_canvas\" style=\"width:100%; height:100%\"></div>";
    m_html +="</body>";
    m_html +="</html>";

    m_webView->setHtml(m_html);

#ifndef Q_WS_MAEMO_5
    m_settingsButton = new QPushButton(tr("Settings"), this);
    m_layout->addWidget(m_settingsButton);
    connect(m_settingsButton, SIGNAL(clicked()), this, SLOT(showSettings()));

    //QTimer::singleShot(5000, this, SLOT(test()));
#endif    
}

void LatitudeMap::test()
{
    //=====================
    QtMobility::QGeoPositionInfo pos;
    QtMobility::QGeoCoordinate coord;
    coord.setLongitude(-3.14);
    coord.setLatitude(54.81);
    coord.setAltitude(5);
    pos.setCoordinate(coord);
    pos.setAttribute(QtMobility::QGeoPositionInfo::HorizontalAccuracy, 1);
    setPosition(pos);
}

void LatitudeMap::setPosition(const QtMobility::QGeoPositionInfo &pos)
{
    qDebug() << "setPosition "<< pos.coordinate();
    float lat, lon;
    lat = pos.coordinate().latitude();
    lon = pos.coordinate().longitude();

    m_webView->page()->mainFrame()->evaluateJavaScript(QString("setPos(%1, %2)").arg(lat).arg(lon));
    latitude.setCurrentLocation(pos);
}

void LatitudeMap::showSettings()
{
    m_settingsDialog->show();
}

void LatitudeMap::settingsDone()
{
    qDebug() << "Settings Done";
    latitude.setUpdateInterval(m_settingsDialog->updateInterval());
}
