#ifndef LATITUDE_H
#define LATITUDE_H

#include <QObject>
#include <QSettings>

#include "kqoauthmanager.h"
#include "kqoauthrequest.h"
#include "kqoauthutils.h"

#include <QtLocation/QGeoPositionInfo>
#include <QtLocation/QGeoPositionInfoSource>

using namespace QtMobility;

class Latitude : public QObject
{
    Q_OBJECT
public:
    explicit Latitude(QObject *parent = 0);

signals:
    void gotPosition(const QtMobility::QGeoPositionInfo &pos);

public slots:
    void requestToken();
    void getCurrentLocation();
    void setCurrentLocation(const QGeoPositionInfo &pos);
    void setCurrentLocation();
    void setUpdateInterval(int minutes);

private slots:
    void onTemporaryTokenReceived(QString temporaryToken, QString temporaryTokenSecret);
    void onAuthorizationReceived(QString token, QString verifier);
    void onAccessTokenReceived(QString token, QString tokenSecret);
    void onAuthorizedRequestDone();
    void onRequestReady(QByteArray);

private:
    KQOAuthManager oauthManager;
    KQOAuthRequest oauthRequest;
    QSettings oauthSettings;
    QtMobility::QGeoPositionInfoSource *m_location;

    QByteArray generateLocationJSON(const QGeoPositionInfo &pos);
    QGeoPositionInfo parseLocationJSON(const QByteArray &data);
};

#endif // LATITUDE_H
