#include "TrailGPXView.h"
#include "MapWidget.h"

#include <QVBoxLayout>
#include <QDebug>

#include <QtLocation/QGeoServiceProvider>
#include <QtLocation/QGeoMappingManager>
#include <QtLocation/QGeoMapObject>
#include <QtLocation/QGeoBoundingBox>
#include <QtLocation/QGeoCoordinate>
#include <QtLocation/QGeoMapPolylineObject>
#include <QGraphicsScene>
#include <QGraphicsView>
#include <QGraphicsLinearLayout>

#include "trailinterface.h"

TrailGPXView::TrailGPXView(TrailInterface *interface, QWidget *parent) :
    QWidget(parent)
{
    m_layout = new QVBoxLayout();

    m_map = new MapWidget(interface, this);

    m_layout->addWidget(m_map);
    setLayout(m_layout);
}

void TrailGPXView::addMapObject(QtMobility::QGeoMapPolylineObject *obj, bool panto)
{
    m_map->addMapObject(obj);
    if (panto) {
        m_map->setCenter(obj->path().first());
    }
}

void TrailGPXView::clearMapObjects()
{
    m_map->clearMapObjects();
}
