#include "TrailGPXView.h"
#include "MapWidget.h"

#include <QVBoxLayout>
#include <QDebug>

#include <QtLocation/QGeoServiceProvider>
#include <QtLocation/QGeoMappingManager>
#include <QtLocation/QGeoMapObject>
#include <QtLocation/QGeoBoundingBox>
#include <QtLocation/QGeoCoordinate>

#include <QGraphicsScene>
#include <QGraphicsView>
#include <QGraphicsLinearLayout>

#include "trailinterface.h"

TrailGPXView::TrailGPXView(TrailInterface *interface, QWidget *parent) :
    QWidget(parent)
{
    m_layout = new QVBoxLayout();

    m_scene = new QGraphicsScene(this);
    m_qgv = new QGraphicsView(m_scene, this);

    m_qgv->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    m_qgv->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    m_qgv->setVisible(true);
    m_qgv->setInteractive(true);

    m_mapWidget = new MapWidget(interface->mappingManager());
    m_mapWidget->setCenter(QtMobility::QGeoCoordinate(-27.0, 152.0));
    m_mapWidget->setZoomLevel(5);
    m_mapWidget->setMapType(QtMobility::QGraphicsGeoMap::TerrainMap);

    QGraphicsLinearLayout *layout = new QGraphicsLinearLayout;
    layout->addItem(m_mapWidget);

    QGraphicsWidget *form = new QGraphicsWidget;
    form->setLayout(layout);
    m_scene->addItem(form);

    //m_scene->addItem(m_mapWidget);

    m_layout->addWidget(m_qgv);
    setLayout(m_layout);
}

void TrailGPXView::addMapObject(QtMobility::QGeoMapObject *obj, bool fit)
{
    m_mapWidget->addMapObject(obj);

    if (fit) {
        m_mapWidget->fitInViewport(obj->boundingBox());
    }
}

void TrailGPXView::clearMapObjects()
{
    m_mapWidget->clearMapObjects();
}
