#ifndef TRAILCREATETRIP_H
#define TRAILCREATETRIP_H

#include <QWidget>

class TrailInterface;
class QPushButton;
class QComboBox;
class QVBoxLayout;
class QLineEdit;
class QPlainTextEdit;
class QCheckBox;

class TrailCreateTrip : public QWidget
{
    Q_OBJECT
public:
    explicit TrailCreateTrip(TrailInterface* interface, QWidget *parent = 0);
    ~TrailCreateTrip();

public slots:


private slots:
    void selectFile();
    void setActivities(const QStringList&);
    void createTrip();
    void createdBasicTrip(long trip_id);
    void tripSetGPXDone(long trip_id);
    void tripCompleteDone(long trip_id);

private:
    QString m_fileName;

    QPushButton *m_fileButton;
    QComboBox *m_activityCombo;
    QLineEdit *m_title;
    QPlainTextEdit *m_description;
    QCheckBox *m_public;

    QVBoxLayout *m_layout;

    QPushButton *m_createButton;

    TrailInterface *m_interface;
};

#endif // TRAILCREATETRIP_H
