#include "modeldialog.h"
#include <QLineEdit>
#include <QListWidget>
#include <QListWidgetItem>
#include <QVBoxLayout>
#include <QPushButton>
#include <QHBoxLayout>
#include <QComboBox>
#include <QLabel>
#include <QGridLayout>
#include <applicationmenu.h>
#ifdef Q_WS_MAEMO_5
    #include <QtMaemo5>
#endif

ModelDialog::ModelDialog(QWidget *parent) : QWidget(parent)
{
    //layouts
    QHBoxLayout *manufacturer = new QHBoxLayout();
    QHBoxLayout *model = new QHBoxLayout();
    QVBoxLayout *layout = new QVBoxLayout();
    QGridLayout *grid = new QGridLayout(this);

    //labels
    QLabel *manu = new QLabel("Select manufacturer: ");
    QLabel *mod = new QLabel("Select model: ");

    //combo boxes
    QComboBox *manufacturers = new QComboBox();
    QComboBox *models = new QComboBox();

    //add items to combo boxes
    manufacturers->addItem(tr("Omron"));
    models->addItem(tr("M2 Basic"));
    manufacturers->setMinimumWidth(300);
    models->setMinimumWidth(300);

    manufacturer->addWidget(manu);
    manufacturer->addWidget(manufacturers);
    model->addWidget(mod);
    model->addWidget(models);
    manufacturer->setAlignment(manufacturers, Qt::AlignHCenter);
    model->setAlignment(models, Qt::AlignHCenter);

    //select button
    QPushButton *select = new QPushButton("select");

    //add items to layouts
    layout->addLayout(manufacturer);
    layout->addLayout(model);
    layout->setAlignment(manufacturer, Qt::AlignTop);
    layout->setAlignment(model, Qt::AlignBottom);
    grid->addLayout(layout,0,0);
    grid->addWidget(select,1,1);
    grid->setAlignment(layout, Qt::AlignVCenter);
    grid->setAlignment(select, Qt::AlignBottom);
    grid->setColumnMinimumWidth(0,700);
    grid->setRowMinimumHeight(0, 350);

    setLayout(grid);

    //connect buttons to slot
    connect(select, SIGNAL(clicked()), this, SLOT(close()));
}
