#include "linechartview.h"
#include <QVBoxLayout>
#include <QDebug>
#include <QPushButton>
#include <QGraphicsWidget>
#include <QGraphicsScene>
#include <QCheckBox>
#include <applicationmenu.h>


LineChartView::LineChartView(QWidget *parent) :
    QWidget(parent)
{
    //base layout
    mainLayout = new QHBoxLayout(this);
    buttonsLayout = new QVBoxLayout();
    chartLayout = new QHBoxLayout();

    ApplicationMenu *startMenu = new ApplicationMenu(this);

    //buttons
    QPushButton *table = new QPushButton();
    table->setIcon(QIcon(":/images/table.png"));
    table->setIconSize(QSize(70,70));
    table->setFlat(true);
    QPushButton *send = new QPushButton();
    send->setIcon(QIcon(":/images/send.png"));
    send->setIconSize(QSize(70,70));
    send->setFlat(true);
    buttonsLayout->addWidget(table);
    buttonsLayout->addWidget(send);

    //draw the graph
    chart = new LineChartBuilder(true, true, true, true);

    view = new QGraphicsView();
    view->setScene(chart);
    view->setDragMode(QGraphicsView::ScrollHandDrag);

    //create not scrollable view for the chart value indicators
    QGraphicsView *titleView = new QGraphicsView();
    QGraphicsScene *titleScene = new QGraphicsScene();
    QGraphicsTextItem *label;
    titleScene->setSceneRect(0,0,50,300);
    int gridRow = 0;
    for (int i = 0; i < 20; i++)
    {
        if (i%2 == 0)
        {
            label = new QGraphicsTextItem(QString::number(230-i*10), 0, titleScene);
            label->setFont(QFont("Arial", 11, QFont::DemiBold));
            label->setPos(0, gridRow-4);
        }
        gridRow += 300/20;
    }
    titleView->setScene(titleScene);

    chartLayout->addWidget(titleView);
    chartLayout->addWidget(view);


    //check box indicators for chart lines
    checkBoxTitles = new QHBoxLayout();
    red = new QCheckBox("sys");
    yellow = new QCheckBox("dia");
    blue = new QCheckBox("pulse");
    green = new QCheckBox("weight");

    //set colors to checkboxes to match the lines
    red->setStyleSheet("background-color: #ff0000");
    yellow->setStyleSheet("background-color: #ffff00");
    blue->setStyleSheet("background-color: #0000ff");
    green->setStyleSheet("background-color: #00ff00");
    red->setFont(QFont());

    //set all checked by default
    red->setChecked(true);
    yellow->setChecked(true);
    blue->setChecked(true);
    green->setChecked(true);
    //add boxes to a row
    checkBoxTitles->addWidget(red);
    checkBoxTitles->addWidget(yellow);
    checkBoxTitles->addWidget(blue);
    checkBoxTitles->addWidget(green);
    //make a new layout for the left side of the view
    leftSide = new QVBoxLayout();
    leftSide->addLayout(chartLayout);
    leftSide->addLayout(checkBoxTitles);

    mainLayout->addLayout(leftSide);
    mainLayout->addLayout(buttonsLayout);
    this->setLayout(mainLayout);

    //connect buttons and checkboxes
    connect(table, SIGNAL(clicked()), this, SLOT(close()));
    connect(red, SIGNAL(clicked()), this, SLOT(handleCheckBoxToggle()));
    connect(yellow, SIGNAL(clicked()), this, SLOT(handleCheckBoxToggle()));
    connect(blue, SIGNAL(clicked()), this, SLOT(handleCheckBoxToggle()));
    connect(green, SIGNAL(clicked()), this, SLOT(handleCheckBoxToggle()));
}

void LineChartView::handleCheckBoxToggle()
{
    //take the layout apart
   this->layout()->removeItem(leftSide);
   leftSide->removeItem(chartLayout);
   leftSide->removeItem(checkBoxTitles);
   chartLayout->removeWidget(view);
   this->layout()->removeItem(buttonsLayout);


   //build a new chart
   chart = new LineChartBuilder(red->isChecked(), yellow->isChecked(), blue->isChecked(), green->isChecked());
   view->setScene(chart);
  // scrollableChart->setWidget(view);
   chartLayout->addWidget(view);
   //put the layout back together
   leftSide->addItem(chartLayout);
   leftSide->addItem(checkBoxTitles);
   this->layout()->addItem(leftSide);
   this->layout()->addItem(buttonsLayout);
}

