#include "linechartbuilder.h"
#include <QDebug>
#include <QGraphicsWidget>
#include <QLabel>
#include <QGraphicsGridLayout>
#include <QImage>
#include <QPainter>
#include <QGraphicsEffect>

LineChartBuilder::LineChartBuilder(bool drawSys, bool drawDia, bool drawPulse, bool drawWeight, QObject *parent) :
    QGraphicsScene(parent)
{    

    //draw image grid

    //value label
        QGraphicsTextItem *label;


        //get values from measurement
        measurement = Measurement::instance();
        QList<QMap<QString, QString> > values = measurement->getValues();

        //each column is set to 60px
        chartWidth = values.count()*60;
        columnWidth = 60;
        if (chartWidth < 600)
        {
            chartWidth = 600;
            columnWidth = 600 / values.count();
        }
        //set scene size
        this->setSceneRect(0,0,chartWidth,300);

        //draw optimal area rectangles to view
        this->addRect(0, (int)375-(110*1.5), chartWidth, (int)25*1.5, QPen(), QBrush(Qt::lightGray));
        this->addRect(0, (int)375-(160*1.5), chartWidth, (int)35*1.5, QPen(), QBrush(Qt::lightGray));
        //variables for calculatin places for columns and rows
        int gridRow = 0;
        int gridColumn = 0;
        //draw 21 rows and label them with correct values
        for (int i = 0; i < 20; i ++)
        {/*
            //only set every other label
            if (i%2 == 0)
            {
                label = new QGraphicsTextItem(QString::number(230-i*10), 0, this);
                label->setFont(QFont("Arial", 9, QFont::DemiBold));
                label->setPos(0, gridRow + 4);
            }
*/
            this->addLine(0, gridRow, chartWidth, gridRow,QPen(QBrush(Qt::Dense4Pattern),2));
            gridRow += 300/20;
        }
        //draw as meny columns as there area dates
        for (int i = 0; i < values.count(); i++)
        {
            this->addLine(gridColumn, 0, gridColumn, 300, QPen(QBrush(Qt::Dense4Pattern),2));
            gridColumn += columnWidth;
        }
        //points for drawing lines
        QPoint sysPoint(0,0);
        QPoint diaPoint(0,0);
        QPoint pulsePoint(0,0);
        QPoint weightPoint(0,0);
        //set column start back
        gridColumn = 0;
        QMap<QString,QString> data;
        //boolean for checking wheather to draw a line or not
        bool isThisFirst = true;
        //save date to prevent repetition
        QString previousDate;
        //loop through values and draw them
        foreach (data, values)
        {
            //change to integers
            int weight = data.value("weight").toInt();
            int sys = data.value("sys").toInt();
            int dia = data.value("dia").toInt();
            int pulse = data.value("pulse").toInt();

            //scale to row height (10 mmHg/kg is 15px in a row)
            weight = (int)weight * 1.5;
            sys = (int)sys * 1.5;
            dia = (int)dia * 1.5;
            pulse = (int)pulse * 1.5;
            // invert to coordinates (height 300 + 1.5*min value 40)
            weight = 360 - weight;
            sys = 360 - sys;
            dia = 360 - dia;
            pulse = 360 - pulse;

            //get the time of the measurement
            QString date = data.value("date");
            QString time = data.value("time");

            //draw measuring points to grid
            //substaction sets the ellipse in the middle of the point
            if (drawSys == true)
                this->addEllipse(gridColumn-3, sys-3, 6, 6, QPen(), QBrush(Qt::red));
            if (drawDia == true)
                this->addEllipse(gridColumn-3, dia-3, 6, 6, QPen(), QBrush(Qt::yellow));
            if (drawPulse == true)
                this->addEllipse(gridColumn-3, pulse-3, 6, 6, QPen(), QBrush(Qt::blue));
            if (drawWeight == true)
                this->addEllipse(gridColumn-3, weight-3, 6, 6, QPen(), QBrush(Qt::green));

            //connect points with lines
            if(!isThisFirst)
            {
                if (drawSys == true)
                    this->addLine(sysPoint.x(),sysPoint.y(), gridColumn, sys, QPen(QBrush(Qt::red),3, Qt::SolidLine, Qt::RoundCap, Qt::RoundJoin));
                if (drawDia == true)
                    this->addLine(diaPoint.x(),diaPoint.y(), gridColumn, dia, QPen(QBrush(Qt::yellow),3, Qt::SolidLine, Qt::RoundCap, Qt::RoundJoin));
                if (drawPulse == true)
                    this->addLine(pulsePoint.x(),pulsePoint.y(), gridColumn, pulse, QPen(QBrush(Qt::blue),3, Qt::SolidLine, Qt::RoundCap, Qt::RoundJoin));
                if (drawWeight == true)
                    this->addLine(weightPoint.x(),weightPoint.y(), gridColumn, weight, QPen(QBrush(Qt::green),3, Qt::SolidLine, Qt::RoundCap, Qt::RoundJoin));
            }
            //save previous points
            sysPoint.setX(gridColumn);
            sysPoint.setY(sys);
            diaPoint.setX(gridColumn);
            diaPoint.setY(dia);
            pulsePoint.setX(gridColumn);
            pulsePoint.setY(pulse);
            weightPoint.setX(gridColumn);
            weightPoint.setY(weight);

            //check if date is already drawn
            //if not, draw date, otherwise skip
            if (date != previousDate)
            {
                QGraphicsTextItem *dateItem = new QGraphicsTextItem(date, 0 , this);
                dateItem->setFont(QFont("Arial", 10, QFont::DemiBold));
                dateItem->setPos(gridColumn, -5);
                previousDate = date;
            }
            //paint time of the measurement
            QGraphicsTextItem *timeItem = new QGraphicsTextItem(time, 0 , this);
            timeItem->setFont(QFont("Arial", 10, QFont::DemiBold));
            timeItem->setPos(gridColumn, 10);

            //increase the x coordinate for the next column
            gridColumn += chartWidth / values.count();
            //set first to false
            isThisFirst = false;
        }
}


