#include "historyview.h"
#include <QTableView>
#include <QVBoxLayout>
#include <QGridLayout>
#include <QTableWidget>
#include <applicationmenu.h>
#include <QDebug>
#include <QPushButton>
#ifdef Q_WS_MAEMO_5
    #include <QtMaemo5>
    #include<QMaemo5InformationBox>
#endif
#include <QMessageBox>
#include <QSettings>
#include "linechartview.h"

HistoryView::HistoryView(QWidget *parent) : QWidget(parent)
{

    //base layout
    QGridLayout *gridLayout = new QGridLayout(this);
    QVBoxLayout *buttonsLayout = new QVBoxLayout();
    QVBoxLayout *tableLayout = new QVBoxLayout();
    tableWidget = new QTableWidget();
    tableWidget->setColumnCount(6);

    //headers for the table columns
    QStringList headers;
    headers << "Date" << "Time" << "SYS" << "DIA" << "Pulse" << "Weight";
    tableWidget->setHorizontalHeaderLabels(headers);

    measurement = Measurement::instance();
    values = measurement->getValues();

    tableWidget->setRowCount(values.count());
    if (values.isEmpty())
    {
    #ifdef Q_WS_MAEMO_5
      QMaemo5InformationBox::information(this, "You don't have any saved data",
                                                        QMaemo5InformationBox::DefaultTimeout);
    #endif
    }
    else
    {
        int i = 0;
        QMap<QString, QString> data;
        foreach (data, values)
        {
            QTableWidgetItem *date = new QTableWidgetItem(data.value("date"));
            QTableWidgetItem *time = new QTableWidgetItem(data.value("time"));
            QTableWidgetItem *sys = new QTableWidgetItem(data.value("sys"));
            QTableWidgetItem *dia = new QTableWidgetItem(data.value("dia"));
            QTableWidgetItem *pulse = new QTableWidgetItem(data.value("pulse"));
            QTableWidgetItem *weight = new QTableWidgetItem(data.value("weight"));

            //set items to table
            tableWidget->setItem(i,0, date);
            tableWidget->setItem(i,1, time);
            tableWidget->setItem(i,2, sys);
            tableWidget->setItem(i,3, dia);
            tableWidget->setItem(i,4, pulse);
            tableWidget->setItem(i,5, weight);

            tableWidget->update();

            i++;
        }

    }
    tableWidget->setColumnWidth(0, 120);

    //buttons
    QPushButton *graph = new QPushButton();
    graph->setIcon(QIcon(":/images/history.png"));
    graph->setIconSize(QSize(70,70));
    graph->setFlat(true);
    QPushButton *send = new QPushButton();
    send->setIcon(QIcon(":/images/send.png"));
    send->setIconSize(QSize(70,70));
    send->setFlat(true);
    buttonsLayout->addWidget(graph);
    buttonsLayout->addWidget(send);

    tableLayout->addWidget(tableWidget);

    gridLayout->addLayout(tableLayout, 0,0);
    gridLayout->addLayout(buttonsLayout, 0, 1);
    gridLayout->setColumnMinimumWidth(0,600);

    //set application menu
    ApplicationMenu *historyMenu = new ApplicationMenu(this);

    //temporary messageboxes for now to indicate actions
    QMessageBox *chartMessage = new QMessageBox(this);
    chartMessage->setText("This will open the chart view");
    QMessageBox *sendMessage = new QMessageBox(this);
    sendMessage->setText("This will open sending dialog");

    tableWidget->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    setLayout(gridLayout);

    //connect buttons
    connect(graph, SIGNAL(clicked()), this, SLOT(handleLineGraphButton()));
    connect(send, SIGNAL(clicked()), sendMessage, SLOT(show()));
}

void HistoryView::handleLineGraphButton()
{
    LineChartView *lineView = new LineChartView(this);
#ifdef Q_WS_MAEMO_5
    lineView->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    lineView->setWindowFlags(lineView->windowFlags() | Qt::Window);
    lineView->show();
}
