#include "applicationmenu.h"
#include <modeldialog.h>
#include <measurement.h>
#include <QMessageBox>
#ifdef Q_WS_MAEMO_5
    #include <QtMaemo5>
#endif
#define HOMEVIEW 1

ApplicationMenu::ApplicationMenu(QWidget *parent, int view) : QMenuBar(parent)
{
    //model selecting dialog
    modelDialog = new ModelDialog(parent);

#ifdef Q_WS_MAEMO_5
    modelDialog->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    modelDialog->setWindowFlags(modelDialog->windowFlags() | Qt::Window);

    //actions to menu

    QAction *model = new QAction(tr("&Device Model Management"), this);
    QAction *send = new QAction(tr("&Send History"), this);
    QAction *user = new QAction(tr("&User Management"), this);
    QAction *clear = new QAction(tr("&Clear history"), this);
    //add actions to menu

    this->addAction(model);
    this->addAction(send);
    this->addAction(user);
    this->addAction(clear);

    message = new QMessageBox(QString(tr("Warnin!")),QString(tr("Do you really want to clear all measurement history?")),QMessageBox::Warning, 0,1,2);

    //add home button if this view if parent view is not home
    if (view != HOMEVIEW)
    {
        QAction *home = new QAction(tr("&Home"),this);
        this->addAction(home);
        connect(home, SIGNAL(triggered()), parent, SLOT(close()));
    }
    //connect action signals to slots
    connect(model, SIGNAL(triggered()), modelDialog, SLOT(show()));
    connect(clear, SIGNAL(triggered()), message, SLOT(show()));
    connect(message, SIGNAL(accepted()), this, SLOT(emptyHistory()));
    connect(send, SIGNAL(triggered()), this, SLOT(sendMail()));
}

void ApplicationMenu::emptyHistory()
{
    Measurement *measurement = Measurement::instance();
    measurement->clearHistory();
}

void ApplicationMenu::sendMail()
{
    smtp = new Smtp("elina.kurkimaki@gmail.com", "elina.kurkimaki@codemate.com", "test", "lähteekö posti?");
    delete smtp;
}

