#include "textedithelper.h"

#include <QTextEdit>
#include <QTextCursor>
#include <QScrollBar>


/*!
    \class TextEditHelper

    \brief Helper utilities for QTextEdit

    Provides functionality QTextEdit doesn't support
    out-of-the-box.

*/


TextEditHelper::TextEditHelper(QTextEdit& editor) : e(editor)
{
}

/*!

    \brief Execute PageUp/PageDown on a text editor.

    Execute either PageUp or PageDown, depending on the
    value of \op. Valid values are QTextCursor::Up and
    QTextCursor::Down.

    PageUp/PageDown method doesn't exist in QTextEdit for Qt4 at
    all, and QScrollBar::triggerAction moves too much
    (potentially preventing the user from seeing one
    line at all). This attempts to compensate for this
    shortcoming.

*/


void TextEditHelper::partialPageUpDown(QTextCursor::MoveOperation op)
{
    QTextCursor crs = e.textCursor();
    QRect crect = e.cursorRect();
    QScrollBar* vbar = e.verticalScrollBar();
    int pstep = vbar->pageStep();
    int newstep = pstep - e.fontMetrics().xHeight() * 2;
    vbar->setPageStep(newstep);

    QAbstractSlider::SliderAction sliderop = (op == QTextCursor::Up ?
        QAbstractSlider::SliderPageStepSub : QAbstractSlider::SliderPageStepAdd);
    vbar->triggerAction(sliderop);
    vbar->setPageStep(pstep);

    // retain cursor at same pos
    QTextCursor newcrs = e.cursorForPosition(crect.topLeft());
    e.setTextCursor(newcrs);
}

/*!

    \brief Move cursor to center of the viewport.

    This can be called to set cursor on a sensible
    position when viewport position no longer
    matches the cursor position, e.g. when setSource
    on QTextBrowser has been invoked.

*/
void TextEditHelper::cursorToCenter()
{
    QRect vpr = e.viewport()->rect();
    QPoint p = vpr.center();
    p.setX(0);

    QTextCursor crs = e.cursorForPosition(p);
    e.setTextCursor(crs);
}
