#include "prfeedview.h"

#include <QDesktopServices>
#include <QFile>
#include <QTextStream>
#include <QUrl>
#include <QListWidget>

#include "ui_prfeedview.h"
#include "prconst.h"
#include "prtopstackedwidget.h"
#include "prappservices.h"

/*!
    \class PrFeedView

    \brief The view with list of feeds.

    Allows the user to select a feed.

    Also contains the "show stash in browser" functionality.

*/


PrFeedView::PrFeedView(PrAppServices* appsrv, QWidget *parent) :
    QWidget(parent), m_appSrv(appsrv),
    m_ui(new Ui::PrFeedView)
{
    m_stackedWidget=(PrTopStackedWidget*)parent;
    m_ui->setupUi(this);    
    m_ui->rotateButton->setEnabled(false);

    QFile file(stashFilename());
    if( !file.exists() ) {
        m_ui->stashButton->setEnabled(false);
    }
    connect(m_ui->closeButton, SIGNAL(clicked()), this, SLOT(closeRequested()));
    connect(m_ui->stashButton, SIGNAL(clicked()), this, SLOT(stash()));
}

QString PrFeedView::stashFilename()
{
    QString location = QDesktopServices::storageLocation(QDesktopServices::DocumentsLocation);
    QString filename = location + "/prstash.html";
    return filename;
}

void PrFeedView::enableStash()
{
    m_ui->stashButton->setEnabled(true);
}

PrFeedView::~PrFeedView()
{
    delete m_ui;
}

void PrFeedView::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
        case QEvent::LanguageChange: {
            m_ui->retranslateUi(this);
            break;
        }
        default: {
            break;
        }
    }
}

QListWidget* PrFeedView::listWidget()
{
    return m_ui->listWidget;
}

void PrFeedView::closeRequested()
{
    QApplication::quit();
}

void PrFeedView::stash()
{
    QStringList list=m_stackedWidget->urlList();
    QString filename = stashFilename();
    if ( list.count()>0) {
        QString outputText("<html><body><p>");
        for (int i=0; i<list.count(); i++)  {
            outputText.append("<p><a href=\"");
            outputText.append(list.at(i));
            outputText.append("\">"+list.at(i)+"</a></p>");
        }
        outputText.append("</p></body></html>");
        QFile file( filename );
        if ( file.open( QIODevice::WriteOnly ) ) {
            QTextStream stream( &file );
            stream << outputText << endl;
        } else {
            qDebug( "Could not create file %s", filename.toAscii().data());
        }
        file.close();
    }
    QUrl url = QUrl::fromLocalFile(filename);
    m_appSrv->launchUrl(url);
}
