#ifndef FEEDINTERFACE_H
#define FEEDINTERFACE_H

#include <QString>
#include <QListWidgetItem>

/*!
    \class FeedEntry

    \brief Concrete class to represent one feed entry (e.g. blog post)

    The 'text body' is either a string, or a file on local
    file system.

    m_contenttype is either 'text/plain' or 'text/html'.

*/

class FeedEntry
{
public:
    QString getBody() const;
    void setBodyString(QString body);
    void setBodyFile(QString fname);

    QString m_title;
    QString m_author;
    QString m_url;

    QString m_contenttype;

    // if bodyfile is empty, 'body' contains the contents
    // xxx make abstract?
    QString m_body;
    QString m_bodyfile;
    // text/plain or text/html, for now
};

/*!
    \class IFeed

    \brief Abstract class representing 'feed' (e.g. an rss feed).

    The string returned by name() will be shown on feed list.
    getEntries() should do the actual work of providing feed entries.

    Optionally, decorate() can alter the appearance (e.g. font)
    of QListWidgetItem.

*/

// interface
class IFeed
{
public:
    virtual QString name() const = 0;
    // get
    virtual void getEntries( QVector<FeedEntry>& entries) const = 0;

    // critique - too ui specific for this class, use visitor?
    virtual void decorate(QListWidgetItem*) const {}

    virtual ~IFeed();
};

/*!
    \class IFeedBundle

    \brief Abstract class representing a group of feeds.

    Only one of these exist per program invocation.

    getFeeds() should instantiate concrete versions of
    IFeed in a fashion that is appropriate for the
    problem, e.g. create PenguinTvFeed objects to show
    feeds previously aggregated by penguintv, or
    FileSystemFeed to just list and present local files.

*/

class IFeedBundle
{
public:
    virtual void getFeeds(QVector< IFeed* >& feeds) = 0;
    virtual ~IFeedBundle();
};

#endif // FEEDINTERFACE_H
