#include "prtextbody.h"
#include <QMouseEvent>
#include <QPoint>
#include <QSize>
#include "prtopstackedwidget.h"
#include <QScrollBar>
#include <QShortcut>
#include "prconst.h"
#include <QTextCursor>
#include "textedithelper.h"
#include "prappservices.h"
#include <QSettings>

PrTextBody::PrTextBody(PrAppServices* appsrv, QWidget *parent) :
    QTextBrowser(parent), m_appSrv(appsrv)
{
    // xxx do not abuse parent
    m_stackedWidget=(PrTopStackedWidget*)parent;
    setOpenExternalLinks(false);
    setOpenLinks(false);

    // meaningless in diablo right now
    //setProperty("FingerScrollable", true);

    // love it or hate it, no horiz scrollbar
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    // one size smaller than default
    zoomOut();
}

void PrTextBody::mousePressEvent(QMouseEvent *e)
{
    QPoint position = e->pos();
    QSize size = this->size();

    m_ignoreMouseRelease = false;
    const int yMax=size.height();
    const int xMax=MOUSE_MARGIN_PIXELS;

    bool botedge = position.y()>= yMax-MOUSE_MARGIN_PIXELS;
    bool leftedge = position.x()<=xMax;
    bool topedge = position.y() <= MOUSE_MARGIN_PIXELS;

    QTextCursor cursor = textCursor();
    if (botedge)
    {
        // bot left - go back to feed list
        if (leftedge)
        {
            m_stackedWidget->setCurrentIndex(0);
            m_ignoreMouseRelease = true;
            e->ignore();
            return;
        }
        // just bot, scroll down
        if ( (m_stackedWidget->linksEnabled() == false) ||
             (m_stackedWidget->linksEnabled() == true && anchorAt(position).length()==0) )
        {
            scrollDown();
            //verticalScrollBar()->triggerAction(QAbstractSlider::SliderPageStepAdd);
            //cursor.movePosition(QTextCursor::NextRow,
            //                    QTextCursor::MoveAnchor,
            //                    50);
            //ensureCursorVisible();
            m_ignoreMouseRelease = true;
            e->ignore();
        }
        return;
    }

    if (topedge)
    {
        //if ( anchorAt(position).length()==0 )
        if ( (m_stackedWidget->linksEnabled() == false) ||
             (m_stackedWidget->linksEnabled() == true && anchorAt(position).length()==0) )
        {
            scrollUp();
            m_ignoreMouseRelease = true;
            e->ignore();
        }
        return;

    }
    QTextBrowser::mousePressEvent(e);
}

void PrTextBody::mouseReleaseEvent(QMouseEvent *e)
{
    QTextCursor crs = textCursor();
    if (crs.hasSelection())
    {
        crs.clearSelection();
        setTextCursor(crs);
    }

    // needed to prevent "surprise" anchor clicking
    if (m_ignoreMouseRelease)
    {
        m_ignoreMouseRelease = false;
        e->ignore();
        return;
    }

    //m_ignoreScrolling=false;
    QTextBrowser::mouseReleaseEvent(e);
}

void PrTextBody::changeEvent(QEvent *e)
{
    QTextBrowser::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        break;
    default:
        break;
    }
}

void PrTextBody::scrollDown()
{
    TextEditHelper(*this).partialPageUpDown(QTextCursor::Down);

}

void PrTextBody::scrollUp()
{
    TextEditHelper(*this).partialPageUpDown(QTextCursor::Up);

}

