#include "filesystemfeedbundle.h"
#include <QFile>
#include <QFileInfo>



bool FilesystemFeedBundle::addPath(const QString& path)
{
    QFileInfo fi(path);
    if (!fi.exists() || fi.isDir())
        return false;

    FilesystemFeed* fsf = new FilesystemFeed;
    fsf->setName(fi.fileName());
    fsf->setFileName(fi.absoluteFilePath());
    m_feeds.append(fsf);
    return true;

}

FilesystemFeedBundle::FilesystemFeedBundle()
{
}

FilesystemFeedBundle::~FilesystemFeedBundle()
{
}


void FilesystemFeedBundle::getFeeds(QVector< IFeed* >& feeds)
{
    foreach( IFeed* feed, m_feeds)
    {
        feeds.append(feed);
    }

}

// Feed *************

FilesystemFeed::FilesystemFeed()
{}

void FilesystemFeed::getEntries( QVector<FeedEntry>& entries) const
{
    entries.clear();
    FeedEntry fe;    
    fe.setBodyFile(m_filename);

    if (m_filename.toLower().endsWith(".htm") || m_filename.toLower().endsWith(".html"))
    {
        fe.m_contenttype = "text/html";
    }
    else
    {
        fe.m_contenttype = "text/plain";
    }

    entries.append(fe);

}

void FilesystemFeed::setName(const QString& name)
{
    m_name = name;
}

QString FilesystemFeed::name() const
{
    return m_name;
}

void FilesystemFeed::setFileName(const QString& fname)
{
    m_filename = fname;
};

