#include "feedrenderer.h"


#include <QFile>
#include <QRegExp>
#include <QTextEdit>
#include <QUrl>
#include <QTextBrowser>

namespace
{
    const int MAX_HTML_LEN = 80000;
}

#include <QVector>

QUrl FeedRenderer::baseUrl()
{
    return QUrl();
};

FeedRenderer::~FeedRenderer()
{
}

TrivialFeedRenderer::TrivialFeedRenderer()
{
}

void TrivialFeedRenderer::renderEntries(const QVector< FeedEntry >& entries, QTextEdit& editor)
{

    QString res;
    foreach (const FeedEntry& fe, entries)
    {                
        QString head = QString(
                "<p><i>%3</i></p><p><a href=\"%1\">%2</a></p><p>").arg(fe.m_url, fe.m_title, fe.m_author);
        res.append(head);
        res.append(fe.getBody());
        res.append("</p><hr/>");
        if (res.length() > MAX_HTML_LEN)
            break;

    }

#ifdef DUMP_XML
    QFile f("/tmp/prout.html");
    f.open(QIODevice::WriteOnly);
    f.write(res.toLocal8Bit());
    f.close();
#endif
    // strip images
    QRegExp re("<img[^>]+>");
    re.setMinimal(true);
    QString stripped;
    QString after = "<i>[i]</i>";
    stripped = res.replace(re, after);
    //qDebug(res.toAscii());
    editor.setHtml(stripped);

}

FileContentRenderer::FileContentRenderer()
{
}

void FileContentRenderer::renderEntries(const QVector< FeedEntry >& entries, QTextEdit& editor)
{
    if (entries.count() == 1 && entries[0].m_contenttype == "text/html")
    {
        const FeedEntry& e = entries.at(0);
        QUrl local = QUrl::fromLocalFile(e.m_bodyfile);
        static_cast<QTextBrowser&>(editor).setSource(local);
        m_baseUrl = local;

        return;
    }

    editor.clear();
    // IN THEORY supports multiple entries - in practice not used

    foreach (const FeedEntry& fe, entries)
    {
        QString body = fe.getBody();
        if (fe.m_contenttype == "text/html")
        {
            editor.insertHtml(body);
        }
        else
        {
            editor.insertPlainText(body);

        }
    }
    editor.moveCursor(QTextCursor::Start);

}

QUrl FileContentRenderer::baseUrl()
{
    return m_baseUrl;
}

FileContentRenderer::~FileContentRenderer()
{
}
