# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *

class ItemModel(QAbstractListModel):
    """Present a QAbstractListModel interface to a list of items from the
    platform-neutral datastore."""

    def __init__(self, items, parent=None, *args):
        QAbstractListModel.__init__(self, parent, *args)
        self.items = items

    def rowCount(self, parent=QModelIndex()):
        return len(self.items)

    def data(self, index, role=Qt.DisplayRole):
        if index.isValid() and role == Qt.DisplayRole:
            return QVariant(self.items[index.row()])
        else:
            return QVariant()

