# -*- coding: utf-8 -*-

from ui_tagsselect import *
from PyQt4 import QtCore, QtGui

class TagsSelect(QtGui.QDialog):
    def __init__(self, title, allownew, parent=None):
        QtGui.QDialog.__init__(self, parent)
        self.ui = Ui_TagsSelect()
        self.ui.setupUi(self)
        self.setWindowTitle(QtGui.QApplication.translate("TagsSelect", title, None, QtGui.QApplication.UnicodeUTF8))
        if allownew:
            self.connect(self.ui.btnAdd, QtCore.SIGNAL('clicked()'), self.onAdd)
        else:
            self.ui.btnAdd.hide()
            self.ui.newTag.hide()
            self.ui.label.hide()
        self.ui.newTag.setFocus()

    def setTags(self, tags, selected):
        tags.sort()
        self.ui.flowLayout.clear()
        for t in tags:
            if t != '':
                button = QtGui.QPushButton(t)
                button.setCheckable(True)
                if t in selected:
                    button.setChecked(True)
                self.ui.flowLayout.addWidget(button)

    # returns all tags as well as selected, in case any have been added
    def getTags(self):
        alltags = []
        selected = []
        i = 0
        button = self.ui.flowLayout.itemAt(i)
        while button is not None:
            button = button.widget()
            alltags.append(str(button.text()))
            if button.isChecked():
                selected.append(str(button.text()))
            i += 1
            button = self.ui.flowLayout.itemAt(i)
        return (alltags, selected)

    def onAdd(self):
        newtag = str(self.ui.newTag.text()).lower()
        button = self.find(newtag)
        if button is None:
            button = QtGui.QPushButton(newtag)
            button.setCheckable(True)
            self.ui.flowLayout.addWidget(button)
        else:
            button = button.widget()
        button.setChecked(True)
        self.ui.newTag.setText(QtCore.QString(""))
        self.ui.newTag.setFocus()

    def find(self, text):
        i = 0
        button = self.ui.flowLayout.itemAt(i)
        while button is not None and button.widget().text() != text:
            i += 1
            button = self.ui.flowLayout.itemAt(i)
        return button

