#!/usr/bin/python
# -*- coding: utf-8 -*-

from ui_projects import *
from qt_itemmodel import ItemModel
from itemview import ItemView
from PyQt4.QtCore import *
from PyQt4.QtGui import *
import datastore
import copy

maemo = False
try:
    maemotest = QtCore.Qt.WA_Maemo5StackedWindow
    maemo = True
except:
    pass

class ProjectDelegate(QStyledItemDelegate):
    def __init__(self, dstore, parent=None, *args):
        QStyledItemDelegate.__init__(self, parent, *args)
        self.dstore = dstore

    def paint(self, painter, option, index):
        value = index.data(Qt.DisplayRole)
        if not value.isValid():
            return
        projectid, projectname = value.toPyObject()
        itemcount = self.dstore.countTasks(datastore.getProject, [projectid, False])
        completeditemcount = self.dstore.countTasks(datastore.getProject, [projectid, True])
        painter.save()
        r = option.rect
        f = painter.font()
        gradientBase = QLinearGradient(QPointF(r.topLeft()), QPointF(r.bottomLeft()))
        base = option.palette.color(QPalette.Window)
        base2 = copy.copy(base)
        base.setRgb(min(255, base.red()+64), min(255, base.green()+64), min(255, base.blue()+64))
        base2.setRgb(max(0, base2.red()-20), max(0, base2.green()-20), max(0, base2.blue()-20))
        gradientBase.setColorAt(0, base)
        gradientBase.setColorAt(1, base2)
        painter.fillRect(r, QBrush(gradientBase))
        painter.drawLine(QPoint(r.left(), r.bottom()), QPoint(r.right(), r.bottom()))
        painter.drawText(r.left()+2, r.top(), r.width(), r.height(), Qt.AlignTop|Qt.AlignLeft, projectname+" ("+str(completeditemcount)+"/"+str(itemcount)+")")
        painter.restore()


class ProjectsView(QtGui.QMainWindow):
    def __init__(self, ds, parent=None):
        QtGui.QWidget.__init__(self, parent)
        if maemo:
            self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow, True)
        self.dstore = ds
        self.ui = Ui_Projects()
        self.ui.setupUi(self)
        self.drawer = ProjectDelegate(ds, self)
        self.ui.listView.setItemDelegate(self.drawer)
        self.itemview = ItemView(ds, self)
        self.itemview.hide()
        self.connect(self.ui.btnAdd, QtCore.SIGNAL('clicked()'), self.onAdd)
        self.ui.listView.clicked.connect(self.onClick)
        self.ui.lineEdit.setFocus()

    def updateProjects(self):
        self.model = ItemModel(self.dstore.getProjects().items())
        self.ui.listView.setModel(self.model)

    def onAdd(self):
        if str(self.ui.lineEdit.text()) != "":
            self.dstore.addProject(str(self.ui.lineEdit.text()))
            self.ui.lineEdit.setText(QtCore.QString(""))
        self.updateProjects()
        self.ui.lineEdit.setFocus()

    def onClick(self, i):
        clickedProject = self.model.data(i)
        if not clickedProject.isValid():
            return
        projectid, projectname = clickedProject.toPyObject()
        self.itemview.setItems(self.dstore.getTasks(datastore.getProject, [projectid, False]))
        self.itemview.show()

