#!/usr/bin/python
# -*- coding: utf-8 -*-

from ui_itemview import *
from qt_itemmodel import *
from qt_itemdelegate import *
from newitem import NewItem
from tagsselect import TagsSelect
from PyQt4 import QtGui,QtCore
import datastore
import os

InstallPath=os.path.abspath(os.path.dirname(__file__))

maemo = False
try:
    maemotest = QtCore.Qt.WA_Maemo5StackedWindow
    maemo = True
except:
    pass

class ItemView(QtGui.QMainWindow):
    def __init__(self, ds, parent=None):
        QtGui.QWidget.__init__(self, parent)
        if maemo:
            self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow, True)
        self.dstore = ds
        self.model = None
        self.unfiltered = None
        self.tagfilter = []
        self.ed = None
        self.ui = Ui_ItemView()
        self.ui.setupUi(self)
        self.drawer = ItemDelegate(ds, self)
        self.ui.listView.setItemDelegate(self.drawer)
        self.ui.listView.clicked.connect(self.onClick)
        tickicon = QtGui.QIcon()
        tickicon.addPixmap(QtGui.QPixmap(InstallPath+"/icons/tick.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.ui.btnTick.setIcon(tickicon)
        nowicon = QtGui.QIcon()
        nowicon.addPixmap(QtGui.QPixmap(InstallPath+"/icons/dotoday.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.ui.btnDoToday.setIcon(nowicon)
        edicon = QtGui.QIcon()
        edicon.addPixmap(QtGui.QPixmap(InstallPath+"/icons/edit.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.ui.btnEdit.setIcon(edicon)
        tficon = QtGui.QIcon()
        tficon.addPixmap(QtGui.QPixmap(InstallPath+"/icons/tagfilter.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.ui.btnTagFilter.setIcon(tficon)
        self.connect(self.ui.btnTagFilter, QtCore.SIGNAL('clicked()'), self.onTagFilter)

    def setItems(self, items):
        self.unfiltered = items
        self.tagfilter = []
        self.model = ItemModel(items, self)
        self.ui.listView.setModel(self.model)

    def onClick(self, i):
        clickedTask = self.model.data(i)
        if not clickedTask.isValid():
            return
        clickedTask = clickedTask.toPyObject()
        if self.ui.toolGroup.checkedButton() == self.ui.btnTick:
            clickedTask.toggleComplete()
            self.dstore.updateTask(clickedTask)
        elif self.ui.toolGroup.checkedButton() == self.ui.btnDoToday:
            clickedTask.doToday()
            self.dstore.updateTask(clickedTask)
        elif self.ui.toolGroup.checkedButton() == self.ui.btnEdit:
            self.ed = NewItem(self.dstore, clickedTask, self)
            self.ed.show()

    def onTagFilter(self):
        ts = TagsSelect("Show tasks tagged with any of...", False, self)
        currenttags = self.tagfilter
        ts.setTags(self.dstore.getAllTags(), currenttags)
        if ts.exec_() == QtGui.QDialog.Accepted:
            alltags, self.tagfilter = ts.getTags()
            if len(self.tagfilter) == 0:
                showitems = self.unfiltered
            else:
                showitems = []
                for i in self.unfiltered:
                    if datastore.getAnyTag(i, self.tagfilter):
                        showitems.append(i)
            self.model = ItemModel(showitems, self)
            self.ui.listView.setModel(self.model)
        ts = None

