#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-
###########################################################################
## File:        main.py
## App name:    SleepAnalyser
## Description: Sleep Analyser records your movement during your sleep. It is able to visualise it on a graph to show
##              how much you move during your sleep. This can help to indicate how you sleep. It also has an alarm
##              function. You can set the alarm and a time window (ex. 30 minutes). The Alarm will then go off
##              sometimes during the time window (as soon as you move more), but latest at the set alarm.
##              Old records can be visualised and you can load records from your friends. SleepAnalyser also has a
##              test function. It will record and visualise much faster. Also it will make a beep when ever your
##              movement goes over the trigger level. Other features are lucid dream and wake up music.
## Copyright:   2010-2011 by George Ruinelli, www.ruinelli.ch, george@ruinelli.ch
## Licence:     GPL
## Target OS:    MAEMO 5 or later on N900
##                Runs also on any OS with python installed, how ever with limited functionality
###########################################################################


from PyQt4.QtCore import *
from PyQt4.QtGui import *
import os, sys

import string


import data


#Get application root path
data.app_path=os.path.dirname(__file__)
if(data.app_path==""): data.app_path="./"
else: data.app_path=data.app_path+"/"



#Load version file
try:
    file = open(data.app_path+"version", 'r')
    data.version = file.readline()
    data.version=data.version[:-1]
    data.build = file.readline()
    print "PasswordManager (frontend) version: "+str(data.version)+ "-"+str(data.build)
except:
    print "Version file not found, please check your installation!"


#GUI files, generated with QT designer
from Ui_StartWindow import *







###########################################################################
## Function:    main
## Description: main function, gets called at start
## Parameters:  none
## Returns:     none
###########################################################################
def main():
    global app
    global StartWindow
    global config
    global clipboard

    app = QApplication(sys.argv)

    #Create main window
    StartWindow = frmStartWindow()
    StartWindow.show()
    
    StartWindow.ui.tabWidget.setCurrentIndex(0)  #change to first page


    clipboard = QApplication.clipboard()



    sys.exit(app.exec_())


def replace_character(text):
    #some characters have to be replaced due shell limitations
    text = string.replace(text, "\\", "\\\\")
    text = string.replace(text, "`", "\`")
    text = string.replace(text, "'", "\'")
    text = string.replace(text, "\"", "\\\"")
    return text



###########################################################################
###########################################################################
## Function:    Class for main window
## Description: All functions needed for the main window
##                This window is shown after application start
## Parameters:  QMainWindow
## Returns:     none
###########################################################################
###########################################################################
class frmStartWindow(QMainWindow):
    def __init__(self):
        QMainWindow.__init__(self)
        try:
            if(data.DeviceIsN900==True): self.setAttribute(Qt.WA_Maemo5StackedWindow) # This attribute makes the whole Stacked Window thing work
        except:
            pass
        self.ui = Ui_StartWindow()
        self.ui.setupUi(self)

        #signals
        QtCore.QObject.connect(self.ui.txtMasterpassword, QtCore.SIGNAL("textChanged(const QString&)"), self.Generate)
        QtCore.QObject.connect(self.ui.txtText, QtCore.SIGNAL("textChanged(const QString&)"), self.Generate)
        QtCore.QObject.connect(self.ui.bCopy, QtCore.SIGNAL("clicked()"), self.Copy_to_Clipboard)
        
        
        QtCore.QObject.connect(self.ui.txtAccount, QtCore.SIGNAL("textChanged(const QString&)"), self.Generate)
        QtCore.QObject.connect(self.ui.cbHash, QtCore.SIGNAL("currentIndexChanged(const QString&)"), self.Generate)
        QtCore.QObject.connect(self.ui.cbHMAC, QtCore.SIGNAL("toggled(bool)"), self.Generate)
        QtCore.QObject.connect(self.ui.cbCharacters, QtCore.SIGNAL("currentIndexChanged(const QString&)"), self.Generate)
        QtCore.QObject.connect(self.ui.cbCharacters, QtCore.SIGNAL("editTextChanged(const QString&)"), self.Generate)
        QtCore.QObject.connect(self.ui.sbLength, QtCore.SIGNAL("valueChanged(const QString&)"), self.Generate)
        QtCore.QObject.connect(self.ui.cbTrim, QtCore.SIGNAL("toggled(bool)"), self.Generate)
        
        
        QtCore.QObject.connect(self.ui.txtModifier, QtCore.SIGNAL("textChanged(const QString&)"), self.Generate)
        QtCore.QObject.connect(self.ui.txtPrefix, QtCore.SIGNAL("textChanged(const QString&)"), self.Generate)
        QtCore.QObject.connect(self.ui.txtSuffix, QtCore.SIGNAL("textChanged(const QString&)"), self.Generate)
        QtCore.QObject.connect(self.ui.cbL33t, QtCore.SIGNAL("currentIndexChanged(const QString&)"), self.Generate)
        QtCore.QObject.connect(self.ui.cbL33t, QtCore.SIGNAL("currentIndexChanged(int)"), self.Enable_L33t)
        QtCore.QObject.connect(self.ui.cbL33t_Level, QtCore.SIGNAL("currentIndexChanged(const QString&)"), self.Generate)
        
        
        

        QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL("triggered()"), self.About)
        QtCore.QObject.connect(self.ui.actionConfiguration, QtCore.SIGNAL("triggered()"), self.Configuration)
        QtCore.QObject.connect(self.ui.actionHelp, QtCore.SIGNAL("triggered()"), self.Help)










    def Generate(self):
        global clipboard
        masterpassword=self.ui.txtMasterpassword.text()
        text=self.ui.txtText.text()
        
        account=self.ui.txtAccount.text()
        hash=self.ui.cbHash.currentText()
        characters=self.ui.cbCharacters.currentText()
        length=str(self.ui.sbLength.value())
        
        modifier=self.ui.txtModifier.text()
        prefix=self.ui.txtPrefix.text()
        suffix=self.ui.txtSuffix.text()
        l33t=self.ui.cbL33t.currentText()
        l33t_level=self.ui.cbL33t_Level.currentText()
        

        masterpassword = replace_character(masterpassword)
        text = replace_character(text)
        account = replace_character(account)
        characters = replace_character(characters)
        modifier = replace_character(modifier)
        prefix = replace_character(prefix)
        suffix = replace_character(suffix)
        l33t = replace_character(l33t)
        
#        ####### FROM THE DOCUMENTATION OF PASSWORD MAKER: ###############
#        If a command-line argument is missing or not specified in the "Defaults" of
#        passwordmaker.rdf or the file pointed to by -f/--file, these built-in defaults are
#        used in its place:
#
#            masterPassword : none
#            url            : none
#            algorithm      : MD5
#            hmac           : no
#            trim           : yes
#            length         : 8
#            characters     : ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789`~!@#$%^&*()_-+={}|[]\:";'<>?,./
#            useLeet        : none
#            leetLevel      : 0
#            username       : none
#            modifier       : none
#            prefix         : none
#            suffix         : none
                

        if(masterpassword !="" and text!=""):
            cmd="passwordmaker -m \"" + masterpassword + "\" -r \"" + text + "\" -a " + hash + " -g " + length
            
            if(account != ""): cmd = cmd + " -u \"" + account + "\""
            if(characters != ""): cmd = cmd + " -c \"" + characters + "\""
            if(modifier != ""): cmd = cmd + " -d \"" + modifier + "\""
            if(prefix != ""): cmd = cmd + " -p \"" + prefix + "\""
            if(suffix != ""): cmd = cmd + " -s \"" + suffix + "\""
            
            if(l33t != "none"):
                cmd = cmd + " -l " + l33t + " -e " + l33t_level
            

            if(self.ui.cbHMAC.isChecked()==True): cmd = cmd + " -x"
            if(self.ui.cbTrim.isChecked()==True): cmd = cmd + " -0"

#            print cmd

            output = os.popen(str(cmd)).read() # run cmd and make the output look like a file I can read
            arr=output.split("\n")
            
            password=arr[0]
            
#            print password
            
            if(password[:16]=="   passwordmaker"):
                QtGui.QMessageBox.critical(self, "PasswordMaker", "The return of passwordmaker seems not to be a password. Please check your input of validity and/or update to the latest version!", QtGui.QMessageBox.Ok)
                password=""

            
        else: password=""


        self.ui.txtPassword.setText(password)





    def Enable_L33t(self,  index):
        if(index==0): self.ui.cbL33t_Level.setEnabled(False)
        else: self.ui.cbL33t_Level.setEnabled(True)





    def Copy_to_Clipboard(self):
        clipboard.setText(self.ui.txtPassword.text())



    def About(self):
        QtGui.QMessageBox.about(None, "About PasswordMaker "+str(data.version)+"-"+str(data.build),
        "Passwordmaker (cli version): Copyright by http://passwordmaker.org\n\n"+\
        "Frontend: Copyright 2011 by George Ruinelli."+"\n"+\
        "Contact: george@ruinelli.ch\n" +\
        "Website: http://www.ruinelli.ch")



    def Configuration(self):
        QtGui.QMessageBox.about(None, "PasswordMaker ", "Not yet implemented")



    def Help(self):
        QtGui.QMessageBox.about(None, "PasswordMaker ", "Please see http://passwordmaker.org")






    ###########################################################################
    ## Function:    closeEvent
    ## Description: Close event: Save config, close program
    ## Parameters:  self, event
    ## Returns:     none
    ###########################################################################
    def closeEvent(self, event): ##(Class StartWindow)
        global config











###########################################################################
main() # great, now we can start it.
