#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-
###########################################################################
## File:        main.py
## App name:    SleepAnalyser
## Description: Sleep Analyser records your movement during your sleep. It is able to visualise it on a graph to show
##              how much you move during your sleep. This can help to indicate how you sleep. It also has an alarm
##              function. You can set the alarm and a time window (ex. 30 minutes). The Alarm will then go off
##              sometimes during the time window (as soon as you move more), but latest at the set alarm.
##              Old records can be visualised and you can load records from your friends. SleepAnalyser also has a
##              test function. It will record and visualise much faster. Also it will make a beep when ever your
##              movement goes over the trigger level. Other features are lucid dream and wake up music.
## Copyright:   2010-2011 by George Ruinelli, www.ruinelli.ch, george@ruinelli.ch
## Licence:     GPL
## Target OS:    MAEMO 5 or later on N900
##                Runs also on any OS with python installed, how ever with limited functionality
###########################################################################


from PyQt4.QtCore import *
from PyQt4.QtGui import *
import os, sys



import data


#Get application root path
data.app_path=os.path.dirname(__file__)
if(data.app_path==""): data.app_path="./"
else: data.app_path=data.app_path+"/"



#Load version file
try:
    file = open(data.app_path+"version", 'r')
    data.version = file.readline()
    data.version=data.version[:-1]
    data.build = file.readline()
    print "PasswordManager Version: "+str(data.version)+ "-"+str(data.build)
except:
    print "Version file not found, please check your installation!"


#GUI files, generated with QT designer
from Ui_StartWindow import *







###########################################################################
## Function:    main
## Description: main function, gets called at start
## Parameters:  none
## Returns:     none
###########################################################################
def main():
    global app
    global StartWindow
    global config
    global clipboard

    app = QApplication(sys.argv)

    #Create main window
    StartWindow = frmStartWindow()
    StartWindow.show()


    clipboard = QApplication.clipboard()



    sys.exit(app.exec_())






###########################################################################
###########################################################################
## Function:    Class for main window
## Description: All functions needed for the main window
##                This window is shown after application start
## Parameters:  QMainWindow
## Returns:     none
###########################################################################
###########################################################################
class frmStartWindow(QMainWindow):
    def __init__(self):
        QMainWindow.__init__(self)
        try:
            if(data.DeviceIsN900==True): self.setAttribute(Qt.WA_Maemo5StackedWindow) # This attribute makes the whole Stacked Window thing work
        except:
            pass
        self.ui = Ui_StartWindow()
        self.ui.setupUi(self)

        #signals
        QtCore.QObject.connect(self.ui.txtMasterpassword, QtCore.SIGNAL("textChanged(const QString&)"), self.Input)
        QtCore.QObject.connect(self.ui.txtText, QtCore.SIGNAL("textChanged(const QString&)"), self.Input)
        QtCore.QObject.connect(self.ui.bCopy, QtCore.SIGNAL("clicked()"), self.Copy_to_Clipboard)

        QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL("triggered()"), self.About)
        QtCore.QObject.connect(self.ui.actionConfiguration, QtCore.SIGNAL("triggered()"), self.Configuration)
        QtCore.QObject.connect(self.ui.actionHelp, QtCore.SIGNAL("triggered()"), self.Help)





    def Input(self, text):
        global clipboard
        masterpassword=self.ui.txtMasterpassword.text()
        text=self.ui.txtText.text()

        if(masterpassword !="" and text!=""):
            cmd="passwordmaker -m "+masterpassword+" -r "+text
#            print cmd

            output = os.popen(str(cmd)).read() # run cmd and make the output look like a file I can read
            arr=output.split("\n")

            password=arr[0]
        else: password=""


        self.ui.txtPassword.setText(password)







    def Copy_to_Clipboard(self):
        clipboard.setText(self.ui.txtPassword.text())



    def About(self):
        QtGui.QMessageBox.about(None, "About PasswordMaker "+str(data.version)+"-"+str(data.build),
        "Passwordmaker (cli version): Copyright by http://passwordmaker.org\n\n"+\
        "Frontend: Copyright 2011 by George Ruinelli."+"\n"+\
        "Contact: george@ruinelli.ch\n" +\
        "Website: http://www.ruinelli.ch")



    def Configuration(self):
        QtGui.QMessageBox.about(None, "PasswordMaker ", "Not yet implemented")



    def Help(self):
        QtGui.QMessageBox.about(None, "PasswordMaker ", "Please see http://passwordmaker.org")






    ###########################################################################
    ## Function:    closeEvent
    ## Description: Close event: Save config, close program
    ## Parameters:  self, event
    ## Returns:     none
    ###########################################################################
    def closeEvent(self, event): ##(Class StartWindow)
        global config











###########################################################################
main() # great, now we can start it.
