// checksum 0x9a77 version 0x30001
/*
  This file was generated by the Mobile Qt Application wizard of Qt Creator.
  MainWindow is a convenience class containing mobile device specific code
  such as screen orientation handling.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "qcontactchooserdialog.h"
#include <qmobilityglobal.h>
#include <QContactAbstractRequest>
#include <QContactFetchRequest>
#include <QContactManager>
#include <QContactRemoveRequest>
#include <QMainWindow>
#include <QMenuBar>
#include <QMessageService>
#include <QtGui/QMainWindow>
#include <QGeoPositionInfo>
#include <QGeoPositionInfoSource>
#include <QVariant>

QTM_USE_NAMESPACE

namespace Ui {
    class MainWindow;
}

// TODO: QPair<QString, QList<QString>>
struct work {
    QString message;
    QList<QVariant> recipients;
};

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    void sendMessage();
    void setOrientation(ScreenOrientation orientation);
    void showExpanded();

private:
    Ui::MainWindow *ui;
    QMap<QString, QString> allContacts;  // Temporary place for guid->phone number mappings
    int allContactsIndex;
    QMap<QString, QVariant> emergencyContacts; // guid->phone number; saved in preferences file "Whatever/PanicButton"
    int emergencyContactsIndex;
    QString panicMessage; // saved in preferences file "Whatever/PanicButton"
    QGeoPositionInfoSource *source;
    QGeoPositionInfo location;
    QMessageService *messageService;
    QList<work *> workQueue;  // TODO: QList<QPair<QString, QList<QString>> *>
    bool messageServiceReady;
    int gpsUpdateInterval; // in seconds; saved in preferences file "Whatever/PanicButton"
    bool gpsUpdateIntervalSet;
    bool deleteAllContactsOnPanic; // saved in preferences file "Whatever/PanicButton"
    bool runApplicationOnPanic;  // saved in preferences file "Whatever/PanicButton"
    QString runThisApplicationOnPanic; // saved in preferences file "Whatever/PanicButton"
    bool writeDefaultSettings; // If deleteAllContactsOnPanic is true AND someone pressed the Panic Button.
    QContactRemoveRequest *allContactsRemoveRequest;  // used when deleting all contacts; created and destroyed as needed
    QContactManager cm;
    QContactFetchRequest allContactsFetchRequest;
    QContactFetchRequest emergencyContactsFetchRequest;
    QContactChooserDialog chooserDialog;

    void addToChooserDialog(QContactFetchRequest &request);
    void addToEmergencyContacts(QContactFetchRequest &request);
    bool buildEmergencyContactsFetchRequest();
    QList<QVariant> phoneNumbers();
    void printEmergencyContacts();

private slots:
    void allContactsFetchRequest_resultsAvailable();
    void allContactsFetchRequest_stateChanged(QContactAbstractRequest::State);
    void allContactsRemoveRequest_stateChanged(QContactAbstractRequest::State);
    void chooserDialog_accepted();
    void chooserDialog_rejected();
    void contactGPS();
    void createAllContactsRemoveRequest();
    void emergencyContactsFetchRequest_stateChanged(QContactAbstractRequest::State);
    void emergencyContactsFetchRequestUpdate_resultsAvailable();
    void fetchEmergencyContacts();
    void messageService_stateChanged(QMessageService::State newState);
    void on_actionAbout_Panic_Button_triggered();
    void on_actionChoose_Contacts_triggered();
    void on_actionClear_Contacts_triggered();
    void on_actionDelete_All_Contacts_On_Panic_toggled(bool checked);
    void on_actionHelp_triggered();
    void on_actionRun_Application_On_Panic_toggled(bool checked);
    void on_actionSet_GPS_Update_Interval_triggered();
    void on_actionSet_Panic_Message_triggered();
    void on_panicButton_clicked();
    void source_positionUpdated(const QGeoPositionInfo &info);
};

#endif // MAINWINDOW_H
