#!/usr/bin/python
# -*- coding: utf-8 -*-

import gobject, gtk
import hildon
from hildondesktop import StatusMenuItem
import time
import dbus
from dbus.mainloop.glib import DBusGMainLoop
from os import path, remove, system
from commands import getoutput
from ConfigParser import SafeConfigParser

try:
    remove("/home/user/.openssh-status-connected")
except:
    pass

class opensshStatus(StatusMenuItem):
    def __init__(self):
        StatusMenuItem.__init__(self)

        self.trackingEnabled = True
        self.stopTracking = True
        self.stopWhenIdle = False
        self.stopAfterMinutes = "5 minutes"
        self.confirmDisconnect = True
        self.showRestartButton = True
        self.showAllConnections = True
        self.showSettingsButton = True
        self.showConnected = True
        connectedIcon = "symbol"
        self.keepWifiPMOff = False
        self.toggleWifiPM = False
        self.wifiPMOffSec = "2 seconds"
        self.wifiPMOnSec = "4 seconds"
        wifiPMIcon = True
        self.showAllDialog = False
        self.skipSystemCheck = False
        configReverseOrder = False
        self.configShowWifiHint = True
        
        try:
            self.wlanIP = getoutput("/sbin/ifconfig wlan0 | grep 'inet addr:'").strip().split()[1].replace('addr:','')
        except:
            self.wlanIP = "None"
        
        self.parser = SafeConfigParser()
        self.parser.optionxform = str
        if path.isfile("/home/user/.openssh-status-widget"):
            try:
                self.parser.read('/home/user/.openssh-status-widget')
            except:
                system("rm /home/user/.openssh-status-widget")
            else:
                if not self.parser.has_section('options'):
                    system("rm /home/user/.openssh-status-widget")
        if not path.isfile("/home/user/.openssh-status-widget"):
            configFile = open('/home/user/.openssh-status-widget', 'w')
            self.parser.add_section('options')
            self.parser.set('options', 'trackingEnabled', str(self.trackingEnabled))
            self.parser.set('options', 'stopTracking', str(self.stopTracking))
            self.parser.set('options', 'stopWhenIdle', str(self.stopWhenIdle))
            self.parser.set('options', 'stopAfterMinutes', str(self.stopAfterMinutes) + " minutes")
            self.parser.set('options', 'confirmDisconnect', str(self.confirmDisconnect))
            self.parser.set('options', 'showRestartButton', str(self.showRestartButton))
            self.parser.set('options', 'showAllConnections', str(self.showAllConnections))
            self.parser.set('options', 'showSettingsButton', str(self.showSettingsButton))
            self.parser.set('options', 'showConnected', str(self.showConnected))
            self.parser.set('options', 'connectedIcon', str(connectedIcon))
            self.parser.set('options', 'wifiPMIcon', str(wifiPMIcon))
            self.parser.set('options', 'skipSystemCheck', str(self.skipSystemCheck))
            self.parser.set('options', 'configReverseOrder', str(configReverseOrder))
            self.parser.set('options', 'configShowWifiHint', str(self.configShowWifiHint))
            self.parser.add_section('wifipm')
            self.parser.set('wifipm', 'keepWifiPMOff', str(self.keepWifiPMOff))
            self.parser.set('wifipm', 'toggleWifiPM', str(self.toggleWifiPM))
            self.parser.set('wifipm', 'wifiPMOffSec', str(self.wifiPMOffSec))
            self.parser.set('wifipm', 'wifiPMOnSec', str(self.wifiPMOnSec))
            self.parser.write(configFile)
            configFile.close()
        else:
            configChanged = False
            self.parser.read('/home/user/.openssh-status-widget')
            if self.parser.has_section('options'):
                if self.parser.has_option('options', 'trackingEnabled'):
                    self.trackingEnabled = self.parser.getboolean('options', 'trackingEnabled')
                if self.parser.has_option('options', 'stopTracking'):
                    self.stopTracking = self.parser.getboolean('options', 'stopTracking')
                if self.parser.has_option('options', 'stopWhenIdle'):
                    self.stopWhenIdle = self.parser.getboolean('options', 'stopWhenIdle')
                if self.parser.has_option('options', 'stopAfterMinutes'):
                    self.stopAfterMinutes = int(self.parser.get('options', 'stopAfterMinutes').strip('_').split()[0]) # fix changed syntax when updating from < v1.6-0
                else:
                    self.stopAfterMinutes = int(self.stopAfterMinutes.split()[0])
                if self.parser.has_option('options', 'confirmDisconnect'):
                    self.confirmDisconnect = self.parser.getboolean('options', 'confirmDisconnect')
                if self.parser.has_option('options', 'showRestartButton'):
                    self.showRestartButton = self.parser.getboolean('options', 'showRestartButton')
                if self.parser.has_option('options', 'showAllConnections'):
                    self.showAllConnections = self.parser.getboolean('options', 'showAllConnections')
                if self.parser.has_option('options', 'showSettingsButton'):
                    self.showSettingsButton = self.parser.getboolean('options', 'showSettingsButton')
                if self.parser.has_option('options', 'showConnected'):
                    self.showConnected = self.parser.getboolean('options', 'showConnected')
                if self.parser.has_option('options', 'connectedIcon'):
                    connectedIcon = self.parser.get('options', 'connectedIcon').strip('_')
                if self.parser.has_option('options', 'wifiPMIcon'):
                    wifiPMIcon = self.parser.getboolean('options', 'wifiPMIcon')
                if self.parser.has_option('options', 'skipSystemCheck'):
                    self.skipSystemCheck = self.parser.getboolean('options', 'skipSystemCheck')
                if self.parser.has_option('options', 'configShowWifiHint'):
                    self.configShowWifiHint = self.parser.getboolean('options', 'configShowWifiHint')
                else:
                    self.parser.set('options', 'configShowWifiHint', str(self.configShowWifiHint))
                    configChanged = True
            if self.parser.has_section('wifipm'):
                if self.parser.has_option('wifipm', 'keepWifiPMOff'):
                    self.keepWifiPMOff = self.parser.getboolean('wifipm', 'keepWifiPMOff')
                if self.parser.has_option('wifipm', 'toggleWifiPM'):
                    self.toggleWifiPM = self.parser.getboolean('wifipm', 'toggleWifiPM')
                if self.parser.has_option('wifipm', 'wifiPMOffSec'):
                    self.wifiPMOffSec = self.parser.get('wifipm', 'wifiPMOffSec')
                if self.parser.has_option('wifipm', 'wifiPMOnSec'):
                    self.wifiPMOnSec = self.parser.get('wifipm', 'wifiPMOnSec')
            else:
                configChanged = True
                self.parser.add_section('wifipm')
                self.parser.set('wifipm', 'keepWifiPMOff', str(self.keepWifiPMOff))
                self.parser.set('wifipm', 'toggleWifiPM', str(self.toggleWifiPM))
                self.parser.set('wifipm', 'wifiPMOffSec', str(self.wifiPMOffSec))
                self.parser.set('wifipm', 'wifiPMOnSec', str(self.wifiPMOnSec))
            if configChanged:
                self.write_config()
        
        self.icon=gtk.gdk.pixbuf_new_from_file("/usr/share/icons/hicolor/18x18/hildon/openssh-status_no-users.png")
        try:
            self.icon_plus=gtk.gdk.pixbuf_new_from_file("/usr/share/icons/hicolor/18x18/hildon/openssh-status_users_"+connectedIcon.lower()+".png")
        except:
            self.icon_plus=gtk.gdk.pixbuf_new_from_file("/usr/share/icons/hicolor/18x18/hildon/openssh-status_users_symbol.png")

        self.button=hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.button.set_style(hildon.BUTTON_STYLE_PICKER)
        self.button.set_alignment(0.2,0.5,1,1)

        self.button2=hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.button2.set_style(hildon.BUTTON_STYLE_PICKER)
        self.button2.set_alignment(1,0.5,0,0)
        self.button2.set_image_alignment(1,0.5)

        self.image_off=gtk.image_new_from_file("/usr/share/icons/hicolor/48x48/hildon/openssh-status_off.png")
        self.image_on=gtk.image_new_from_file("/usr/share/icons/hicolor/48x48/hildon/openssh-status_on.png")
        self.button.set_image_position(gtk.POS_LEFT)
        
        self.image_wifi_pm_toggle=gtk.image_new_from_file("/usr/share/icons/hicolor/48x48/hildon/openssh-status_wifipm_toggle.png")
        self.image_wifi_pm_off=gtk.image_new_from_file("/usr/share/icons/hicolor/48x48/hildon/openssh-status_wifipm_off.png")
        self.image_wifi_pm_on=gtk.image_new_from_file("/usr/share/icons/hicolor/48x48/hildon/openssh-status_wifipm_on.png")

        if self.keepWifiPMOff:
            if self.toggleWifiPM:
                self.button2.set_image(self.image_wifi_pm_toggle)
            else:
                self.button2.set_image(self.image_wifi_pm_off)
        else:
            self.button2.set_image(self.image_wifi_pm_on)

        hbox=gtk.HBox(False, 0)
        hbox.pack_start(self.button, True, True, 0)
        hbox.pack_start(self.button2, False, False, 0)

        self.add(hbox)
        self.show_all()

        if not wifiPMIcon:
            self.button2.hide()

        self.on = False
        self.connected = False
        self.waitWhileIdle = False
        self.refresh = False
        self.loops = 0
        self.labelConnected = 0
        self.sshJustOff = 0
        
        self.systemCheck()
        self.start()

        self.button.connect("clicked", self.buttonClicked)
        self.button.tap_and_hold_setup(None, None, 0)
        self.button.connect("tap-and-hold", self.buttonPressed)

        self.button2.connect("clicked", self.button2Clicked)
        self.button2.tap_and_hold_setup(None, None, 0)
        self.button2.connect("tap-and-hold", self.button2Pressed)

        DBusGMainLoop(set_as_default=True)
        bus = dbus.SystemBus()
        bus.add_signal_receiver(self.handleWLAN, path='/com/nokia/icd', dbus_interface='com.nokia.icd', signal_name='status_changed')
        bus.add_signal_receiver(self.handleDisplay, path='/com/nokia/mce/signal', dbus_interface='com.nokia.mce.signal', signal_name='display_status_ind')
        mceObj = bus.get_object("com.nokia.mce", "/com/nokia/mce/request")
        mceIF = dbus.Interface(mceObj, "com.nokia.mce.request")
        displayStatus = mceIF.get_display_status()
        self.handleDisplay(displayStatus)
        
        bus = dbus.SessionBus()
        bus.add_signal_receiver(self.dbus, path='/', dbus_interface='org.maemo.oswoptions', signal_name='changed1')
        
    def dbus(self, param, val):
        if param == "trackingEnabled":
            self.waitWhileIdle = False
            if val == "True":
                self.trackingEnabled = True
            else:
                self.trackingEnabled = False
            self.parser.set('options', 'trackingEnabled', val)
            self.start()
                
        
        if param == "stopTracking":
            if val == "True":
                self.stopTracking = True
            else:
                self.stopTracking = False
                if not self.refresh:
                    self.refresh = True
                    self.loopCount = -1
                    gobject.timeout_add(5000, self.sshTracker)
            self.parser.set('options', 'stopTracking', val)
        
        if param == "stopWhenIdle":
            self.waitWhileIdle = False
            if val == "True":
                self.stopWhenIdle = True
            else:
                self.stopWhenIdle = False
            self.parser.set('options', 'stopWhenIdle', val)
        
        if param == "stopAfterMinutes":
            self.stopAfterMinutes = int(val.strip('_').split()[0])
            self.parser.set('options', 'stopAfterMinutes', val)
        
        if param == "confirmDisconnect":
            if val == "True":
                self.confirmDisconnect = True
            else:
                self.confirmDisconnect = False
            self.parser.set('options', 'confirmDisconnect', val)
        
        if param == "showRestartButton":
            if val == "True":
                self.showRestartButton = True
            else:
                self.showRestartButton = False
            self.parser.set('options', 'showRestartButton', val)
        
        if param == "showAllConnections":
            if val == "True":
                self.showAllConnections = True
            else:
                self.showAllConnections = False
            self.parser.set('options', 'showAllConnections', val)
        
        if param == "showSettingsButton":
            if val == "True":
                self.showSettingsButton = True
            else:
                self.showSettingsButton = False
            self.parser.set('options', 'showSettingsButton', val)
        
        if param == "showConnected":
            if val == "True":
                if self.sshConnected:
                    self.connected = True
                    self.set_status_area_icon(self.icon_plus)
                if self.sshRunning and not self.sshConnected:
                    self.connected = False
                    self.set_status_area_icon(self.icon)
                self.showConnected = True
            else:
                if self.sshRunning or self.sshConnected:
                    self.set_status_area_icon(self.icon)
                else:
                    self.set_status_area_icon(None)
                self.connected = False
                self.showConnected = False                
            self.parser.set('options', 'showConnected', val)
        
        if param == "connectedIcon":
            try:
                self.icon_plus=gtk.gdk.pixbuf_new_from_file("/usr/share/icons/hicolor/18x18/hildon/openssh-status_users_"+val.strip('_').lower()+".png")
            except:
                self.icon_plus=gtk.gdk.pixbuf_new_from_file("/usr/share/icons/hicolor/18x18/hildon/openssh-status_users_symbol.png")
            if self.sshConnected:
                self.connected = True
                self.set_status_area_icon(self.icon_plus)
            self.parser.set('options', 'connectedIcon', val)
        
        if param == "wifiPMIcon":
            if val == "True":
                self.button2.show()
            else:
                self.button2.hide()
            self.parser.set('options', 'wifiPMIcon', val)
        
        if param == "configReverseOrder":
            self.parser.set('options', 'configReverseOrder', val)
        
        if param == "keepWifiPMOff":
            if val == "True":
                self.keepWifiPMOff = True
                if self.toggleWifiPM:
                    self.button2.set_image(self.image_wifi_pm_toggle)
                else:
                    self.button2.set_image(self.image_wifi_pm_off)
            else:
                self.keepWifiPMOff = False
                self.button2.set_image(self.image_wifi_pm_on)
            self.parser.set('wifipm', 'keepWifiPMOff', val)
        
        if param == "toggleWifiPM":
            if val == "True":
                self.toggleWifiPM = True
                self.button2.set_image(self.image_wifi_pm_toggle)
            else:
                self.toggleWifiPM = False
                self.button2.set_image(self.image_wifi_pm_off)
            self.parser.set('wifipm', 'toggleWifiPM', val)
        
        if param == "wifiPMOffSec":
            self.wifiPMOffSec = val
            self.parser.set('wifipm', 'wifiPMOffSec', val)
    
        if param == "wifiPMOnSec":
            self.wifiPMOnSec = val
            self.parser.set('wifipm', 'wifiPMOnSec', val)
    
    def handleWLAN(self, var1, network, status, var4):
        if network == "WLAN_INFRA":
            if status == "CONNECTED":
                try:
                    self.wlanIP = getoutput("/sbin/ifconfig wlan0 | grep 'inet addr:'").strip().split()[1].replace('addr:','')
                except:
                    self.wlanIP = "None"
                if self.wlanIP != "None" and self.keepWifiPMOff:
                    system("sudo openssh-status.sh wlan_started")
            if status == "DISCONNECTING":
                system("sudo openssh-status.sh wlan_stopped")
            if status == "IDLE":
                self.wlanIP = "None"
    
    def handleDisplay(self, displayStatus):
        if displayStatus == "on" or displayStatus == "dimmed":
            self.loops = 0
            if self.refresh:
                self.sshTracker()
        if displayStatus == "off":
            self.loops = 17279
            if self.stopWhenIdle:
                self.loops = 11
                if self.stopAfterMinutes == 1:
                    self.loops = 5
    
    def systemCheck(self):
        if not self.skipSystemCheck:
            sshSystemRespawn = False
            if path.isfile("/etc/event.d/sshd"):
                sshFile = open("/etc/event.d/sshd",'r')
                lines = sshFile.readlines()
                sshFile.close()
                for line in lines:
                    if line.strip('\n').strip(' ') == "respawn":
                        sshSystemRespawn = True
            if sshSystemRespawn:
                self.adjustSshFile()
        
    def start(self):
        self.sshStatus()
        if self.trackingEnabled:
            self.sshUsers()
        if self.sshRunning:
            self.on = True
            self.button.set_image(self.image_on)
            if self.trackingEnabled:
                if self.sshConnected and self.showConnected:
                    self.connected = True
                    self.set_status_area_icon(self.icon_plus)
                else:
                    self.set_status_area_icon(self.icon)
                if self.sshConnected == 1:
                    self.button.set_text("OpenSSH Server ", "1 connection")
                else:
                    self.button.set_text("OpenSSH Server ", str(self.sshConnected)+" connections")
                if not self.refresh:
                    self.refresh = True
                    self.loopCount = -1
                    self.sshTracker()
                    gobject.timeout_add(5000, self.sshTracker)
            else:
                self.set_status_area_icon(self.icon)
                self.button.set_text("OpenSSH Server ", "On")
        else:
            self.button.set_image(self.image_off)
            if self.trackingEnabled:
                if self.sshConnected:
                    if self.showConnected:
                        self.connected = True
                        self.set_status_area_icon(self.icon_plus)
                    else:
                        self.set_status_area_icon(self.icon)
                    if self.sshConnected == 1:
                        self.button.set_text("OpenSSH Server ", "1 connection")
                    else:
                        self.button.set_text("OpenSSH Server ", str(self.sshConnected)+" connections")
                else:
                    self.set_status_area_icon(None)
                    self.button.set_text("OpenSSH Server ", "Off")
                if not self.refresh:
                    self.refresh = True
                    self.loopCount = -1
                    gobject.timeout_add(5000, self.sshTracker)
            else:
                self.set_status_area_icon(None)
                self.button.set_text("OpenSSH Server ", "Off")
                gobject.timeout_add(10000, self.sshTrackOnceOnStartWhenOff)
                
    def sshTrackOnceOnStartWhenOff(self):
        if not self.trackingEnabled:
            self.sshStatus()
            if self.sshRunning:
                self.on = True
                self.button.set_image(self.image_on)
                self.set_status_area_icon(self.icon)
                self.button.set_text("OpenSSH Server ", "On")
        return False
            
    def adjustSshFile(self):
        self.dialog = gtk.Dialog("OpenSSH status", None)
        text = gtk.Label("The widget has detected a system configuration for respawning the OpenSSH Server . "
        "For error-free function of this widget respawning the server should be disabled.\n\nDo you want the widget to disable it now?\n")
        text.set_line_wrap(True)
        self.dialog.vbox.pack_start(text)
        buttonYes = self.dialog.add_button("Yes", gtk.RESPONSE_YES)
        buttonNo = self.dialog.add_button("No", gtk.RESPONSE_NO)
        buttonDetails = self.dialog.add_button("Details", gtk.RESPONSE_NONE)
        
        buttonYes.connect("clicked", self.adjustYes)
        buttonNo.connect("clicked", self.adjustNo)
        buttonDetails.connect("clicked", self.detailsMessage)
        
        self.dialog.show_all()
        
    def adjustYes(self, dummy):
        system("sudo openssh-status.sh disable_respawn")
        self.dialog.destroy()
        message = gtk.Dialog("OpenSSH status", None)
        text = gtk.Label("Done! Please reboot the N900.")
        text.set_line_wrap(True)
        message.vbox.add(text)
        message.add_button("Close", gtk.RESPONSE_OK)
            
        message.show_all()
        message.run()
        message.destroy()
        
    def adjustNo(self, dummy):
        self.dialog.destroy()

    def detailsMessage(self,dummy):
        message = gtk.Dialog("OpenSSH status", None)
        text = gtk.Label("The widget will modify the file\n\n/etc/event.d/sshd\n\nby commenting out the relevant line\nin the existing file. Nothing will be deleted.")
        text.set_line_wrap(True)
        message.vbox.add(text)
        message.add_button("Close", gtk.RESPONSE_OK)
            
        message.show_all()
        message.run()
        message.destroy()
        
    def sshStatus(self):
        self.sshRunning = int(getoutput("ps aux | grep -c /usr/sbin/sshd")) - 2
        
    def sshUsers(self):
        self.sshConnected = int(getoutput("netstat -t | grep -c :ssh[[:space:]]*[0-9].*ESTABLISHED"))
        
    def sshAllUsers(self):
        self.sshConnected = int(getoutput("netstat -t | grep -c :ssh[[:space:]]*[0-9].*ESTABLISHED"))
        sshNetstat = getoutput("netstat -t | grep :ssh.*ESTABLISHED").split("\n")
        if sshNetstat[0] == "":
            sshNetstat = []
        
        countInWLAN = 0
        countOutWLAN = 0
        countAllWLAN = 0
        countInUSB = 0
        countOutUSB = 0
        countAllUSB = 0
        for line in sshNetstat:
            if self.wlanIP in line:
                countAllWLAN += 1
            if self.usbIP in line:
                countAllUSB += 1
            element = " ".join(line.split()).split()[3]
            if self.wlanIP + ":ssh" in element:
                countInWLAN += 1
            if self.usbIP + ":ssh" in element:
                countInUSB += 1
        countOutWLAN = countAllWLAN - countInWLAN
        countOutUSB = countAllUSB - countInUSB
        if self.wlanIP != "None":
            if countInWLAN != self.labelCountInWLAN:
                self.labelCountInWLAN = countInWLAN
                self.labelInWLAN.set_label(str(countInWLAN) + "  WLAN")
            if countOutWLAN != self.labelCountOutWLAN:
                self.labelCountOutWLAN = countOutWLAN
                self.labelOutWLAN.set_label(str(countOutWLAN) + "  WLAN")
        else:
            self.labelCountInWLAN = -1
            self.labelCountOutWLAN = -1
            self.labelInWLAN.set_label("?  WLAN")
            self.labelOutWLAN.set_label("?  WLAN")
        if self.usbIP != "None":
            if countInUSB != self.labelCountInUSB:
                self.labelCountInUSB = countInUSB
                self.labelInUSB.set_label(str(countInUSB) + "  USB")
            if countOutUSB != self.labelCountOutUSB:
                self.labelCountOutUSB = countOutUSB
                self.labelOutUSB.set_label(str(countOutUSB) + "  USB")
        else:
            self.labelCountInUSB = -1
            self.labelCountOutUSB = -1
            self.labelInUSB.set_label("?  USB")
            self.labelOutUSB.set_label("?  USB")
        
        countInOther = self.sshConnected - countInWLAN - countInUSB
        countOutOther = len(sshNetstat) - self.sshConnected - countOutWLAN - countOutUSB
        if countInOther < 0:
            countInOther = 0
        if countOutOther < 0:
            countOutOther = 0
        
        if countInOther != self.labelCountInOther:
            self.labelCountInOther = countInOther
            if countInOther:
                self.labelInOther.set_label(str(countInOther) + "  Other")
            else:
                self.labelInOther.set_label("")
            
        if countOutOther != self.labelCountOutOther:
            self.labelCountOutOther = countOutOther
            if countOutOther:
                self.labelOutOther.set_label(str(countOutOther) + "  Other")
            else:
                self.labelOutOther.set_label("")
            
    def sshTracker(self):
        if self.trackingEnabled:
            # Smart frequency
            self.loopCount += 1
            if self.loopCount > self.loops:
                self.loopCount = 0
            # Tracker
            if not self.loopCount or self.sshJustOff:
                self.sshStatus()
                if not self.showAllDialog:
                    self.sshUsers()
                else:
                    self.sshAllUsers()
                if self.sshRunning and self.sshJustOff:
                    self.sshJustOff = 0
                # Update on external server status change
                if not self.sshRunning and self.on:
                    self.on = False
                    self.button.set_image(self.image_off)
                if self.sshRunning and not self.on:
                    self.on = True
                    self.button.set_image(self.image_on)
                    self.labelConnected = self.sshConnected
                    if self.sshConnected == 1:
                        self.button.set_text("OpenSSH Server ", "1 connection")
                    else:
                        self.button.set_text("OpenSSH Server ", str(self.sshConnected)+" connections")
                    if self.sshConnected and self.showConnected:
                        self.connected = True
                        self.set_status_area_icon(self.icon_plus)
                    else:
                        self.connected = False
                        self.set_status_area_icon(self.icon)
                # Update Status area icon
                if self.showConnected:
                    if self.sshConnected and not self.connected:
                        self.connected = True
                        self.set_status_area_icon(self.icon_plus)
                    if self.sshRunning and not self.sshConnected and self.connected:
                        self.connected = False
                        self.set_status_area_icon(self.icon)
                # Update button
                if self.sshConnected != self.labelConnected:
                    self.labelConnected = self.sshConnected
                    self.waitWhileIdle = False
                    if self.sshConnected == 1:
                        self.button.set_text("OpenSSH Server ", "1 connection")
                        return True
                    elif self.sshConnected > 1 or (not self.sshConnected and self.sshRunning):
                        self.button.set_text("OpenSSH Server ", str(self.sshConnected)+" connections")
                        return True
                # Stop tracking when server is off
                if not self.sshConnected and not self.sshRunning:
                    self.on = False
                    self.labelConnected = 0
                    self.button.set_image(self.image_off)
                    self.set_status_area_icon(None)
                    self.button.set_text("OpenSSH Server ", "Off")
                    if self.stopTracking:
                        if self.sshJustOff < 3:
                            self.sshJustOff += 1
                            return True
                        else:
                            self.sshJustOff = 0
                            self.refresh = False
                            self.waitWhileIdle = False
                            return False
                    else:
                        self.sshJustOff = 0
                        return True
                # Stop server when not connected
                if not self.sshConnected and self.stopWhenIdle:
                    if not self.waitWhileIdle:
                        try:
                            remove("/home/user/.openssh-status-connected")
                        except:
                            pass
                        self.idleStartTime = time.time()
                        self.waitWhileIdle = True
                        return True
                    elif self.loops and path.isfile("/home/user/.openssh-status-connected"):
                        remove("/home/user/.openssh-status-connected")
                        self.idleStartTime = time.time()
                        return True
                    elif time.time() - self.idleStartTime + 5 > self.stopAfterMinutes * 60:
                        system("sudo openssh-status.sh stop_sshd")
                        time.sleep(1)
                        self.sshStatus()
                        if self.sshRunning:
                            self.printDialog("Could NOT stop OpenSSH Server !")
                        else:
                            self.on = False
                            self.waitWhileIdle = False
                            self.labelConnected = 0
                            self.button.set_text("OpenSSH Server ", "Off")
                            self.button.set_image(self.image_off)
                            self.set_status_area_icon(None)
            return True
        else:
            self.connected = False
            self.waitWhileIdle = False
            self.refresh = False
            self.loops = 0
            self.labelConnected = 0
            self.sshJustOff = 0
            return False
        
    def button2Clicked(self, dummy):
        self.get_toplevel().hide()
        
        try:
            wlanIP = getoutput("/sbin/ifconfig wlan0 | grep 'inet addr:'").strip().split()[1].replace('addr:','')
        except:
            wlanIP = "None"
        if wlanIP == "None":
            self.printInfo("No WLAN was detected.\nWifi PM is <b>not</b> kept off for 30 sec.", 7)
        else:
            if  not int(getoutput("netstat -t | grep :ssh.*ESTABLISHED | grep -c " + wlanIP)):
                self.printInfo("Wifi PM is kept off for 30 sec.\nGood time to connect...", 7)
                system("sudo openssh-status.sh wifipmoff_once")
            elif int(getoutput("ps aux | grep -v grep  | grep -c /usr/sbin/osw-power-management")):
                if self.keepWifiPMOff == True and self.toggleWifiPM == False:
                    self.printInfo("Wifi PM is off anyway.\nNo need to keep it off for 30 sec.", 7)
                else:
                    self.printInfo("Wifi PM is kept off for 30 sec.\nGood time to connect...", 7)
                    system("sudo openssh-status.sh wifipmoff_once")
            else:
                self.printInfo("Wifi PM is kept off for 30 sec.\nGood time to connect...", 7)
                system("sudo openssh-status.sh wifipmoff_once")

    def button2Pressed(self, dummy):
        self.get_toplevel().hide()        
        
        self.pmOffList = ["1 second", "2 seconds", "3 seconds"]
        self.pmOnList = ["3 seconds", "4 seconds", "5 seconds"]
                
        dialog = gtk.Dialog("OpenSSH status: Wifi PM", None)
        
        self.buttonKeepWifiPMOff = hildon.CheckButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonKeepWifiPMOff.set_label("Keep Wifi PM off when connected")
    
        self.buttonToggleWifiPM = hildon.CheckButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonToggleWifiPM.set_label("Toggle mode")
        self.buttonToggleWifiPM.set_alignment(0.07, 0.5)
    
        self.buttonWifiPMOffSec = hildon.PickerButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL | hildon.BUTTON_STYLE_NORMAL)
        self.buttonWifiPMOffSec.set_title("Wifi PM off:")
        self.buttonWifiPMOffSec.set_alignment(0.18, 0.5, 0, 0)
        self.buttonWifiPMOffSec.set_selector(self.selectWifiPMOffSec())
        try:
            self.buttonWifiPMOffSec.set_active(self.pmOffList.index(self.wifiPMOffSec))
        except:
            self.buttonWifiPMOffSec.set_active(1)
    
        self.buttonWifiPMOnSec = hildon.PickerButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL | hildon.BUTTON_STYLE_NORMAL)
        self.buttonWifiPMOnSec.set_title("Wifi PM on:")
        self.buttonWifiPMOnSec.set_alignment(0.18, 0.5, 0, 0)
        self.buttonWifiPMOnSec.set_selector(self.selectWifiPMOnSec())
        try:
            self.buttonWifiPMOnSec.set_active(self.pmOnList.index(self.wifiPMOnSec))
        except:
            self.buttonWifiPMOnSec.set_active(1)
    
        if self.keepWifiPMOff:
            self.buttonKeepWifiPMOff.set_active(True)
            self.buttonToggleWifiPM.set_sensitive(True)
            self.buttonWifiPMOffSec.set_sensitive(True)
            self.buttonWifiPMOnSec.set_sensitive(True)
        else:
            self.buttonKeepWifiPMOff.set_active(False)
            self.buttonToggleWifiPM.set_sensitive(False)
            self.buttonWifiPMOffSec.set_sensitive(False)
            self.buttonWifiPMOnSec.set_sensitive(False)
        
        if self.toggleWifiPM:
            self.buttonToggleWifiPM.set_active(True)
        else:
            self.buttonToggleWifiPM.set_active(False)

        self.buttonKeepWifiPMOff.connect("clicked", self.buttonKeepWifiPMOff_clicked)
        self.buttonToggleWifiPM.connect("clicked", self.buttonToggleWifiPM_clicked)
        self.buttonWifiPMOffSec.connect("value-changed", self.buttonWifiPMOffSec_changed)
        self.buttonWifiPMOnSec.connect("value-changed", self.buttonWifiPMOnSec_changed)
        
        dialog.vbox.pack_start(self.buttonKeepWifiPMOff, False, False, 0)
        dialog.vbox.pack_start(self.buttonToggleWifiPM, False, False, 0)
        dialog.vbox.pack_start(self.buttonWifiPMOffSec, False, False, 0)
        dialog.vbox.pack_start(self.buttonWifiPMOnSec, False, False, 0)
        
        time.sleep(0.5)
        dialog.show_all()
        
    def buttonKeepWifiPMOff_clicked(self, dummy):
        self.keepWifiPMOff = not self.keepWifiPMOff
        if self.keepWifiPMOff:
            self.buttonToggleWifiPM.set_sensitive(True)
            self.buttonWifiPMOffSec.set_sensitive(True)
            self.buttonWifiPMOnSec.set_sensitive(True)
            if self.toggleWifiPM:
                self.button2.set_image(self.image_wifi_pm_toggle)
            else:
                self.button2.set_image(self.image_wifi_pm_off)
            if self.configShowWifiHint:
                self.configShowWifiHint = False
                self.parser.set('options', 'configShowWifiHint', str(self.configShowWifiHint))
                self.write_config()
                self.printDialog("Keeping off wifi power management increases power consumption significantly. Try toggle mode in addition.")
            system("sudo openssh-status.sh enable_wifipmoff")
        else:
            self.buttonToggleWifiPM.set_sensitive(False)
            self.buttonWifiPMOffSec.set_sensitive(False)
            self.buttonWifiPMOnSec.set_sensitive(False)
            self.button2.set_image(self.image_wifi_pm_on)
            system("sudo openssh-status.sh disable_wifipmoff")
        self.parser.set('wifipm', 'keepWifiPMOff', str(self.keepWifiPMOff))
        self.write_config()
        system("dbus-send --type=signal / org.maemo.oswoptions.changed2 string:'keepWifiPMOff' string:'dummy'")
        
    def buttonToggleWifiPM_clicked(self, dummy):
        self.toggleWifiPM = not self.toggleWifiPM
        if self.toggleWifiPM:
            self.button2.set_image(self.image_wifi_pm_toggle)
        else:
            self.button2.set_image(self.image_wifi_pm_off)
        self.parser.set('wifipm', 'toggleWifiPM', str(self.toggleWifiPM))
        self.write_config()
        system("sudo openssh-status.sh togglepm_changed")
        system("dbus-send --type=signal / org.maemo.oswoptions.changed2 string:'toggleWifiPM' string:'dummy'")
        
    def selectWifiPMOffSec(self):
        selector = hildon.TouchSelector(text = True)
        for i in self.pmOffList:
            selector.append_text(i)
        return selector
        
    def buttonWifiPMOffSec_changed(self, dummy):
        t = self.buttonWifiPMOffSec.get_value()
        self.wifiPMOffSec = t
        self.parser.set('wifipm', 'wifiPMOffSec', t)
        self.write_config()
        system("sudo openssh-status.sh togglepm_changed")
        system("dbus-send --type=signal / org.maemo.oswoptions.changed2 string:'wifiPMOffSec' string:'"+t+"'")
        
    def selectWifiPMOnSec(self):
        selector = hildon.TouchSelector(text = True)
        for i in self.pmOnList:
            selector.append_text(i)
        return selector
        
    def buttonWifiPMOnSec_changed(self, dummy):
        t = self.buttonWifiPMOnSec.get_value()
        self.wifiPMOnSec = t
        self.parser.set('wifipm', 'wifiPMOnSec', t)
        self.write_config()
        system("sudo openssh-status.sh togglepm_changed")
        system("dbus-send --type=signal / org.maemo.oswoptions.changed2 string:'wifiPMOnSec' string:'"+t+"'")
        
    def write_config(self):
        configFile = open('/home/user/.openssh-status-widget', 'r+')
        self.parser.write(configFile)
        configFile.close()

    def buttonClicked(self, dummy):
        self.get_toplevel().hide()
        self.sshStatus()
        if self.sshRunning and self.on:
            system("sudo openssh-status.sh stop_sshd")
            time.sleep(1)
            self.sshStatus()
            if self.sshRunning:
                self.printDialog("Could NOT stop OpenSSH Server !")
            else:
                self.on = False
                self.button.set_image(self.image_off)
                if self.trackingEnabled:
                    self.sshUsers()
                    self.labelConnected = self.sshConnected
                    if self.sshConnected == 1:
                        self.button.set_text("OpenSSH Server ", "1 connection")
                    elif self.sshConnected > 1:
                        self.button.set_text("OpenSSH Server ", str(self.sshConnected)+" connections")
                    else:
                        self.set_status_area_icon(None)
                        self.button.set_text("OpenSSH Server ", "Off")
                else:
                    self.set_status_area_icon(None)
                    self.button.set_text("OpenSSH Server ", "Off")
                    
        elif self.sshRunning and not self.on:
            self.on = True
            self.button.set_image(self.image_on)
            if self.trackingEnabled:
                self.sshUsers()
                self.labelConnected = self.sshConnected
                if self.sshConnected == 1:
                    self.button.set_text("OpenSSH Server ", "1 connection")
                else:
                    self.button.set_text("OpenSSH Server ", str(self.sshConnected)+" connections")
                if self.sshConnected and showConnected:
                    self.connected = True
                    self.set_status_area_icon(self.icon_plus)
                else:
                    self.connected = False
                    self.set_status_area_icon(self.icon)
                if not self.refresh:
                    self.refresh = True
                    self.loopCount = -1
                    gobject.timeout_add(5000, self.sshTracker)
            else:
                self.set_status_area_icon(self.icon)
                self.button.set_text("OpenSSH Server ", "On")
            self.printDialog("OpenSSH Server already running! Display updated.")
        elif not self.sshRunning and self.on:
            self.on = False
            self.button.set_image(self.image_off)
            if self.trackingEnabled:
                self.sshUsers()
                self.labelConnected = self.sshConnected
                if self.sshConnected:
                    if self.sshConnected == 1:
                        self.button.set_text("OpenSSH Server ", "1 connection")
                    else:
                        self.button.set_text("OpenSSH Server ", str(self.sshConnected)+" connections")
                    if self.showConnected:
                        self.connected = True
                        self.set_status_area_icon(self.icon_plus)
                    else:
                        self.connected = False
                        self.set_status_area_icon(self.icon)
                else:
                    self.button.set_text("OpenSSH Server ", "Off")
                    self.connected = False
                    self.set_status_area_icon(None)
                self.refresh = False
            else:
                self.set_status_area_icon(None)
                self.button.set_text("OpenSSH Server ", "Off")
            self.printDialog("OpenSSH Server already stopped! Display updated.")
        else:
            system("sudo openssh-status.sh start_sshd")
            time.sleep(1)
            self.sshStatus()
            if self.sshRunning:
                self.on = True
                self.button.set_image(self.image_on)
                if self.trackingEnabled:
                    self.sshUsers()
                    if not self.sshConnected:
                        self.labelConnected = 0
                        self.button.set_text("OpenSSH Server ", "0 connections")
                        self.connected = False
                        self.set_status_area_icon(self.icon)
                    if not self.refresh:
                        self.refresh = True
                        self.loopCount = -1
                        gobject.timeout_add(5000, self.sshTracker)
                else:
                    self.set_status_area_icon(self.icon)
                    self.button.set_text("OpenSSH Server ", "On")
            else:
                self.printDialog("Could NOT start OpenSSH Server !")

    def buttonPressed(self, dummy):
        self.button.get_toplevel().hide()
        self.sshStatus()
        self.sshUsers()
        
        if self.confirmDisconnect or not self.trackingEnabled:
            
            self.dialog = gtk.Dialog("OpenSSH status", None)
            self.dialog.connect("destroy", self.dialogClosed)
            vbox2 = gtk.VBox(False,2)
            vbox2.set_border_width(8)
            
            if self.showAllConnections:
                try:
                    self.usbIP = getoutput("/sbin/ifconfig usb0 | grep 'inet addr:'").strip().split()[1].replace('addr:','')
                except:
                    self.usbIP = "None"
                
                labelIn = gtk.Label("Server connections:")
                labelOut = gtk.Label("Client connections:")
                
                self.labelInWLAN = gtk.Label("0  WLAN")
                self.labelInWLAN.set_alignment(1, 0)
                self.labelInUSB = gtk.Label("0  USB")
                self.labelInUSB.set_alignment(1, 0)
                self.labelInOther = gtk.Label("")
                self.labelInOther.set_alignment(1, 0)
                self.labelOutWLAN = gtk.Label("0  WLAN")
                self.labelOutWLAN.set_alignment(1, 0)
                self.labelOutUSB = gtk.Label("0  USB")
                self.labelOutUSB.set_alignment(1, 0)
                self.labelOutOther = gtk.Label("")
                self.labelOutOther.set_alignment(1, 0)
                
                if self.trackingEnabled:
                    self.showAllDialog = True
                
                    labelIn.set_alignment(1, 0)
                    labelOut.set_alignment(1, 0)
                
                    hboxConnections = gtk.HBox(True, 32)
                    vboxLabel1 = gtk.VBox(False, 0)
                    vboxLabel2 = gtk.VBox(False, 0)
                    vboxLabel3 = gtk.VBox(False, 0)
                    vboxLabel4 = gtk.VBox(False, 0)
                    vboxLabel1.pack_start(labelIn, False, False, 0)
                    vboxLabel1.pack_start(labelOut, False, False, 0)
                    vboxLabel2.pack_start(self.labelInWLAN, False, False, 0)
                    vboxLabel2.pack_start(self.labelOutWLAN, False, False, 0)
                    vboxLabel3.pack_start(self.labelInUSB, False, False, 0)
                    vboxLabel3.pack_start(self.labelOutUSB, False, False, 0)
                    vboxLabel4.pack_start(self.labelInOther, False, False, 0)
                    vboxLabel4.pack_start(self.labelOutOther, False, False, 0)
                    spacerLabel = gtk.Label()
                    hboxLabel234 = gtk.HBox(False, 0)
                    hboxLabel234.pack_start(vboxLabel2, False, False, 0)
                    hboxLabel234.pack_start(vboxLabel3, False, False, 32)
                    hboxLabel234.pack_start(vboxLabel4, False, False, 0)
                    hboxLabel234.pack_start(spacerLabel, True, True, 0)
                    hboxConnections.pack_start(vboxLabel1, True, True, 0)
                    hboxConnections.pack_start(hboxLabel234, True, True, 0)
                    spaceLeftLabel = gtk.Label()
                    spaceRightLabel = gtk.Label()
                    hbox123 = gtk.HBox(False, 0)
                    hbox123.pack_start(spaceLeftLabel, False, False, 0)
                    hbox123.pack_start(hboxConnections, True, True, 0)
                    hbox123.pack_start(spaceRightLabel, False, False, 0)
                
                else:
                    labelIn.set_alignment(0, 0)
                    labelOut.set_alignment(0, 0)
                
                    vboxLabel1 = gtk.VBox(False, 0)
                    vboxLabel2 = gtk.VBox(False, 0)
                    vboxLabel3 = gtk.VBox(False, 0)
                    vboxLabel4 = gtk.VBox(False, 0)
                    vboxLabel1.pack_start(labelIn, False, False, 0)
                    vboxLabel1.pack_start(labelOut, False, False, 0)
                    vboxLabel2.pack_start(self.labelInWLAN, False, False, 0)
                    vboxLabel2.pack_start(self.labelOutWLAN, False, False, 0)
                    vboxLabel3.pack_start(self.labelInUSB, False, False, 0)
                    vboxLabel3.pack_start(self.labelOutUSB, False, False, 0)
                    vboxLabel4.pack_start(self.labelInOther, False, False, 0)
                    vboxLabel4.pack_start(self.labelOutOther, False, False, 0)
                    refreshButton = hildon.GtkButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
                    refreshButton.set_label("Refresh")
                    hboxConnections = gtk.HBox(False, 0)
                    hboxConnections.pack_start(vboxLabel1, True, False, 0)
                    hboxConnections.pack_start(vboxLabel2, True, False, 0)
                    hboxConnections.pack_start(vboxLabel3, True, False, 0)
                    hboxConnections.pack_start(vboxLabel4, True, False, 0)
                    hboxConnections.pack_start(refreshButton, True, True, 0)
                    spaceLeftLabel = gtk.Label()
                    spaceRightLabel = gtk.Label()
                    hbox123 = gtk.HBox(False, 0)
                    hbox123.pack_start(spaceLeftLabel, False, False, 6)
                    hbox123.pack_start(hboxConnections, True, True, 0)
                    hbox123.pack_start(spaceRightLabel, False, False, 0)
                    refreshButton.connect("clicked", self.sshCountAll)
                
                vbox2.pack_start(hbox123, False, False, 6)
                
                self.sshCountAll(0)
            
            if not self.showRestartButton:
                buttonDisconnectStop = hildon.Button(gtk.HILDON_SIZE_THUMB_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
                if self.showAllConnections:
                    buttonDisconnectStop.set_label('Server:  Disconnect and stop')
                else:
                    buttonDisconnectStop.set_label('Disconnect and stop server')
            else:
                buttonDisconnectStop = hildon.Button(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_THUMB_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
                buttonDisconnectRestart = hildon.Button(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_THUMB_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
                if self.showAllConnections:
                    buttonDisconnectStop.set_label('            Server:\nDisconnect and stop')
                    buttonDisconnectRestart.set_label('             Server:\nDisconnect and restart')
                else:
                    buttonDisconnectStop.set_label('Disconnect\nStop server')
                    buttonDisconnectRestart.set_label('  Disconnect\nRestart server')
            if not self.trackingEnabled and not self.showAllConnections:
                buttonConnected = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
                buttonConnected.set_label('Server connections')
                vbox2.pack_start(buttonConnected)
                buttonConnected.connect("clicked", self.buttonConnected_clicked)
                if self.sshConnected == 1:
                    self.printInfo("1 connection", 2)
                else:
                    self.printInfo(str(self.sshConnected)+" connections", 2)
            
            hbox = gtk.HBox(False,0)
            hbox.pack_start(buttonDisconnectStop)
            if self.showRestartButton:
                hbox.pack_start(buttonDisconnectRestart)
                buttonDisconnectRestart.connect("clicked", self.buttonDisconnectRestart_clicked)
            buttonDisconnectStop.connect("clicked", self.buttonDisconnectStop_clicked)
            vbox2.pack_start(hbox)
            if self.showSettingsButton:
                buttonSettings = hildon.Button(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
                buttonSettings.set_label('Settings')
                buttonSettings.set_size_request(400,56)
                buttonSettings.connect("clicked", self.buttonSettings_clicked)
                vbox2.pack_start(buttonSettings, True, True, 10)
            self.dialog.vbox.pack_start(vbox2)
            time.sleep(0.5)
            self.dialog.show_all()
        elif self.sshRunning or self.sshConnected:
            self.sshDisconnect()
        else:
            time.sleep(1)
            self.printInfo("OpenSSH Server not running!", 7)
            
    def dialogClosed(self, dummy):
        self.showAllDialog = False
            
    def sshCountAll(self, dummy):
        self.sshUsers()
        sshNetstat = getoutput("netstat -t | grep :ssh.*ESTABLISHED").split("\n")
        if sshNetstat[0] == "":
            sshNetstat = []
        
        countInWLAN = 0
        countOutWLAN = 0
        countAllWLAN = 0
        countInUSB = 0
        countOutUSB = 0
        countAllUSB = 0
        for line in sshNetstat:
            if self.wlanIP in line:
                countAllWLAN += 1
            if self.usbIP in line:
                countAllUSB += 1
            element = " ".join(line.split()).split()[3]
            if self.wlanIP + ":ssh" in element:
                countInWLAN += 1
            if self.usbIP + ":ssh" in element:
                countInUSB += 1
        countOutWLAN = countAllWLAN - countInWLAN
        countOutUSB = countAllUSB - countInUSB
        if self.wlanIP != "None":
            self.labelCountInWLAN = countInWLAN
            self.labelCountOutWLAN = countOutWLAN
            self.labelInWLAN.set_label(str(countInWLAN) + "  WLAN")
            self.labelOutWLAN.set_label(str(countOutWLAN) + "  WLAN")
        else:
            self.labelCountInWLAN = -1
            self.labelCountOutWLAN = -1
            self.labelInWLAN.set_label("?  WLAN")
            self.labelOutWLAN.set_label("?  WLAN")
        if self.usbIP != "None":
                self.labelCountInUSB = countInUSB
                self.labelCountOutUSB = countOutUSB
                self.labelInUSB.set_label(str(countInUSB) + "  USB")
                self.labelOutUSB.set_label(str(countOutUSB) + "  USB")
        else:
            self.labelCountInUSB = -1
            self.labelCountOutUSB = -1
            self.labelInUSB.set_label("?  USB")
            self.labelOutUSB.set_label("?  USB")
        
        countInOther = self.sshConnected - countInWLAN - countInUSB
        countOutOther = len(sshNetstat) - self.sshConnected - countOutWLAN - countOutUSB
        if countInOther < 0:
            countInOther = 0
        if countOutOther < 0:
            countOutOther = 0
        self.labelCountInOther = countInOther
        self.labelCountOutOther = countOutOther
        
        if countInOther:
            self.labelInOther.set_label(str(countInOther) + "  Other")
        else:
            self.labelInOther.set_label("")
            
        if countOutOther:
            self.labelOutOther.set_label(str(countOutOther) + "  Other")
        else:
            self.labelOutOther.set_label("")
    
    def buttonSettings_clicked(self, dummy):
        self.dialog.destroy()
        if int(getoutput("ps aux | grep -v grep | grep -c /usr/bin/openssh-status-config.py")):
            system("wmctrl -a 'OpenSSH Status Widget'")
        else:
            system("run-standalone.sh /usr/bin/openssh-status-config.py &")
   
    def buttonDisconnectStop_clicked(self, dummy):
        self.dialog.destroy()
        self.sshDisconnect()
    
    def buttonDisconnectRestart_clicked(self, dummy):
        self.dialog.destroy()
        self.sshDisconnectRestart()
    
    def buttonConnected_clicked(self, dummy):
        self.sshUsers()
        if self.sshConnected == 1:
            self.printInfo("1 connection", 2)
        else:
            self.printInfo(str(self.sshConnected)+" connections", 2)
    
    def sshDisconnect(self):
        self.sshStatus()
        self.sshUsers()
        if self.sshRunning:
            system("sudo openssh-status.sh kill_sshd")
            time.sleep(1)
            self.sshStatus()
            self.sshUsers()
            if self.sshRunning:
                self.printDialog("Could NOT stop OpenSSH Server !")
            elif self.sshConnected:
                self.printDialog("Could NOT close OpenSSH server connections!")
            else:
                self.on = False
                self.labelConnected = 0
                self.button.set_text("OpenSSH Server ", "Off")
                self.button.set_image(self.image_off)
                self.set_status_area_icon(None)
                system("sudo openssh-status.sh disconnect")
        elif self.sshConnected:
            system("sudo openssh-status.sh kill_sshd")
            time.sleep(1)
            self.sshUsers()
            if self.sshConnected:
                self.printDialog("Could NOT close OpenSSH server connections!")
            else:
                self.on = False
                self.labelConnected = 0
                self.button.set_text("OpenSSH Server ", "Off")
                self.button.set_image(self.image_off)
                self.set_status_area_icon(None)
                system("sudo openssh-status.sh disconnect")
            
    def sshDisconnectRestart(self):
        self.sshStatus()
        self.sshUsers()
        if self.sshRunning:
            system("sudo openssh-status.sh kill_sshd")
            time.sleep(1)
            self.sshStatus()
            self.sshUsers()
            if self.sshRunning:
                self.printDialog("Could NOT restart OpenSSH Server !")
            elif self.sshConnected:
                self.printDialog("Could NOT close OpenSSH server connections!")
            else:
                system("sudo openssh-status.sh start_sshd")
                if self.trackingEnabled:
                    self.labelConnected = 0
                    self.button.set_text("OpenSSH Server ", "0 connections")
                self.set_status_area_icon(self.icon)
                system("sudo openssh-status.sh disconnect")
        elif self.sshConnected:
            system("sudo openssh-status.sh kill_sshd")
            time.sleep(1)
            self.sshUsers()
            if self.sshConnected:
                self.printDialog("Could NOT close OpenSSH server connections!")
            else:
                system("sudo openssh-status.sh start_sshd")
                if self.trackingEnabled:
                    self.labelConnected = 0
                    self.button.set_text("OpenSSH Server ", "0 connections")
                else:
                    self.button.set_text("OpenSSH Server ", "On")
                self.button.set_image(self.image_on)
                self.set_status_area_icon(self.icon)
                self.on = True
                system("sudo openssh-status.sh disconnect")
        else:
            system("sudo openssh-status.sh start_sshd")
            if self.trackingEnabled:
                self.labelConnected = 0
                self.button.set_text("OpenSSH Server ", "0 connections")
            else:
                self.button.set_text("OpenSSH Server ", "On")
            self.button.set_image(self.image_on)
            self.set_status_area_icon(self.icon)
            self.on = True
            
    def printDialog(self, msg):
        system("run-standalone.sh dbus-send \
        --type=method_call --dest=org.freedesktop.Notifications \
        /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog \
        string:\""+msg+"\" uint32:0 string:")

    def printInfo(self, msg, sec):
        banner = hildon.hildon_banner_show_information_with_markup(self.button, "no_icon", msg)
        banner.set_timeout(sec * 1000) 

hd_plugin_type = opensshStatus
