/*
 * handler.h interface for signal handler
 * This file is part of MSA program
 *
 * Copyright (C) 2009 - Alexander A. Lomov
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */
 
  // $id$
  
#ifndef __HANDLER_H__
#define __HANDLER_H__

#include "general.h"

/* Names of tags, attributes and content for xml */
#define SOURCE_TAG_NAME "SourceID"
#define CONTENT_TAG_NAME "Content"
#define SIGNAL_TAG_NAME "Signal"
#define ACTION_TAG_NAME "Action"
#define SIGNAL_ATTR_ID "id"
#define START_TIME_TAG_NAME "StartTime"
#define REPEAT_TIME_TAG_NAME "RepeatTime"
#define TIME_TAG_REPEAT_ATTR "repeat"

void add_target(const xmlDocPtr doc, const xmlChar* target_id, 
                       const gint order_number);

gint handler_initialization();
gint handler_put_data(xmlChar* data);
void handler_shutdown();

#endif /* __HANDLER_H__ */
