/*
 * debug.h - for manipulation of debug for driver.
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Alexander A. Lomov.
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with <program name>; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#ifndef _DEBUG_H
#define	_DEBUG_H

#ifdef	__cplusplus
extern "C" {
#endif
    
    
#define DRIVER_DEBUG_LEVEL 10
#define DRIVER_DEBUG_ON
#ifdef DRIVER_DEBUG_ON
#define DRIVER_DEBUG(level) if (level <= DRIVER_DEBUG_LEVEL) g_debug
#else
#define DRIVER_DEBUG(level) //   
#endif 

#define DRIVER_MESSAGE_LEVEL 10
#define DRIVER_MESSAGE_ON
#ifdef DRIVER_MESSAGE_ON
#define DRIVER_MESSAGE(level) if (level <= DRIVER_MESSAGE_LEVEL) g_message
#else
#define DRIVER_MESSAGE(level) //
#endif 

#define DRIVER_ERROR_LEVEL 10
#define DRIVER_ERROR_ON
#ifdef DRIVER_ERROR_ON
#define DRIVER_ERROR(level) if (level <= DRIVER_ERROR_LEVEL) g_error
#else
#define DRIVER_ERROR(level) //
#endif 



#ifdef	__cplusplus
}
#endif

#endif	/* _DEBUG_H */

