/*
 * db_functions.h - header file for DB functions
 * This file is part of MSA program
 *
 * Copyright (C) 2009 Alexander A. Lomov
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */
  


#ifndef __DB_FUNCTIONS_H__
#define __DB_FUNCTIONS_H__

#include <glib.h>

#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h> 

#include <libxslt/transform.h>
#include <libxslt/xslt.h>
#include <libxslt/xsltInternals.h>
#include <libxslt/xsltutils.h>

#include <stdio.h>
#include <stdlib.h>

#include "db_config_manager.h"




gint db_set_node_id(const gchar* schema_name, const xmlDocPtr doc, 
                    const gchar* node_id_value);

                    

gint update_nodes(const xmlNodePtr old_node, xmlNodePtr new_node);
gint update_node_attributes(const xmlNodePtr old_node, 
                            const xmlNodePtr new_node);
gboolean check_properties_equals(const xmlAttrPtr a, const xmlAttrPtr b);



                              

                                        
xmlDocPtr db_get_table(const gchar* schema_name, const gchar* db_path);
//xmlDocPtr db_get_table(caonst gchar* schema_name);
gint db_save_table(const xmlDocPtr doc, const gchar* schema_name, 
                   const gchar* db_path);

gint db_check_unique(const gchar* table_name, const xmlDocPtr current_doc,
                    const xmlDocPtr new_doc);

gchar* db_generate_id(const gchar* table_name, const xmlDocPtr doc);


xmlDocPtr db_apply_stylesheet(const gchar* schema_name, const xmlDocPtr doc, 
                               const gchar** params);                            

xmlDocPtr db_apply_revers_stylesheet(const gchar* schema_name, const xmlDocPtr doc, 
                                      const gchar** params) ;



xsltStylesheetPtr db_get_stylesheet(const gchar* schema_name, const gboolean is_revers); 



/*
gint db_register_xpath_namespaces(const xmlXPathContextPtr xpath_ctx, 
                                  const xmlChar* ns_list);


xmlXPathObjectPtr db_get_nodeset(const xmlDocPtr doc, const xmlChar* xpath, 
                                 const xmlChar* ns_list);

                   
gint db_get_nodes_count(const xmlDocPtr doc, const xmlChar* xpath, 
                        const xmlChar* ns_list);  


gint check_nodes_for_update(const xmlNodePtr old_node, 
                            const xmlNodePtr new_node);
                                  
gint update_node_text_content(const xmlNodePtr old_node, 
                              const xmlNodePtr new_node);                                  


gint update_nodes(const xmlNodePtr old_node, xmlNodePtr new_node);


gint db_set_node_id(const gchar* schema_name, const xmlDocPtr doc, 
                    const gchar* node_id_value);
*/







  

#endif /* __DB_FUNCTIONS_H__ */



