/*
 * db_msa_logic.c - logic function for MSA db.
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Alexander A. Lomov
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

// FIXME: fix all. rewrite functions
 
#include "db.h"
#include "db_logic.h"
#include "db_functions.h"
#include "db_xml_functions.h"

#define METACONTACTS_SCHEMA_NAME "metacontacts"
#define CONTACTS_SCHEMA_NAME "contacts"
#define METACONTAC_SCHEMA_NAME "messages"

//"//foaf:Person[@rdf:ID='0' and foaf:firstName='XXX' and foaf:surname='FFFF1']"

#define XPATH_METACONTACT_PATH "//foaf:Person[@rdf:ID=\"0\"" 
#define FOAF_NAME "foaf:firstName"
#define FOAF_SURNAME "foaf:surname"

#define XPATH_NAME_SURNAME "//Params/string[@name=\"FirstName\" or @name=\"LastName\"]"

gint create_owner_metacontact(xmlDocPtr doc) {
      
    if (doc == NULL) {
        return FAILURE;
    }
    
    
    xmlXPathObjectPtr result = db_get_nodeset(doc, BAD_CAST XPATH_NAME_SURNAME, NULL);

    xmlChar* first_name = NULL;
    xmlChar* surname = NULL;    
        
	if (result) {
   		xmlNodeSetPtr nodeset = result->nodesetval;
		
//        gint size = (nodeset) ? nodeset->nodeNr - 1 : 0;

		if (nodeset->nodeNr == 2) {
            if (xmlStrcmp(xmlGetProp(nodeset->nodeTab[0], BAD_CAST "name"), BAD_CAST "FirstName") == 0) {
                first_name = xmlNodeGetContent(nodeset->nodeTab[0]);
                surname = xmlNodeGetContent(nodeset->nodeTab[1]);                		
                	
		    } else {
                first_name = xmlNodeGetContent(nodeset->nodeTab[1]);
                surname = xmlNodeGetContent(nodeset->nodeTab[0]);   		    
		    }
		}
   		xmlXPathFreeObject(result);
	} 
    
    xmlChar* ns = BAD_CAST cm_get_namespaces_key(METACONTACTS_SCHEMA_NAME);
    xmlDocPtr metacontacts = get_table_from_list(METACONTACTS_SCHEMA_NAME);    
    
    xmlChar* xpath = BAD_CAST g_strconcat(XPATH_METACONTACT_PATH, " and ", FOAF_NAME, "=\"", first_name, "\" and ", FOAF_SURNAME, "=\"", surname, "\"]", NULL);    

    if (first_name != NULL && surname != NULL) {
        if (db_get_nodes_count(metacontacts, xpath, ns) == 0) {

            db_remove_node_by_id(SCHEMA_NAME_CONTACTS_LIST , "*");
            db_remove_node_by_id(SCHEMA_NAME_CONTACTS , "*");
            db_remove_node_by_id(SCHEMA_NAME_MESSAGES , "*");
            db_remove_node_by_id(SCHEMA_NAME_OWNER_MESSAGES, "*");    


            gchar* db_path = cm_get_db_path_by_name_or_default(NULL);

            xmlDocPtr doc = get_table_from_list(SCHEMA_NAME_CONTACTS_LIST);    
            db_save_table(doc, SCHEMA_NAME_CONTACTS_LIST, db_path);
            
            doc = get_table_from_list(SCHEMA_NAME_CONTACTS);    
            db_save_table(doc, SCHEMA_NAME_CONTACTS, db_path);
            
            doc = get_table_from_list(SCHEMA_NAME_MESSAGES);    
            db_save_table(doc, SCHEMA_NAME_MESSAGES, db_path);
            
            doc = get_table_from_list(SCHEMA_NAME_OWNER_MESSAGES);    
            db_save_table(doc, SCHEMA_NAME_OWNER_MESSAGES, db_path);

            g_free(db_path);

        }
    }
    
    
    g_free(xpath);      
    gchar** params = g_new(gchar*, 3);
                    
    params[0] = g_strdup("ID");
    params[1] = g_strdup("0");
    params[2] = NULL;       
    
    db_remove_node_by_id(METACONTACTS_SCHEMA_NAME , "*");
    
    db_add_data_to_db_with_id(METACONTACTS_SCHEMA_NAME, doc, (const gchar**)params);
    
    g_strfreev(params);
        
    return SUCCESS;
}


gchar* create_metacontact(xmlDocPtr doc) 
{
    return db_add_data_to_db(METACONTACTS_SCHEMA_NAME, doc, NULL);
}


#define LINK_PREFIX "contact"
#define LINK_NAMESPACE "http://www.w3.org/2000/10/swap/pim/contact"
#define DB_XPATH_KNOWNAS_ID_REQ "//foaf:Person/contact:knownAs[@rdf:ID"
#define ID_NAMESPACE "http://www.w3.org/1999/02/22-rdf-syntax-ns#"
#define ID_NAME "ID"
#define ID_PREFIX "rdf"
#define DB_XPATH_PERSON_REQ "//foaf:Person"
#define DB_XPATH_CONTACT_REQ "//sonet:Contact"
#define DB_XPATH_MESSAGE_REQ "//doclist:Document"
#define DB_XPATH_KNOWNAS_REQ "contact:knownAs"
#define RDF_ID "rdf:ID"
#define RDF_ID_ATTR "@rdf:ID"

#define XPATH_OWNER_CONTACTS_IDS DB_XPATH_PERSON_REQ"[@"RDF_ID"='0']/"DB_XPATH_KNOWNAS_REQ"/@"RDF_ID 


static xmlNodePtr create_link_node(const gchar* id_value)
{
    xmlNodePtr node = xmlNewNode(NULL, BAD_CAST "knownAs");
    xmlNsPtr ns = xmlNewNs(node, BAD_CAST LINK_NAMESPACE, BAD_CAST LINK_PREFIX);
    xmlSetNs(node, ns);
    xmlNsPtr id_ns = xmlNewNs(NULL, BAD_CAST ID_NAMESPACE, BAD_CAST ID_PREFIX);        
    xmlNewNsProp(node, id_ns, BAD_CAST ID_NAME, BAD_CAST id_value);
    
    return node;
}

static gchar* build_contacts_xpath(gboolean with_owner) 
{
    gchar* xpath_req = XPATH_OWNER_CONTACTS_IDS;
    GSList* nodes = get_nodes_ids(METACONTACTS_SCHEMA_NAME, xpath_req);

    gchar* xpath_contact = NULL;
    
    if (nodes != NULL && with_owner == FALSE) {
        gchar* filter = create_list_value_filter(RDF_ID_ATTR, nodes, "or");
        gchar** split_filter = g_strsplit_set(filter, "[]", 3);
        
        xpath_contact = g_strconcat(DB_XPATH_PERSON_REQ, "[not(", split_filter[1], ")]", NULL);
        g_strfreev(split_filter);   
        g_free(filter);
    } else {
        xpath_contact = g_strdup(DB_XPATH_PERSON_REQ);
    }
    
    GSList* list_walker = nodes;
    while (list_walker) {
        g_free(list_walker->data);
        list_walker->data = NULL;
        list_walker = g_slist_next(list_walker);
    }
    g_slist_free(nodes);

    return xpath_contact;    
}

GSList* db_get_owner_profile() 
{
    GSList* list = db_get_node_by_id(METACONTACTS_SCHEMA_NAME, "0");
    return list; 
}


GSList* get_messages() 
{

    xmlChar* ns = BAD_CAST cm_get_namespaces_key(SCHEMA_NAME_MESSAGES);
    xmlDocPtr messages_list_table = get_table_from_list(SCHEMA_NAME_MESSAGES);    
    gchar* xpath_req = g_strdup(DB_XPATH_MESSAGE_REQ);//build_contacts_xpath(with_owner);

    xmlXPathObjectPtr result = db_get_nodeset(messages_list_table, BAD_CAST xpath_req, ns);
    
    g_free(ns);
    g_free(xpath_req);

    GSList* doc_list = NULL; 

    if (result != NULL) {
	    xmlNodeSetPtr nodeset = result->nodesetval;
		
        gint size = (nodeset) ? nodeset->nodeNr - 1 : 0;
		gint i;		

        for(i = size; i >= 0; --i) {
		    xmlNodePtr node = xmlCopyNode(nodeset->nodeTab[i], 1);
		    xmlBufferPtr buf = xmlBufferCreate();
		    xmlNodeDump(buf, NULL, node, 0, 1);
	        xmlChar* content = (xmlChar*)xmlBufferContent(buf);
        	        

	        ////g_printf("\n\nNODE Content: %s", content);
	        
	        xmlDocPtr elem = xmlParseDoc(content);
	        
            xmlDocPtr external_format = db_apply_revers_stylesheet(SCHEMA_NAME_MESSAGES, elem, NULL);
	        
   	        ////g_printf("\n\nNODE Afte transform1: ");
   	        load_binary_data_to_doc(SCHEMA_NAME_MESSAGES, external_format);

	        doc_list = g_slist_prepend(doc_list, xmlCopyDoc(external_format,1));
   	        xmlFreeDoc(external_format);
   	        xmlFreeDoc(elem);    
   	        xmlFreeNode(node);
	        //xmlFree(content);
            xmlBufferFree(buf);
                    
        }
        
        xmlXPathFreeObject(result);	         
    }
    return doc_list;
}


GSList* get_owner_messages() 
{

    xmlChar* ns = BAD_CAST cm_get_namespaces_key(SCHEMA_NAME_OWNER_MESSAGES);
    xmlDocPtr messages_list_table = get_table_from_list(SCHEMA_NAME_OWNER_MESSAGES);    
    gchar* xpath_req = g_strdup(DB_XPATH_MESSAGE_REQ);//build_contacts_xpath(with_owner);

    xmlXPathObjectPtr result = db_get_nodeset(messages_list_table, BAD_CAST xpath_req, ns);

    g_free(ns);
    g_free(xpath_req);

    GSList* doc_list = NULL; 

    if (result != NULL) {
	    xmlNodeSetPtr nodeset = result->nodesetval;
		
        gint size = (nodeset) ? nodeset->nodeNr - 1 : 0;
		gint i;		

        for(i = size; i >= 0; --i) {
		    xmlNodePtr node = xmlCopyNode(nodeset->nodeTab[i], 1);
		    xmlBufferPtr buf = xmlBufferCreate();
		    xmlNodeDump(buf, NULL, node, 0, 1);
	        xmlChar* content = (xmlChar*)xmlBufferContent(buf);
	        
	        ////g_printf("\n\nNODE Content: %s", content);
	        
	        xmlDocPtr elem = xmlParseDoc(content);
	        
            xmlDocPtr external_format = db_apply_revers_stylesheet(SCHEMA_NAME_OWNER_MESSAGES, elem, NULL);
	        
   	        ////g_printf("\n\nNODE Afte transform1: ");
   	        load_binary_data_to_doc(SCHEMA_NAME_OWNER_MESSAGES, external_format);
   	        doc_list = g_slist_prepend(doc_list, xmlCopyDoc(external_format,1));  
            xmlFreeDoc(external_format);
   	        xmlFreeDoc(elem);    
   	        xmlFreeNode(node);
	        //xmlFree(content);
            xmlBufferFree(buf);        
        }

        xmlXPathFreeObject(result);	         

    }
    return doc_list;
}



GSList* get_contacts(gboolean with_owner) {

    xmlChar* ns = BAD_CAST cm_get_namespaces_key(SCHEMA_NAME_CONTACTS_LIST);
    xmlDocPtr contacts_list_table = get_table_from_list(SCHEMA_NAME_CONTACTS_LIST);    
    gchar* xpath_req = g_strdup(DB_XPATH_CONTACT_REQ);//build_contacts_xpath(with_owner);

    xmlXPathObjectPtr result = db_get_nodeset(contacts_list_table, BAD_CAST xpath_req, ns);
    
    g_free(ns);
    g_free(xpath_req);

    GSList* doc_list = NULL; 

    if (result != NULL) {
        xmlNodeSetPtr nodeset = result->nodesetval;
		
        gint size = (nodeset) ? nodeset->nodeNr - 1 : 0;
        int i;

        for(i = size; i >= 0; --i) {
                xmlNodePtr node = xmlCopyNode(nodeset->nodeTab[i], 1);
                xmlBufferPtr buf = xmlBufferCreate();
                xmlNodeDump(buf, NULL, node, 0, 1);
	        xmlChar* content = (xmlChar*)xmlBufferContent(buf);
	    
	        ////g_printf("\n\nNODE Content: %s", content);
	        
	        xmlDocPtr elem = xmlParseDoc(content);

                //xmlDocDump(stdout, elem);
                xmlDocPtr external_format = db_apply_revers_stylesheet(SCHEMA_NAME_CONTACTS_LIST, elem, NULL);
                xmlDocDump(stdout, external_format);
                
   	       
   	        load_binary_data_to_doc(SCHEMA_NAME_CONTACTS_LIST, external_format);
   	        doc_list = g_slist_prepend(doc_list, xmlCopyDoc(external_format,1));
   	        xmlFreeDoc(external_format);
   	        xmlFreeDoc(elem); 
   	        xmlFreeNode(node); 
	        //xmlFree(content);
                xmlBufferFree(buf); 
        }
        
        xmlXPathFreeObject(result);	      
    }

    return doc_list;
}

GSList* get_profiles(gboolean with_owner) {

    g_debug("\n get_profiles start! \n");

    xmlChar* ns = BAD_CAST cm_get_namespaces_key(SCHEMA_NAME_CONTACTS);
    xmlDocPtr contacts_list_table = get_table_from_list(SCHEMA_NAME_CONTACTS);    
    gchar* xpath_req = g_strdup(DB_XPATH_PERSON_REQ);//build_contacts_xpath(with_owner);

    xmlXPathObjectPtr result = db_get_nodeset(contacts_list_table, BAD_CAST xpath_req, ns);

    g_free(ns);
    g_free(xpath_req);

    GSList* doc_list = NULL; 

    if (result != NULL) {
	    xmlNodeSetPtr nodeset = result->nodesetval;
		
        gint size = (nodeset) ? nodeset->nodeNr - 1 : 0;
		gint i;		

        for(i = size; i >= 0; --i) {
		    xmlNodePtr node = xmlCopyNode(nodeset->nodeTab[i], 1);
		    xmlBufferPtr buf = xmlBufferCreate();
		    xmlNodeDump(buf, NULL, node, 0, 1);
	        xmlChar* content = (xmlChar*)xmlBufferContent(buf);
	        
	        ////g_printf("\n\nNODE Content: %s", content);
	        
	        xmlDocPtr elem = xmlParseDoc(content);

            xmlDocPtr external_format = db_apply_revers_stylesheet(SCHEMA_NAME_CONTACTS, elem, NULL);
	        
   	        ////g_printf("\n\nNODE Afte transform1: ");
   	        load_binary_data_to_doc(SCHEMA_NAME_CONTACTS, external_format);
   	        doc_list = g_slist_prepend(doc_list, xmlCopyDoc(external_format,1));
   	        xmlFreeDoc(external_format);
   	        xmlFreeDoc(elem);    
   	        xmlFreeNode(node);
	        //xmlFree(content);
            xmlBufferFree(buf);        
        }
        xmlXPathFreeObject(result);	      

    }
    g_debug("\n get_profiles END! \n");
    return doc_list;
}


gint create_or_update_contact(xmlDocPtr contact, gchar* outer_id)
{

    
    db_remove_node_by_id(SCHEMA_NAME_CONTACTS_LIST, g_strconcat("\"", outer_id, "\"", NULL));
    gchar** params = g_new(gchar*, 3);    
    params[0] = g_strdup("ID");
    params[1] = g_strconcat("\"", outer_id, "\"", NULL);
    params[2] = NULL;       

    db_add_data_to_db_with_id(SCHEMA_NAME_CONTACTS_LIST, contact, (const gchar**)params);
    g_strfreev(params);            
    return 0;
}


gint create_or_update_profile(xmlDocPtr contact, gchar* outer_id)
{

    
    db_remove_node_by_id(SCHEMA_NAME_CONTACTS, g_strconcat("\"", outer_id, "\"", NULL));
    gchar** params = g_new(gchar*, 3);    
    params[0] = g_strdup("ID");
    params[1] = g_strconcat("\"", outer_id, "\"", NULL);
    params[2] = NULL;       

    db_add_data_to_db_with_id(SCHEMA_NAME_CONTACTS, contact, (const gchar**)params);
    g_strfreev(params);            
    return 0;
}


gint create_or_update_message(xmlDocPtr message, gchar* outer_id)
{
    db_remove_node_by_id(SCHEMA_NAME_MESSAGES, g_strconcat("\"", outer_id, "\"", NULL));
    gchar** params = g_new(gchar*, 3);    
    params[0] = g_strdup("ID");
    params[1] = g_strconcat("\"", outer_id, "\"", NULL);
    params[2] = NULL;       

    db_add_data_to_db_with_id(SCHEMA_NAME_MESSAGES, message, (const gchar**)params);
    g_strfreev(params);            
    return 0;
}

gint create_or_update_owner_message(xmlDocPtr message, gchar* outer_id)
{
    db_remove_node_by_id(SCHEMA_NAME_OWNER_MESSAGES, g_strconcat("\"", outer_id, "\"", NULL));
    gchar** params = g_new(gchar*, 3);    
    params[0] = g_strdup("ID");
    params[1] = g_strconcat("\"", outer_id, "\"", NULL);
    params[2] = NULL;       

    db_add_data_to_db_with_id(SCHEMA_NAME_OWNER_MESSAGES, message, (const gchar**)params);
    g_strfreev(params);            
    return 0;
}


gint create_or_update_contact1(xmlDocPtr contact, gchar* outer_id)
{


    if (contact == NULL || outer_id == NULL) {
        return FAILURE;
    }   

    gchar* xpath_req = g_strconcat(DB_XPATH_KNOWNAS_ID_REQ, "='", outer_id, "']", NULL );
    xmlDocPtr metacontacts_table = get_table_from_list(METACONTACTS_SCHEMA_NAME);
    xmlChar* ns = BAD_CAST cm_get_namespaces_key(METACONTACTS_SCHEMA_NAME);

    g_debug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! %s", xpath_req);

    if (db_get_nodes_count(metacontacts_table, BAD_CAST xpath_req, ns) == 0) {
        g_debug("CREATE");
        gchar* new_id = db_add_data_to_db(METACONTACTS_SCHEMA_NAME, contact, NULL);
        
        g_free(xpath_req);
        xpath_req = g_strconcat(DB_XPATH_PERSON_REQ, "[@", ID_PREFIX, ":", ID_NAME, "='", new_id, "']", NULL);
        
//        GSList* list = db_get_node_by_id(METACONTACTS_SCHEMA_NAME, new_id);
       
        xmlXPathObjectPtr result = db_get_nodeset(metacontacts_table, BAD_CAST xpath_req, ns);
        
        if (result) {
	        gint count = result->nodesetval->nodeNr;    
   		    if (count > 0) {
   		        xmlNodePtr node = (xmlNodePtr)result->nodesetval->nodeTab[0];
   		        xmlNodePtr new_link = create_link_node(outer_id);
   		        xmlAddChild(node, new_link);

     gchar* db_path = cm_get_db_path_by_name_or_default(NULL);
     db_save_table(metacontacts_table, METACONTACTS_SCHEMA_NAME, db_path);
     g_free(db_path);
            gchar** params = g_new(gchar*, 3);    
            params[0] = g_strdup("ID");
            params[1] = g_strdup(outer_id);
            params[2] = NULL;       
            db_add_data_to_db_with_id(SCHEMA_NAME_CONTACTS_LIST, contact, (const gchar**)params);
            g_strfreev(params);
   		    }
   		    xmlXPathFreeObject(result);
	    } 

    } else {
         db_remove_node_by_id(SCHEMA_NAME_CONTACTS_LIST, outer_id);
        gchar** params = g_new(gchar*, 3);    
            params[0] = g_strdup("ID");
            params[1] = g_strdup(outer_id);
            params[2] = NULL;       
        
            db_add_data_to_db_with_id(SCHEMA_NAME_CONTACTS_LIST, contact, (const gchar**)params);
            g_strfreev(params);            
    }


    
    g_free(xpath_req);
    xmlFree(ns);
    return 0;
}



gint create_or_update_profile1(xmlDocPtr contact, gchar* outer_id)
{
    if (contact == NULL || outer_id == NULL) {
        return FAILURE;
    }   

    gchar* xpath_req = g_strconcat(DB_XPATH_KNOWNAS_ID_REQ, "='", outer_id, "']", NULL );
    xmlDocPtr metacontacts_table = get_table_from_list(METACONTACTS_SCHEMA_NAME);
    xmlChar* ns = BAD_CAST cm_get_namespaces_key(METACONTACTS_SCHEMA_NAME);
 

    if (db_get_nodes_count(metacontacts_table, BAD_CAST xpath_req, ns) == 0) {
        g_debug("CREATE");
        gchar* new_id = db_add_data_to_db(METACONTACTS_SCHEMA_NAME, contact, NULL);
        
        g_free(xpath_req);
        xpath_req = g_strconcat(DB_XPATH_PERSON_REQ, "[@", ID_PREFIX, ":", ID_NAME, "='", new_id, "']", NULL);
      
        xmlXPathObjectPtr result = db_get_nodeset(metacontacts_table, BAD_CAST xpath_req, ns);
        
        if (result) {
	        gint count = result->nodesetval->nodeNr;    
   		    if (count > 0) {
   		        xmlNodePtr node = (xmlNodePtr)result->nodesetval->nodeTab[0];
   		        xmlNodePtr new_link = create_link_node(outer_id);
   		        xmlAddChild(node, new_link);

             gchar* db_path = cm_get_db_path_by_name_or_default(NULL);
             db_save_table(metacontacts_table, METACONTACTS_SCHEMA_NAME, db_path);
            g_free(db_path);
            gchar** params = g_new(gchar*, 3);    
            params[0] = g_strdup("ID");
            params[1] = g_strdup(outer_id);
            params[2] = NULL;       
            db_add_data_to_db_with_id(SCHEMA_NAME_CONTACTS, contact, (const gchar**)params);
            g_strfreev(params);
   		    }
   		    xmlXPathFreeObject(result);
	    } 

    } else {
         db_remove_node_by_id(SCHEMA_NAME_CONTACTS, outer_id);
        gchar** params = g_new(gchar*, 3);    
            params[0] = g_strdup("ID");
            params[1] = g_strdup(outer_id);
            params[2] = NULL;       
        
            db_add_data_to_db_with_id(SCHEMA_NAME_CONTACTS, contact, (const gchar**)params);
            g_strfreev(params);
    }


    
    g_free(xpath_req);
    xmlFree(ns);
    return 0;
}


GSList* db_get_profile(gchar* id)
{
    gchar* tmp_id = g_strconcat("\"", id, "\"", NULL);
    GSList* list = db_get_node_by_id(SCHEMA_NAME_CONTACTS, tmp_id);
    g_free(tmp_id);
    return list;
}


GSList* db_get_message(gchar* id)
{
    gchar* tmp_id = g_strconcat("\"", id, "\"", NULL);
    GSList* list = db_get_node_by_id(SCHEMA_NAME_MESSAGES, tmp_id);
    g_free(tmp_id);
    return list;
}

GSList* db_get_owner_message(gchar* id)
{
    gchar* tmp_id = g_strconcat("\"", id, "\"", NULL);
    GSList* list = db_get_node_by_id(SCHEMA_NAME_OWNER_MESSAGES, tmp_id);
    g_free(tmp_id);
    return list;
}


GSList* db_get_contact(gchar* id)
{
    gchar* tmp_id = g_strconcat("\"", id, "\"", NULL);
    GSList* list = db_get_node_by_id(SCHEMA_NAME_CONTACTS_LIST, tmp_id);
    g_free(tmp_id);
    return list;
}


GSList* db_get_owner_metacontact(gchar* id)
{
    return db_get_node_by_id(METACONTACTS_SCHEMA_NAME, id);
}

GSList* db_get_owner_contacts(gchar* id)
{
    return db_get_node_by_id(METACONTACTS_SCHEMA_NAME, id);
}

gchar* get_binary_data_content(const gchar* binary_id) 
{
    return db_get_binary_data_content(binary_id);
}

gboolean set_binary_data_content(const gchar* binary_id, const gchar* content)
{
    return db_set_binary_data_content(binary_id, content);
}

