#define CTF_LOG_FORMAT_USE_TIME
#define CTF_THROW_EXIT

#include "../CTF/src/ctf.h"
#include "../../src/kernel/general.h"
#include "../../src/msa_module.h"
#include "../../src/kernel/dispatcher.h"
#include <gconf/gconf-client.h>
#include <glib.h>

int my_test_send(xmlDocPtr request, xmlDocPtr* response, msa_driver_info* info);
xmlDocPtr global_request;
xmlDocPtr global_response;

GLOBAL_DECL();

CTF_TEST_DATA_FILE_NAME_DECL;
CTF_STAT_FILE_NAME_DECL;

CTF_TEST_CASE(test_msa_disp_init) {

    CTF_TEST_NAME("test_msa_disp_init");
    int retval;

    retval = test_init(my_test_send);

    if (retval == SUCCESS) {
        g_debug("msa_disp_init ok %d", msa_disp_status);
        CTF_CHECK(msa_disp_status == DISP_ON);
    } else {
        CTF_CHECK(msa_disp_status == DISP_OFF);
    }

}


CTF_TEST_CASE(test_msa_driver_connect_correct) {

    CTF_TEST_NAME("test_msa_driver_connect_correct");

    msa_module_disp* mod;

    /** create module for testing **/
    mod = test_msa_disp_module_new();

    /** set correct date (if all module install) **/
    mod->msa_mod->id = g_strdup_printf("vkontakte");
    mod->msa_mod->type = DRIVER;

    int retval;
    retval = test_msa_disp_driver_connect(mod);
    
    if (retval == SUCCESS) 
    {    
        CTF_CHECK(mod->msa_mod->status != BROKEN);
        CTF_CHECK(strcmp(mod->msa_mod->id, "vkontakte") == 0);
        CTF_CHECK(mod->msa_mod->pic != NULL);
        CTF_CHECK(mod->msa_mod->name != NULL);
        CTF_CHECK(mod->msa_mod->send != NULL);
        CTF_CHECK(mod->msa_mod->shutdown != NULL);
        CTF_CHECK(mod->msa_mod->set_events != NULL);
    }    
}

CTF_TEST_CASE(test_msa_driver_connect_failed) {

    CTF_TEST_NAME("test_msa_driver_connect_filed");

    msa_module_disp* mod;

    /** create module for testing **/
    mod = test_msa_disp_module_new();

    /** set correct date (if all module install) **/
    mod->msa_mod->id = g_strdup_printf("polnoayfigny");
    mod->msa_mod->type = DRIVER;

    int retval;
    retval = test_msa_disp_driver_connect(mod);
    
    if (retval == FAILURE) {    
        CTF_CHECK(mod->msa_mod->status == BROKEN);
    }    

}

CTF_TEST_CASE(test_msa_disp_send_success) {

    CTF_TEST_NAME("test_msa_disp_send_success_send");
    xmlDocPtr doc;
    doc = xmlParseDoc(CTF_TEST_DATA("DISP_REQUEST_CORRECT"));
    xmlDocDump(stdout, doc);

    int retval = 0;
    retval = msa_disp_send_request(TEST_ID, doc);
    CTF_CHECK(retval == SUCCESS);
    
    if (retval == SUCCESS) {        
        sleep(1);
    } 
}

CTF_TEST_CASE(test_msa_disp_get_success){
    
    CTF_TEST_NAME("test_msa_disp_get_success_get");
    CTF_CHECK(global_request != NULL);

}

int my_test_send(xmlDocPtr request, xmlDocPtr* response, msa_driver_info* info)
{
    global_request = request;
    CTF_TEST_CASE(test_msa_disp_get_success); 
}

CTF_TEST_CASE(test_msa_disp_send_failed_target_id) {

    CTF_TEST_NAME("test_msa_disp_send_failed_target_id");
    xmlDocPtr doc;
    doc = xmlParseDoc(CTF_TEST_DATA("DISP_REQUEST_FAILED"));

    int retval = 0;
    retval = msa_disp_send_request("test_id1", doc);
    CTF_CHECK(retval == FAILURE);
}


