#include "client.h"

const char* connectionName = "org.lomalan.AuthManager";
const char* serviceName = "org.lomalan.AuthManager";
const char* objectName = "/AuthManager";

using namespace std;

Client::Client() : authInterface(serviceName, QString("/AuthManager"), connectionName)
{
    QDBusConnection::sessionBus().connect(QString(), QString(), connectionName, QString("message"),
                                           (QObject*)this, SLOT(messageSlot(QString)));
}

Client::~Client()
{
}

void Client::messageSlot(const QString &result)
{
    cout << "\nMessage received: ";
    cout << result.toAscii().constData() << endl;
    exit(0);
}



void Client::sendAuth(const QString &url)
{
    QDBusReply<QString> repl = authInterface.call("Auth", url);

    if (repl.isValid() == true) {
        cout << "\nAuth data send...\n";
    } else {
        cout << "\nCan't send auth data...(" << repl.error().message().toAscii().constData() << ")\n";
    }
}
