<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
    xmlns:bio="http://purl.org/vocab/bio/0.1/"
    xmlns:foaf="http://xmlns.com/foaf/0.1/"
    xmlns:sonet="http://cs.karelia.ru/social_network/"
    xmlns:contact="http://www.w3.org/2000/10/swap/pim/contact"
    xmlns:ad="http://schemas.talis.com/2005/address/schema#"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
	
	exclude-result-prefixe="rdf sonet foaf bio xsl contact ad dc"
    extension-element-prefixes="rdf sonet foaf bio xsl contact ad dc" 
           
    version="1.0">

    <xsl:output  method="xml" indent="yes"   encoding="UTF-8"/>

	<xsl:template match="foaf:Person">

		<Params>

			<xsl:attribute name="id">
				<xsl:value-of select="@rdf:ID" />
			</xsl:attribute>

			<string> 
				<xsl:attribute name="name">
					<xsl:text>FirstName</xsl:text>
				</xsl:attribute>
				<xsl:value-of select="foaf:firstName" />
			</string>
		
			<string> 
				<xsl:attribute name="name">
					<xsl:text>LastName</xsl:text>
				</xsl:attribute>
				<xsl:value-of select="foaf:surname" />
			</string>

			<img> 
				<xsl:attribute name="name">
					<xsl:text>Img</xsl:text>
				</xsl:attribute>
				
				<xsl:attribute name="uri">
					<xsl:value-of select="sonet:img/@sonet:BinaryID"/>
				</xsl:attribute>	
			
				<xsl:value-of select="sonet:img"/>
			</img>		

			<struct>

				<xsl:attribute name="name">
					<xsl:text>City</xsl:text>
				</xsl:attribute>

				<string>
					<xsl:attribute name="name">
						<xsl:text>CityId</xsl:text>
					</xsl:attribute>							
					<xsl:value-of select="sonet:City/sonet:CityId"/>
				</string>
							
				<string>
					<xsl:attribute name="name">
						<xsl:text>CityName</xsl:text>
					</xsl:attribute>							
					<xsl:value-of select="sonet:City/sonet:CityName"/>
				</string>			

			</struct>



			<struct>

				<xsl:attribute name="name">
					<xsl:text>Country</xsl:text>
				</xsl:attribute>

				<string>
					<xsl:attribute name="name">
						<xsl:text>CountryId</xsl:text>
					</xsl:attribute>							
					<xsl:value-of select="sonet:Country/sonet:CountryId"/>
				</string>
							
				<string>
					<xsl:attribute name="name">
						<xsl:text>CountryName</xsl:text>
					</xsl:attribute>							
					<xsl:value-of select="sonet:Country/sonet:CountryName"/>
				</string>			

			</struct>

			<date> 
				<xsl:attribute name="name">
					<xsl:text>Birthday</xsl:text>
				</xsl:attribute>
				
				<xsl:value-of select="bio:date"/>
			</date>		

			<select>
				<xsl:attribute name="name">
					<xsl:text>Gender</xsl:text>
				</xsl:attribute>
				
				<xsl:for-each select="sonet:genderSelect/sonet:string">					
			
					<string>
						<xsl:attribute name="selected">
							<xsl:value-of select="./@selected"/>
						</xsl:attribute>
						<xsl:value-of select="."/>
					</string>
				
				</xsl:for-each>
			</select>
		
			<select>
				<xsl:attribute name="name">
					<xsl:text>FamilyState</xsl:text>
				</xsl:attribute>
				
				<xsl:for-each select="sonet:familyStateSelect/sonet:string">					
			
					<string>
						<xsl:attribute name="selected">
							<xsl:value-of select="./@selected"/>
						</xsl:attribute>
						<xsl:value-of select="."/>
					</string>
				
				</xsl:for-each>
			</select>

			<select>
				<xsl:attribute name="name">
					<xsl:text>PoliticalView</xsl:text>
				</xsl:attribute>
				
				<xsl:for-each select="sonet:politicalViewSelect/sonet:string">					
			
					<string>
						<xsl:attribute name="selected">
							<xsl:value-of select="./@selected"/>
						</xsl:attribute>
						<xsl:value-of select="."/>
					</string>
				
				</xsl:for-each>
			</select>

			<array>
				<xsl:attribute name="name">
					<xsl:text>EducationList</xsl:text>
				</xsl:attribute>
					
				<xsl:for-each select="sonet:educationList/sonet:Education">					
			
					<struct>
						<xsl:attribute name="name">
							<xsl:text>Education</xsl:text>
						</xsl:attribute>
						
						<string>
							<xsl:attribute name="name">
								<xsl:text>Type</xsl:text>
							</xsl:attribute>
							<xsl:value-of select="./sonet:educationType"/>
						</string>
						
						<string>
							<xsl:attribute name="name">
								<xsl:text>Name</xsl:text>
							</xsl:attribute>
							<xsl:value-of select="./sonet:educationName"/>
						</string>
			
						<string>
							<xsl:attribute name="name">
								<xsl:text>DateComplete</xsl:text>
							</xsl:attribute>
							<xsl:value-of select="./sonet:educationDateComplete"/>
						</string>					
					</struct>
				
				</xsl:for-each>

			</array>

		</Params>

	</xsl:template>

</xsl:stylesheet>

