<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
        xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
        xmlns:sonet="http://cs.karelia.ru/social_network/"  
        xmlns:foaf="http://xmlns.com/foaf/0.1/"
        exclude-result-prefixe="rdf sonet foaf"
        extension-element-prefixes="rdf sonet foaf" 
       
    version="1.0">

    <xsl:output  method="xml" indent="yes"   encoding="UTF-8"/>


    <xsl:template match="foaf:Group"
      
        >
      
        <content     xsl:exclude-result-prefixes="rdf">
            <Group>
                <xsl:attribute name="ID">
                    <xsl:if test="@rdf:nodeID > 0">
                        <xsl:value-of select="@rdf:nodeID" />
                    </xsl:if>
                    <xsl:if test="not(@rdf:nodeID > 0)">
                        <xsl:text></xsl:text>
                    </xsl:if>
                </xsl:attribute>
             
                
                <name>
                    <xsl:value-of select="foaf:name" />
                </name>
    
         <rating>
            <xsl:if test="sonet:rating >= 0">
            <xsl:value-of select="sonet:rating" />
            </xsl:if>
             <xsl:if test="not(sonet:rating >= 0)">
            <xsl:text>0</xsl:text>
         </xsl:if>
       </rating>
                
    <color>
         <xsl:value-of select="sonet:color" />
    </color>
               

        	</Group>
	</content>

  </xsl:template>


 
   
    
    
  
</xsl:stylesheet>
