<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
    xmlns:bio="http://purl.org/vocab/bio/0.1/"
    xmlns:foaf="http://xmlns.com/foaf/0.1/"
	xmlns:doclist="http://www.junkwork.net/xml/DocumentList#"
    xmlns:sonet="http://cs.karelia.ru/social_network/"
    xmlns:contact="http://www.w3.org/2000/10/swap/pim/contact"
    xmlns:ad="http://schemas.talis.com/2005/address/schema#"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
           
    version="1.0">

	<xsl:param name="ID"></xsl:param>

	
<!--	exclude-result-prefixe="rdf sonet foaf bio xsl contact ad dc"
    extension-element-prefixes="rdf sonet foaf bio xsl contact ad dc" 
-->


    <xsl:output  method="xml" indent="yes"   encoding="UTF-8"/>

	<xsl:template match="struct">

		 <rdf:RDF
			xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
			xmlns:rel="http://purl.org/vocab/relationship/"
			xmlns:foaf="http://xmlns.com/foaf/0.1/">

			<doclist:Document>
			
				<xsl:attribute name="rdf:ID">
					<xsl:value-of select="$ID" />
				</xsl:attribute>
				
				<dc:creator>
					<xsl:attribute name="rdf:ID">
						<xsl:value-of select="string[@name='SenderId']" />
					</xsl:attribute>			
					<xsl:value-of select="string[@name='SenderName']"/>			
				</dc:creator>

				<sonet:recipient>
					<xsl:attribute name="rdf:ID">
						<xsl:value-of select="string[@name='RecipientId']" />
					</xsl:attribute>			
					<xsl:value-of select="string[@name='RecipientName']"/>			
				</sonet:recipient>

				<sonet:status>
					<xsl:value-of select="string[@name='Status']"/>			
				</sonet:status>

				<dc:date>
					<xsl:value-of select="string[@name='Time']"/>			
				</dc:date>
				
				<dc:text>
					<xsl:value-of select="string[@name='Text']"/>			
				</dc:text>

			</doclist:Document>

		</rdf:RDF>
		

	</xsl:template>

	
</xsl:stylesheet>
