/*
 * db_xfunctions.h - heder file for xml data functions.
 * This file is part of Maemo-DB project
 *
 * Copyright (C) 2009 - Alexander A. Lomov
 *
 * Maemo-DB project is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Maemo-DB project is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Maemo-DB project; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */
 
  
#ifndef __DB_XML_FUNCTIONS_H__
#define __DB_XML_FUNCTIONS_H__
 
#include <glib.h>

#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h> 

#include <libxslt/transform.h>
#include <libxslt/xslt.h>
#include <libxslt/xsltInternals.h>
#include <libxslt/xsltutils.h>

#include <stdio.h>
#include <stdlib.h>

#include "db.h"

//#include "db_config_manager.h"


/* functions for work with xml tree and nodes */                         
xmlNodePtr db_find_sibling_node_by_name(const xmlNodePtr start_node, 
                                        const xmlChar* search_name, 
                                        const xmlNsPtr ns);                                     
gint db_add_doc_to_tree(const xmlDocPtr tree, const xmlDocPtr data, 
                        const xsltStylesheetPtr stylesheet, const char** params);                                                              
                                        
                                 
/* functions for work with xpath requests */                           
gint db_register_xpath_namespaces(xmlXPathContextPtr xpathCtx, const xmlChar* nsList);
xmlXPathObjectPtr db_get_nodeset(const xmlDocPtr doc, const xmlChar* xpath, 
                                 const xmlChar* ns_list);
gint db_get_nodes_count(const xmlDocPtr doc, const xmlChar* xpath, const xmlChar* ns);
void db_remove_node_by_xpath(const xmlDocPtr doc, const gchar* xpath_query, const gchar* ns);



/* functions for check something */                                  
gint db_check_nodes_for_update(const xmlNodePtr old_node, const xmlNodePtr new_node);
gboolean db_check_nodes_equals(const xmlNodePtr a, const xmlNodePtr b, 
                            const gboolean check_ns, const gboolean check_ns_prefix);                            
gboolean db_check_ns_equals(const xmlNsPtr a, const xmlNsPtr b, const gboolean check_prefix);


/* update and set functions */                            
gint db_update_node_text_content(const xmlNodePtr old_node, const xmlNodePtr new_node);                            
gint db_update_node_attributes(const xmlNodePtr old_node, const xmlNodePtr new_node);
gint db_update_node(const xmlNodePtr old_node, xmlNodePtr new_node);       
xmlAttrPtr db_set_node_property(const xmlNodePtr node, const gchar* name, 
                                const gchar* value, const gchar* ns_href,
                                const gchar* ns_prefix);                   


#endif /* __DB_XML_FUNCTIONS_H__ */
 
