/*
 * driver.c -  driver vkontakte of MSA program
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Sergey Zakharov
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#include "driver.h"
#include "vkontakte.h"
#define XSL_URL DATADIR"/msa/drivers/vkontakte/make_url.xsl"

#ifdef TEST
#include "../../../test/CTF/src/ctf.h"
CTF_TEST_DATA_FILE_NAME_DECL;
#endif

int counter = 0;
static int global_temp = 0;

int init_event_manager(int time)
{
#ifdef TEST
    g_debug("TEST = %d",TEST );
#endif
g_debug("init_event_maneger start");
/** request **/
char* event_message = "\
<TransitData id=\"0\" type=\"data\">\
<SourceID>db</SourceID>\
<TargetID>vkontakte</TargetID>\
<Content>\
<Request class=\"messages\" function = \"getNewInboxMessages\">\
<Params/>\
</Request>\
</Content>\
</TransitData>";

    char* action;
    if (time == 0) {
        action = g_strdup("remove");
    } else
        action = g_strdup("set");
    char* str_time = g_strdup_printf("%d",time);

    char* event_struct = g_strconcat("\
<TransitData type=\"signal\">\
<SourceID>"KERNEL_ID"</SourceID>\
<TargetID>", HANDLER_ID, "</TargetID>\
<Content>\
<Signal id=\"event_message_vk\">\
<StartTime>",str_time,"</StartTime>\
<Action>",action,"</Action>\
<RepeatTime>",str_time,"</RepeatTime>\
<Content/>\
</Signal>\
</Content>\
</TransitData>", NULL);
    free(action);
    free(str_time);
    GList* list;
    msa_driver_info* info;

    xmlNodePtr node;
    xmlNodePtr node_root;
    xmlDocPtr doc;
    xmlDocPtr doc_root;

    xmlChar* doc_char;
    int size;
    doc = xmlParseDoc(event_message);

    doc_root = xmlParseDoc(event_struct);
    node = xmlDocGetRootElement(doc);

    xmlXPathObject* Obj = xpath("//TransitData/Content/Signal/Content", doc_root);
    node_root = Obj->nodesetval->nodeTab[0];

    xmlAddChild(node_root, node);
    xmlDocDump(stdout, doc_root);

    
    xmlDocDumpMemory(doc_root, &doc_char, &size);
    g_debug("set_event");

    set_events(doc_char);

    return 0;
}


/**
 * Allocate memory
 *
 * @param ptr - pointer
 * @param size - size of data
* @return 0 on success or 1 otherwise.
 */
static void* myrealloc(void* ptr, size_t size)
{
/* There might be a realloc() out there that doesn't like reallocing
NULL pointers, so we take care of it here */
    if(ptr)
        return realloc(ptr, size);
    else
        return malloc(size);
}

/**
 * Callbak for libcurl for receiving data
 *
 * @param ptr - pointer
 * @param size - size of chunk of data
 * @param nmemb - number of chunks of data
 * @param data - pointer to data
* @return 0 on success or 1 otherwise.
 */
 static size_t
WriteMemoryCallback(void* ptr, size_t size, size_t nmemb, void* data)
{
    size_t realsize = size * nmemb;
    struct MemoryStruct *mem = (struct MemoryStruct *)data;
    mem->memory = myrealloc(mem->memory, mem->size + realsize + 1);
    if (mem->memory) {
        memcpy(&(mem->memory[mem->size]), ptr, realsize);
        mem->size += realsize;
        mem->memory[mem->size] = 0;
    }
    return realsize;
}

/**
 * Get captcha image from server
 *
 * @param captcha_sid - random number for generating captcha
 * @return image.
 */

static char* get_captcha(guint32 captcha_sid)
{
    g_debug("get_captcha START");
    char* url;
    char* img;

    url = g_strdup_printf("http://userapi.com/data?act=captcha&csid=%d", captcha_sid);

    if (http_get(url, info_proxy, info_port, NULL, &img) == 200)
        return img;

    g_debug("get_captcha END");
    return NULL;
}

/**
 * Perform request
 *
 * @param reqXml - request
 * @param doc - response
 * @return 0 on success or 1 otherwise.
 */
int vk_req(xmlDocPtr reqXml, xmlDocPtr doc, msa_driver_info* info)
{
    int i, len;
    int captch = 0;
    int init_status = 0;
    char* url;
    char* remixmid;
    char* remixsid;
    char* class;
    char* function;
    char* tmp;
    xmlXPathObject *Obj;

    global_temp++;
    
    g_print("IN VK_REQ!!! %d",global_temp);
    counter = 0;
    xmlDocDump(stdout, reqXml);

//Prepare response
    xmlNodePtr rootNode, node, childNode;
    xmlDocPtr reqXml2;
    rootNode = xmlNewDocNode(doc, NULL,  "Response", NULL);
    xmlDocSetRootElement(doc, rootNode);

    class = get_req_class(reqXml);
    function = get_req_function(reqXml);
    xmlSetProp(rootNode, CLASS, class);
    xmlSetProp(rootNode, FUNCTION, function);
    
    node = xmlNewDocNode(doc, NULL,   PARAMS,  NULL);
    childNode = xmlAddChild(rootNode, node);
 
//Convert message text to url encode
    xmlNodePtr node2;
    if (strcmp(function, GET_SETTINGS) == 0) {
        get_settings(doc);
       return 0;
    }
    if(strcmp(function, SET_SETTINGS) == 0) {
        if (set_settings(reqXml, doc, info)) {
            info_message("404", doc, DRV_SETT_ERROR, 1);
        } else {
            info_message("410", doc, DRV_SETT_SAVED, 0);
        }
       return 0;
    }
    if (strcmp(function, CAPTCHA_MESSAGE) == 0) {
        captch = 1;

        char* captcha_code;
        Obj = xpath("//Request/Params/string[@name='text']", reqXml);
        node = Obj->nodesetval->nodeTab[0];
        captcha_code = xmlNodeGetContent(node);
        g_debug("captcha code %s", captcha_code);

        Obj = xpath("//Request/Params/string[@name='oldRequest']/Request/Params/string[@name='fccode']", reqXml);
        node = Obj->nodesetval->nodeTab[0];
        xmlNodeSetContent(node, captcha_code);

        Obj = xpath("//Request/Params/string[@name='oldRequest']/Request", reqXml);
g_debug("GET OBJ");
	if(Obj != NULL) {
		g_debug("OBG != NULL");
            node = Obj->nodesetval->nodeTab[0];
	    g_debug("GET NODE");
            childNode = xmlCopyNode(node,1);
	    g_debug("SET");
            reqXml2 = xmlNewDoc("1.0");
            xmlDocSetRootElement(reqXml2, childNode);
	    g_debug("SET");
        } else {
            return 1;
        }
    }

    if(captch) {
	    class = get_req_class(reqXml2);
    	function = get_req_function(reqXml2);
	} 
	
    xmlSetProp(rootNode, CLASS, class);
    xmlSetProp(rootNode, FUNCTION, function);

    init_status = initialization(&remixmid, &remixsid);

    if (init_status != 0) {
        if(init_status == -2) {
            //info_message("402", doc, DRV_AUTH_ERROR, 1);
                if(captch)
                    captcha_message(doc, reqXml2);
                else
                    captcha_message(doc, reqXml);
                return 0;
        } else
            info_message("403", doc, DRV_NETW_ERROR, 1);
    }

    if(captch)
        make_request( reqXml2, doc, remixmid, remixsid);
    else
        make_request( reqXml, doc, remixmid, remixsid);
    return 0;
}

/**
 * Perform request
 *
 * @param reqXml - request
 * @param doc - response
 * @param remixmid - authorization parameter
 * @param remixsid - authorization parameter
* @return 0 on success or 1 otherwise.
 */
int make_request(xmlDocPtr reqXml, xmlDocPtr doc, char* remixmid, char* remixsid)
{
    char* tmp;
    char* url;
    char* class = get_req_class(reqXml);
    char* function = get_req_function(reqXml);
    int num = 0;

    url = make_url(reqXml, remixmid, remixsid);

    xmlNodePtr rootNode;

    if (url == NULL || strlen(url)  < 1 ) {
        if (strcmp(function, GET_BINARY_DATA) == 0 ) {
            counter = -1;
            return 0;
        } else {
            info_message("402", doc, DRV_REQ_ERROR, 1);
            return 0;
        }
    }
    if (http_get(url, info_proxy, info_port, NULL, &tmp) == 200) {
        if (strcmp(function, GET_BINARY_DATA) == 0 ) {
            if (counter == -1) {
                return 0;
            }
            parser_image(doc, tmp, url);
            counter++;
            make_request( reqXml, doc, remixmid, remixsid);
            return 0;
        }
         
        switch (check(tmp)) {
            case 0:
                if (strcmp(function, SEND_MESSAGE) == 0) {
                    info_message("405", doc, DRV_MESS_ERROR, 1);
		    g_free(tmp);
                    return 0;
                }
                g_debug("check OK");
            case 1:

                if (strcmp(function, GET_MY_PROFILE) == 0 || strcmp(function, UPDATE_PROFILE) == 0) {
                    if(parser_profile(doc, tmp, remixmid) == 1){
                        info_message("403", doc, DRV_RESP_ERROR, 1);
                    }
                    g_free(tmp);      	    
                }
                if (strcmp(function, SEND_MY_PROFILE) == 0) {
                    info_message("400", doc, DRV_PROF_SAVED, 0);
                    g_free(tmp);
                    return 0;
                }
                if (strcmp(function, GET_LIST_FRIENDS) == 0) {
                    tmp = g_convert(tmp, -1, UTF8, CP1251, NULL, NULL, NULL);
                    num = parser_friends(tmp, doc);
                    g_free(tmp);
                    if (num == PAGE_SIZE) {
                        counter++;
                        make_request( reqXml, doc, remixmid, remixsid);
                    } else {
                        return 0;
                    }
                }
                if (strcmp(function, UPDATE_INBOX_MESSAGES) == 0 || strcmp(function, UPDATE_OUTBOX_MESSAGES) == 0) {
                    num = parser_messages(tmp, doc);
                    g_free(tmp);
                    if (num == PAGE_SIZE && counter < MAX_COUNTER) {
                        counter++;
                        make_request( reqXml, doc, remixmid, remixsid);
                    } else {
                        return 0;
                    }
                }
                if (strcmp(function, GET_NEW_MESSAGES) == 0) {
                    g_debug("GET_NEW_MESSAGES");
                    num = parser_new_messages(tmp);
                    g_free(tmp);
                    g_debug("num = %d",num);
                    if (num > 0) {
                        url = g_strdup_printf("http://userapi.com/data?act=inbox&from=0&to=%d&id=%s&sid=%s",num,remixmid,remixsid);
                        if(http_get(url, info_proxy, info_port, NULL, &tmp) == 200){
                            num = parser_messages(tmp, doc);
                            g_free(tmp);
			    read_message(doc, remixmid, remixsid);
                        } else {
                            info_message("403", doc, DRV_NETW_ERROR, 1);
                        }

                    }
                }

                if (strcmp(function, SEND_MESSAGE) == 0) {
                    info_message("400", doc, DRV_MESS_SEND, 0);
                    g_free(tmp);
                    return 0;
                }
                break;
            case -1:
                info_message("401", doc, DRV_AUTH_ERROR, 1);
                g_free(tmp);
		break;
            case -2:
                captcha_message(doc, reqXml);
                g_free(tmp);
		break;
            case -3:
                g_debug(tmp);
                info_message("403", doc, DRV_RESP_ERROR, 1);
                g_free(tmp);
		break;
        }

    } else {
        info_message("403", doc, DRV_NETW_ERROR, 1);
        return 0;
    }
    return 0;
}

/**
 * Perform authorization
 *
 * @param remixmid - authorization parameter
 * @param remixsid - authorization parameter
* @return 0 on success or 1 otherwise.
 */
int initialization(char** remixmid, char** remixsid)
{
    g_debug("init START");

    char* email;
    char* pass;
    int auth_status = 0;
    gchar* path;
    GConfClient* client;
    client = gconf_client_get_default ();
#ifndef TEST
    path = g_strconcat(PATH, LOGIN, NULL);
    email = gconf_client_get_string (client, path, NULL);
    g_free(path);

    path = g_strconcat(PATH, PASSWORD, NULL);
    pass = gconf_client_get_string (client, path, NULL);
    g_free(path);
    
    path = g_strconcat(PATH, REMIXMID, NULL);
    *remixmid = gconf_client_get_string (client, path, NULL);
    g_free(path);
    
    path = g_strconcat(PATH, REMIXSID, NULL);
    *remixsid = gconf_client_get_string (client, path, NULL);
    g_free(path);
#else
    email = CTF_TEST_DATA("LOGIN");
    pass = CTF_TEST_DATA("PASSWORD");
#endif

    if(*remixmid == NULL || *remixsid == NULL ) {
        g_print("dr_vk: authorization\n");
        auth_status = authorize(email, pass);
        if (auth_status != 0 ) {
            g_debug("dr_vk: Could not get remixmid, remixsid\n"); 
            if (auth_status == -2 ) {
                return -2;
            }
            return 1;
        } else {
            *remixmid = gconf_client_get_string (client, g_strconcat(PATH, REMIXMID, NULL), NULL);
            *remixsid = gconf_client_get_string (client, g_strconcat(PATH, REMIXSID, NULL), NULL);
        }
    }
    g_object_unref((gpointer)client);
    g_debug("init END");
    return 0;
}

/**
 * Get settings from GConf
 *
 * @param doc - response
 * @return 0 on success or 1 otherwise.
 */
int get_settings(xmlDocPtr doc)
{
    g_debug("get_settings START");

    GConfClient* client;
    gchar* login;
    gchar* password;
    gint status = 0, autoupdate = 0;
    xmlNodePtr rootNode, childNode, node;
    
    rootNode = xmlDocGetRootElement(doc);
    rootNode = rootNode->children;
    
    client = gconf_client_get_default ();
    status = gconf_client_get_int (client, g_strconcat(PATH, STATUS, NULL), NULL);
    login = gconf_client_get_string (client, g_strconcat(PATH, LOGIN, NULL), NULL);
    password = gconf_client_get_string (client, g_strconcat(PATH, PASSWORD, NULL), NULL);
    autoupdate = gconf_client_get_int (client, g_strconcat(PATH, AUTOUPDATE, NULL) , NULL);
    
    childNode = xmlNewDocNode(doc, NULL, BAD_CAST STRING, login);
    xmlSetProp(childNode, NAME, LOGIN);
    childNode = xmlAddChild(rootNode, childNode);
    
    childNode = xmlNewDocNode(doc, NULL, BAD_CAST STRING, password);
    xmlSetProp(childNode, NAME, PASSWORD);
    childNode = xmlAddChild(rootNode, childNode);
    
    childNode = xmlNewDocNode(doc, NULL, BAD_CAST NUMBER, g_strdup_printf("%d",autoupdate));
    xmlSetProp(childNode, NAME, AUTOUPDATE);
    childNode = xmlAddChild(rootNode, childNode);
    
    childNode = xmlNewDocNode(doc, NULL, BAD_CAST BOOLEAN, g_strdup_printf("%d",status));
    xmlSetProp(childNode, NAME, STATUS);
    childNode = xmlAddChild(rootNode, childNode);

    g_debug("get_settings END");
   return 0;
}

/**
 * Set settings in GConf 
 *
 * @param reqXml - request
 * @param doc - response
* @return 0 on success or 1 otherwise.
 */
int set_settings (xmlDocPtr reqXml, xmlDocPtr doc, msa_driver_info* info)
{
    g_debug("set_settings START");

    GConfClient* client;
    gboolean checked = 1;
    int status = 0;
    gchar* path;
    gchar* temp;
    xmlNodePtr rootNode, childNode, node;

    client = gconf_client_get_default ();
    rootNode = xmlDocGetRootElement(reqXml);
    rootNode = rootNode->children;
    rootNode = rootNode->children;

    while(rootNode != NULL) {
        g_debug("%s", rootNode->name);
        if (strcmp(xmlGetProp(rootNode, NAME),LOGIN) == 0) {
            path = g_strconcat(PATH, LOGIN, NULL);
            temp = xmlNodeGetContent(rootNode);	    
            checked = gconf_client_set_string (client, path, temp, NULL);
            g_free(path);    
	    g_free(temp);
        }
        if (strcmp(xmlGetProp(rootNode, NAME),PASSWORD) == 0) {
            path = g_strconcat(PATH, PASSWORD, NULL);
	    temp = xmlNodeGetContent(rootNode);
            checked = gconf_client_set_string (client, path, temp, NULL);
            g_free(path);
	    g_free(temp);
        }
        if (strcmp(xmlGetProp(rootNode, NAME),AUTOUPDATE) == 0) {
            int time = 0;
	    temp = (char*)xmlNodeGetContent(rootNode);
            time = atoi(temp);
            path = g_strconcat(PATH, AUTOUPDATE, NULL);
            checked = gconf_client_set_int (client, path, time, NULL);
#ifndef TEST
	    init_event_manager(time);
#endif   
            g_free(path);
	    g_free(temp);
        }
        if (strcmp(xmlGetProp(rootNode, NAME),STATUS) == 0) {
            path = g_strconcat(PATH, STATUS, NULL);
	    temp = xmlNodeGetContent(rootNode);
#ifndef TEST
            info->status = atoi(temp);
#endif
            checked = gconf_client_set_int (client, path, atoi(temp), NULL);
            g_free(path);
	    g_free(temp);
        }
        rootNode = rootNode->next;

        if(!checked)
            status = 1;
    }
    path = g_strconcat(PATH, REMIXMID, NULL);
    gconf_client_unset(client, path, NULL);
    g_free(path);
    path = g_strconcat(PATH, REMIXSID, NULL);
    gconf_client_unset(client, path, NULL);
    g_free(path);
    g_object_unref((gpointer)client);
    g_debug("set_settings END");

        return status;
}

/**
 * Authorization
 *
 * @param remixmid - auth parameter
 * @param remixsid - auth parameter
 * @param email - email
 * @param pass - password
 * @param cookies - file for cookies
 * @return 0 on success or 1 otherwise.
 */
int authorize(char *email, char *pass)
{
    g_type_init();
    FILE* fpin;
    int i;
    char *buf;
    char url[URL_SIZE];
    char mid[MID_SIZE], sid[MID_SIZE];
    char *tmp;
    char *resp;
    int code = 0;
    gchar* path;
    
    g_print("authorize START");
     GConfClient* client;
     client = gconf_client_get_default ();
    if ( email == NULL || pass == NULL) {
        g_debug("email = NULL");
        return 1;
    }
    //sprintf(url, "http://vkontakte.ru/login.php?email=%s&pass=%s", email, pass);
    sprintf(url, "http://login.userapi.com/auth?login=force&site=2&email=%s&pass=%s", email, pass);
    g_debug(" %s \n",url); // наш запрос
#ifdef TEST
    info_proxy = g_strdup("proxy.karelia.ru");
    info_port = 81;
#endif
    code = http_get(url, info_proxy, info_port, &buf, NULL); 
    if (code == 302) {
        g_debug("HEADER\n  %s", buf);
    
        if (buf != NULL) {
            tmp = NULL;
            tmp = g_strrstr(buf, "sid=") + 4;
            if(tmp == NULL) {
                g_debug("no sid");
                return 1;
            } else
                g_debug("sid found");
            sscanf(tmp, "%s", sid);
            sid[strlen(sid)] = '\0';
            if ( sid != NULL ) {
                path = g_strconcat(PATH, REMIXSID, NULL);    
                gconf_client_set_string (client, path, sid, NULL);
		g_free(path);
            } else 
                return 1;
            tmp = NULL;
            tmp = g_strrstr(buf, "remixmid=");
            if(tmp == NULL) {
                g_debug("no remixmid");
                path = g_strconcat(PATH, REMIXSID, NULL);
                gconf_client_unset(client, path, NULL);
                g_free(path);
                return 1;
            } else 
                tmp = tmp + 9;
            sscanf(tmp, "%s", mid);
            mid[strlen(mid)-1] = '\0';
            if( mid != NULL ) {
		path = g_strconcat(PATH, REMIXMID, NULL);
                gconf_client_set_string (client, path, mid, NULL);
		g_free(path);
            } else 
                return 1;
        } else 
            return 1;
    }
    else if (code == 200)
        return 1;
    else
        return 1;
   return 0;
}

/**
 * Get class of request
 *
 * @param reqXml - request
 * @return class of request.
 */
char* get_req_class(xmlDocPtr reqXml)
{
    xmlNodePtr rootNode;
    rootNode = xmlDocGetRootElement(reqXml);
   return xmlGetProp(rootNode, CLASS);
}

/**
 * Get function of request
 *
 * @param reqXml - request
 * @return function of request.
 */
char* get_req_function(xmlDocPtr reqXml)
{
    xmlNodePtr rootNode;
    rootNode = xmlDocGetRootElement(reqXml);
    return xmlGetProp(rootNode, FUNCTION);
}

int read_message(xmlDocPtr reqXml, char* remixmid, char* remixsid)
{
    g_debug("read_message START");
    xmlXPathObject *Obj;
    xmlNodePtr node, node2;
    char *id;
    char *url;
    char *tmp;
    Obj = xpath("//Response/Params/array/struct", reqXml);
    if (Obj != NULL) {
	node = Obj->nodesetval->nodeTab[0];
	for(node2 = node; node2 != NULL; node2 = node2->next) {
            id = xmlGetProp(node2, "id");
            url = g_strdup_printf("http://userapi.com/data?act=history&id=%s&read=%s_&sid=%s", remixmid, id+2, remixsid);
            http_get(url, info_proxy, info_port, NULL, &tmp );
            g_free(url);
	    g_debug("%s",tmp);
	}
	return 0;
    }
				
}
/**
 * Buil url for request
 *
 * @param reqXml - request
 * @param remixmid - authorization parameter
 * @param remixmid - authorization parameter
 * @return function of request.
 */
char* make_url(xmlDocPtr reqXml, char* remixmid, char* remixsid)
{
    g_debug("make_url START");
    char* url;
    const char* params[7];
    xmlDocPtr urlXml;
    xmlNodePtr root;
    //xmlDocDump(stdout, reqXml);

    params[0] = g_strdup("MID");
    params[1] = g_strdup_printf("\"%s\"", remixmid);
    params[2] = g_strdup("SID");
    params[3] = g_strdup_printf("\"%s\"", remixsid);
    params[4] = g_strdup("COUNTER");
    params[5] = g_strdup_printf("%d", counter);
    params[6] = NULL;

    xsltStylesheetPtr cur = NULL;

    cur = xsltParseStylesheetFile(XSL_URL);

    if(cur != NULL && reqXml != NULL) {
        urlXml = xsltApplyStylesheet(cur, reqXml, params);
        //xmlDocDump(stdout, urlXml);
    } else 
	return NULL;
    if (urlXml == NULL)
        return NULL;
    root = xmlDocGetRootElement(urlXml);
    if (root == NULL)
        return NULL;
    url = xmlNodeGetContent(root);
    xsltFreeStylesheet(cur);    
    xmlFreeDoc(urlXml);
    g_free((gpointer*)params[0]);
    g_free((gpointer*)params[1]);
    g_free((gpointer*)params[2]);
    g_free((gpointer*)params[3]);
    g_free((gpointer*)params[4]);
    g_free((gpointer*)params[5]);
    g_printf("%s",url);
    g_debug("make_url END");
    return url;
}


/**
 * Form INFO or ERROR message
 *
 * @param code - error code
 * @param doc - response (buffer for message)
 * @param message - text of message
 * @param type - 0 for info message or 1 for error message
* @return 0 on success or 1 otherwise.
 */
int info_message(char* code, xmlDocPtr doc, char* message, int type)
{
    xmlNodePtr rootNode, node, childNode;
    rootNode = xmlNewDocNode(doc, NULL,  "Response", NULL);
    xmlDocSetRootElement(doc, rootNode);

    xmlSetProp(rootNode, CLASS, "systemMessages");

    if (type == 1)
        xmlSetProp(rootNode, FUNCTION, "errorMessage");
    else if (type == 0)
        xmlSetProp(rootNode, FUNCTION, "infoMessage");
    else if (type == 2)
        xmlSetProp(rootNode, FUNCTION, "captchaMessage");
    else
        return 1;

    node = xmlNewDocNode(doc, NULL,   PARAMS,  NULL);
    childNode = xmlAddChild(rootNode, node);

    node = xmlNewDocNode(doc, NULL,   STRING,  DRIVER_NAME);
    xmlSetProp(node, NAME, "moduleName");
    node = xmlAddChild(childNode, node);

    node = xmlNewDocNode(doc, NULL,   STRING,  code);
    xmlSetProp(node, NAME, "code");
    node = xmlAddChild(childNode, node);

    node = xmlNewDocNode(doc, NULL,   STRING,  message);
    xmlSetProp(node, NAME, "text");
    node = xmlAddChild(childNode, node);
    return 0;
}

int captcha_message(xmlDocPtr doc, xmlDocPtr reqXml)
{
    guint32 cpatcha_sid = g_random_int_range(1,1000);
    char* captcha_image;
    captcha_image = get_captcha(cpatcha_sid);
    info_message("403", doc, DRV_CAPT_ERROR, 2);

    xmlNodePtr node_param, node, rootNode;
    xmlXPathObject *Obj;
    Obj = xpath("//Response/Params", doc);
    node_param = Obj->nodesetval->nodeTab[0];

    node = xmlNewDocNode(doc, NULL,   IMG, captcha_image);
    xmlSetProp(node, NAME, "Img");
    node = xmlAddChild(node_param, node);

    node = xmlNewDocNode(doc, NULL, STRING, NULL);
    xmlSetProp(node, NAME, "oldRequest");
    node = xmlAddChild(node_param, node);

    rootNode = xmlDocGetRootElement(reqXml);
    xmlUnlinkNode(rootNode);

    xmlAddChild(node, rootNode);

    Obj = xpath("//Response/Params/string[@name='oldRequest']/Request/Params", doc);
    node_param = Obj->nodesetval->nodeTab[0];

    if (node_param == NULL)
        g_debug("node_param == NULL");
    else {
        Obj = xpath("//Response/Params/string[@name='oldRequest']/Request/Params/string[@name='fcsid']", doc);
        if (Obj->nodesetval->nodeNr != 0) {
            node = Obj->nodesetval->nodeTab[0];
            xmlNodeSetContent(node, g_strdup_printf("%d",cpatcha_sid));
        } else {
            node = xmlNewDocNode(doc, NULL, STRING, g_strdup_printf("%d",cpatcha_sid));
            xmlSetProp(node, NAME, "fcsid");
            node = xmlAddChild(node_param, node);
        
            node = xmlNewDocNode(doc, NULL, STRING, NULL);
            xmlSetProp(node, NAME, "fccode");
            node = xmlAddChild(node_param, node);
        }
    }
    return 0;
}

/**
 * Perform HTTP GET request
 *
 * @param reqXml - request
 * @param proxy - proxy address 
 * @param port - proxy port
 * @param header - buffer for header of response
 * @param body - buffer for body of response
 * @param type - type of request data (image, text)
 * @return http server response code 
 */
int http_get(const char* url, const char* proxy, long port, char** header, char** body)
{
    CURL* c;
    CURLcode code;
    char* type2;
    struct MemoryStruct chunk,chunk2;
    
    chunk.memory = NULL; 
    chunk.size = 0;

    chunk2.memory = NULL; 
    chunk2.size = 0;

    c = curl_easy_init();
    g_print("url in http_get %s", url);

    curl_easy_setopt(c, CURLOPT_URL, url);

    curl_easy_setopt(c, CURLOPT_PROXY, proxy);
    curl_easy_setopt(c, CURLOPT_PROXYPORT, port);
    curl_easy_setopt(c, CURLOPT_TIMEOUT, 120);

    curl_easy_setopt(c, CURLOPT_WRITEFUNCTION, WriteMemoryCallback);
    curl_easy_setopt(c, CURLOPT_HEADERFUNCTION, WriteMemoryCallback);

    curl_easy_setopt(c, CURLOPT_WRITEDATA, (void *)&chunk);
    curl_easy_setopt(c, CURLOPT_WRITEHEADER, (void *)&chunk2);
    g_debug("send request");

    if (curl_easy_perform(c) != 0) {
        fprintf(stderr, "Can't perform the request\n");
        return 400;
    }


    curl_easy_getinfo(c, CURLINFO_RESPONSE_CODE, &code );
    g_debug("CODE %d", code);

    type2 = malloc(sizeof(char)*50);
    curl_easy_getinfo(c, CURLINFO_CONTENT_TYPE, &type2 );
    g_debug("TYPE %s", type2);

    if (header != NULL) {
        *header = chunk2.memory;
    }

    g_print("HEADER  %s\n", chunk2.memory);

    if (body != NULL) {
        if (strcmp(type2, "image/jpeg") == 0) {
            *body = g_base64_encode (chunk.memory, chunk.size);
            g_free(chunk.memory);
        } else {
        *body = chunk.memory;
        }
    }
    //g_print("CONTENT  %s\n", chunk.memory);

    curl_easy_cleanup(c);
    return code;
}

/**
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
xmlXPathObject* xpath(char* req, xmlDocPtr doc)
{
	xmlXPathObject *Obj;
	xmlXPathContextPtr Ctx;
	
	g_debug("vk_xpath: %s", req);

	Ctx = xmlXPathNewContext(doc);
	
	if (Ctx == NULL) {
		g_debug("vk_xpath: error wrong request format!");
		return NULL;	
	}

	Obj = xmlXPathEvalExpression(req, Ctx);

	g_debug("vk_xpath: end");

	xmlFree(Ctx);

	return Obj;

}
