%define     revision 1

Name:       mysocials-gallery
Summary:    Application for browsing images from social networks.
Version:    1.1.9
Release:    %{revision}
Group:      Multimedia/Graphics
License:    GPL v2+
URL:        http://mgallery.garage.maemo.org
Source0:    %{name}_%{version}-%{revision}.tar.gz
BuildRoot:  %{_tmppath}/%{name}-root
 
%if 0%{?suse_version}  
BuildRequires:  update-desktop-files
BuildRequires:  libqt4-devel >= 4.6.0  
BuildRequires:  libQtWebKit-devel
Requires:       libQtWebKit4
Requires:       libqt4 >= 4.6.0
%endif  

%if 0%{?rhel_version} || 0%{?centos_version}
BuildRequires:  qt4-devel
BuildRequires:  gcc-c++
Requires:       qt4
%endif

%if 0%{?mdkversion}
BuildRequires:  qt4-devel
BuildRequires:  gcc-c++
Requires:       qt4-common
%endif

%if 0%{?fedora_version}
BuildRequires:  qt4-devel
BuildRequires:  qt4-x11
BuildRequires:  gcc-c++
Requires:       qt4
%if 0%{?fedora_version} < 14
Requires:       qt4-x11
%else
Requires:       qt4-webkit
BuildRequires:  qt-webkit-devel
%endif
%endif



%if "0%{?meego_version}" != "0"
BuildRequires:  libqt-devel
BuildRequires:  libqtwebkit-devel
Requires:       qt
%endif

BuildRequires:  libnotify-devel
BuildRequires:  pkgconfig(gtk+-2.0)
%if "0%{?meego_version}" != "0"
Requires:	libnotify
%else
Requires:       libnotify1
%endif

%if 0%{?fedora_version}
BuildRequires:  desktop-notification-daemon
BuildRequires:  notification-daemon
%endif

%if 0%{?mdkversion}
BuildRequires:	polkit-gnome
%endif

BuildRequires:  pkgconfig(glib-2.0)
BuildRequires:  pkgconfig(libxml-2.0) >= 2.6.32

BuildRequires:  mysocials-core-devel >= 1.2.0
Requires:       mysocials-core >= 1.2.0
Requires:       libmsavk0 >= 0.4.8
Requires:       libmsafl0 >= 0.1.5
Requires:       libmsamm0 >= 0.1.4

AutoReqProv:    1
#Requires(post):
 
%description
The application for browsing images from different social networks (i.e. Facebook and VKontakte).
It shows list of friends, their albums and it's content. Each image can be shown on fullscreen.
Application based on drivers of MySocials projects.
 
 
 
%prep
%setup -q -n %{name}-%{version}
 
# >> setup
# << setup
 
%build
# >> build pre
export PATH=/usr/lib/qt4/bin:$PATH

%if 0%{?mdkversion} > 2006  
export PATH=/usr/lib/qt4/bin:$PATH  
export QTDIR=%{_prefix}/lib/qt4/  
%endif  

%if 0%{?fedora_version} || 0%{?centos_version}
qmake-qt4  PREFIX=%{_prefix}
%else
qmake PREFIX=%{_prefix}
%endif

%__make

%install
export INSTALL_ROOT=%{buildroot} 
  
%if 0%{?mdkversion} || 0%{?fedora_version} < 13
make install
%else
%make_install
%endif
 
%if 0%{?suse_version}  
%suse_update_desktop_file msagallery Graphics Viewer
%endif

%post
 
%postun
 
%files
%defattr(-,root,root,-)
%{_bindir}/*
%{_datadir}/qt4/translations/*.qm
%{_datadir}/applications/*
%dir %{_datadir}/icons/hicolor
%dir %{_datadir}/icons/hicolor/26x26
%dir %{_datadir}/icons/hicolor/26x26/apps
%{_datadir}/icons/hicolor/26x26/apps/*
%dir %{_datadir}/icons/hicolor/40x40
%dir %{_datadir}/icons/hicolor/40x40/apps
%{_datadir}/icons/hicolor/40x40/apps/*
%dir %{_datadir}/icons/hicolor/48x48
%dir %{_datadir}/icons/hicolor/48x48/apps
%{_datadir}/icons/hicolor/48x48/apps/*
%dir %{_datadir}/icons/hicolor/64x64
%dir %{_datadir}/icons/hicolor/64x64/apps
%{_datadir}/icons/hicolor/64x64/apps/*
%dir %{_datadir}/pixmaps
%{_datadir}/pixmaps/*
%dir %{_datadir}/doc/%{name}/
%{_datadir}/doc/%{name}/*
