#include "uiapplicationsettings.h"
#include "ui_uiapplicationsettings.h"

UIApplicationSettings::UIApplicationSettings(ServiceMgr *sm, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::UIApplicationSettings)
{
    ui->setupUi(this);
    this->sm = sm;

    ui->cbRotateWindow->setChecked(this->sm->settings->value(SETTINGS_AUTOROTATE).toBool());
    ui->cbMultiPanel->setChecked(this->sm->settings->value(SETTINGS_MULTIPANEL).toBool());
}

UIApplicationSettings::~UIApplicationSettings()
{
    delete ui;
}

void UIApplicationSettings::on_buttonBox_accepted() {
    this->sm->settings->setValue(SETTINGS_AUTOROTATE, ui->cbRotateWindow->isChecked());
    this->sm->settings->setValue(SETTINGS_MULTIPANEL, ui->cbMultiPanel->isChecked());
    emit updateSettings();
}

void UIApplicationSettings::on_btnClearCache_clicked()
{
    this->sm->clearCache();
    this->on_buttonBox_accepted();
}
