#ifndef VKGALLERY_H
#define VKGALLERY_H

#ifdef ENABLE_NOTIFY
#include <libnotify/notify.h>
#endif

#include <QMainWindow>
#include <QDebug>
#include <QPushButton>
#include <QListWidgetItem>
#include <QList>
#include <QLabel>
#include <QRadioButton>
#include <QShortcut>


#ifdef Q_WS_MAEMO_5
#include "utils/fullscreenexitbutton.h"
#include <QtDBus>
/*
#define __GTK_BINDINGS_H__ //gtkbindings.h:79 has colliding symbol "signal"
extern "C" {
#include <hildon/hildon-banner.h>
}
#undef __GTK_BINDINGS_H__
*/
#endif

#include "widgets/uiaccountsettings.h"
#include "widgets/uinetworksettings.h"
#include "widgets/qphotouploader.h"
#include "ui/uiapplicationsettings.h"
#include "widgets/uihelp.h"
#include "ui_vkgallery.h"
//#include "item.h"
#include "widgets/qimageviewer.h"
#include <servicemgr.h>
#include <panels/imagebrowserpanel.h>

#ifdef TARGET
    #define APP_NAME TARGET
#else
    #define APP_NAME "mysocials-gallery"
#endif

namespace Ui {
    class VKGallery;
}

class VKGallery : public QMainWindow {
    Q_OBJECT
public:
    VKGallery(QWidget *parent = 0);
    ~VKGallery();

signals:
    void closeDialogs();

protected:
    void changeEvent(QEvent *e);
    void closeEvent(QCloseEvent *e); 

private:
    QFont usedFont;

    Ui::VKGallery *ui;

    ImageBrowserPanel *panel;

    void init();
    //void ownrChanged();
    void createMenus();

#ifdef Q_WS_MAEMO_5
    FullScreenExitButton *fullScreenButton;
#endif

    ServiceMgr *sm;

private slots:
    void actionAccSettings_toggled();
    void actionNetSettings_toggled();
    void actionAppSettings_toggled();

    void actionFull_screen_toggled();
    void actionUploadPhoto_toggled();

    void help();
    void about();

    void settingsUpdated();
    void openImage(Photo photo);

    void gotErrorMsg(QString errorMsg, QTransport::Action acc, bool isMajor);
};

#endif // VKGALLERY_H
